package loader

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.testbench.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.startup.CCSBuilder ;


import static org.lsst.gruth.jutils.MapArgs.*

def filterSensorsDIOName = "plutoGateway" // to monitor the loader sensors

CCSBuilder builder = ["LPSC test bench"]

builder.
        "Main Module" ( org.lsst.ccs.subsystems.fcs.testbench.LPSCTestBenchMainModule,
                argMap(a("name", "main"),
                        anInt("tickMillis", 3000),
                        ref("bridge")))
                 


            //begin description of Main submodules
            {       

                // Bridge
                bridge (anImpl(BridgeToHardware, BridgeForLPSCTestBench),
                        argMap(aString("name", "bridge"),
                            anInt("tickMillis", 1000),
                            ref("tcpProxy"),
                            ref("hooksController"),
                            ref("carrierController"),
                            ref("plutoGateway")))

                {//begin description of bridge's children          

                        // tcp Proxy
                        tcpProxy (CanOpenProxy,
                                argMap(aString("name", "tcpProxy"),
                                    anInt("tickMillis", 1000),
                                    anInt("portNumber", 50000,[static:true, constraints:1024..99000]),
                                    aString("myClientName","TestBench",[static:true]),
                                    anInt("expectedNodesNB", 3, [static:true,description:"The number of can open nodes that we have on this can bus.",constraints:1..127]),
                                    anInt("hardwareBootTimeout",2000, [description:"A timeout for the harwdare booting process",constraints:1000..10000])))

                        hooksController (anImpl(Actuator, CanOpenEPOS24),
                                argMap( aString("name", "hooksController"),
                                anInt("tickMillis",3000),
                                aString("nodeID","1b", [static:true, description:"can open node ID in HEXADECIMAL for EPOS24/50 for loader hook motor"]),
                                aString("serialNB","79007141", [static:true, description:"EPOS24/50 serial number for the hook motor controller"]),
                                //aRef("motor","hooksMotor"),
                                aMap("paramsForCurrent", [ContinuousCurrentLimit:500,OutputCurrentLimit:1000,
                                    MaxSpeedInCurrentMode:500,
                                    MotorType:11,PolePairNumber:8,PositionSensorType:3]),
                                aMap("paramsForProfilePosition", [MinPositionLimit:-100,MaxPositionLimit:491000,MotionProfileType:0]),
                                aMap("paramsForHoming",[HomeOffset:0]),
                                aVal("mode", CanOpenEPOS.EposMode.CURRENT),
                                anInt("currentValue", -200),)) 

                            {//begin description of hook controller's children
//                                "hooksMotor"(org.lsst.ccs.subsystems.fcs.drivers.Motor,                                       argMap(aString("name","hooksMotor"),
 //                                               anInt("motorType",11),
 //                                               anInt("positionSensorType", 3),
 //                                               anInt("continuousCurrentLimit",500),
  //                                              anInt("maxSpeedInCurrentMode", 500),
  //                                              anInt("thermalTimeConstantWinding", 160),
 //                                               anInt("outputCurrentLimit", 1000) ,
 //                                               anInt("polePairNumber", 8),
 //                                               anInt("currentValue", -200),
 //                                               anInt("currentValueToMaintain", 200)))
                            }//end description of hooks controller's children
                        
                        carrierController (anImpl(Actuator, CanOpenEPOS70),
                                argMap( aString("name", "carrierController"),
                                anInt("tickMillis",3000),
                                aString("nodeID","1a", [static:true, description:"can open node ID in HEXADECIMAL for EPOS70/10 for loader carrier motor"]),
                                aString("serialNB","80003184", [static:true, description:"EPOS24 serial number for the carrier motor controller"]),
                                //aRef("motor","carrierMotor"),
                                aMap("paramsForCurrent", [ContinuousCurrentLimit:500,OutputCurrentLimit:1000,MaxSpeedInCurrentMode:500,
                                    MotorType:10,PositionSensorType:1,ThermalTimeConstantWinding:17,PolePairNumber:1]),
                                aMap("paramsForProfilePosition", [MinPositionLimit:-100,MaxPositionLimit:491000,MotionProfileType:0]),
                                aMap("paramsForHoming",[HomeOffset:0]),
                                aVal("mode", CanOpenEPOS.EposMode.CURRENT),
                                anInt("currentValue", -200),
                                ))



                            {//begin description of carrier controller's children
//                                "carrierMotor"(org.lsst.ccs.subsystems.fcs.drivers.Motor,
 //                                       argMap(aString("name","carrierMotor"),
 //                                               anInt("motorType",10),
 //                                               anInt("positionSensorType", 1),
//                                                anInt("continuousCurrentLimit",500),
//                                                anInt("maxSpeedInCurrentMode", 500),
//                                                anInt("thermalTimeConstantWinding", 17),
 //                                               anInt("outputCurrentLimit", 1000) ,
//                                                anInt("polePairNumber", 1),
 //                                               anInt("currentValue", -200),
 //                                               anInt("currentValueToMaintain", 200)))
                            }//end description of carrier controller's children

                        // can open devices
                        plutoGateway (CanOpenPlutoGateway, 
                                argMap(aString("name", "plutoGateway"),
                                    anInt("tickMillis", 1000),
                                    aString("nodeID","1"),
                                    aString("serialNB","22d6")))


                            
                }//end description of bridge's childrens
                
                //begin description of loader
                loader (LoaderModule,
                        argMap(aString("name", "loader"),
                        anInt("tickMillis", 1000),
                        ref("carrier"),
                        ref("clamp"),
                        ))

                        {//begin description of loader's children

                            carrier(LoaderCarrierModule,
                                argMap(aString("name", "carrier"),
                                        anInt("tickMillis", 1000),
                                ))
                                {//begin description of loader carrier's children
                                }//end description of loader carrier's children

                            clamp(LoaderClampModule,
                                argMap(aString("name", "clamp"),
                                        anInt("tickMillis", 1000),
                                        anInt("timeoutForClosingHooks",10000,[description:"timeout in milliseconds : if closing the hook last more than this amount of time, then the subsystem goes in ERROR."]),
                                        anInt("timeoutForClampingHooks",1500,[description:"timeout in milliseconds : if closing strongly the hook last more than this amount of time, then the subsystem goes in ERROR."]),
                                        anInt("timeoutForOpeningHooks",10000,[description:"timeout in milliseconds : if opening the hook last more than this amount of time, then the subsystem goes in ERROR."]),
                                        anInt("timeoutForGoingToHomePosition",10000,[description:"timeout in milliseconds : if the action of hoing to home position last more than this amount of time, then the subsystem goes in ERROR."]),
                                        anInt("minPosition",0,[description:"min position value used by the GUI"]),
                                        anInt("maxPosition",500000,[description:"max position value used by the GUI"]),
                                        anInt("targetPositionToOpen",5000,[description:"target encoder absolut value in qc to open"]),
                                        anInt("targetPositionToClose",440000,[description:"target encoder absolut value in qc when hooks are LOCKED"]),
                                        anInt("targetPositionToClamp",488000,[description:"target encoder absolut value in qc when hooks are CLAMPED"]),
                                        anInt("currentToClose",390,[description:"current to close in initialisation phase, in mA"]),
                                        anInt("currentToGoHome",-200,[description:"current to go to home position in initialisation phase, in mA"]),                                       
                                        aMap("paramsForCurrentToClose", [ContinuousCurrentLimit:500,OutputCurrentLimit:1000,MaxSpeedInCurrentMode:500],[description:"list of parameters for CURRENT mode to close the clamp in the initialisation phase."]),
                                        aMap("paramsForCurrentToGoHome", [ContinuousCurrentLimit:500,OutputCurrentLimit:1000,MaxSpeedInCurrentMode:500],[description:"list of parameters for CURRENT mode to open the clamp in the initialisation phase."]),                                       
                                        ref("hook1"),
                                        ref("hook2"),
                                        ref("hook3"),
                                        ref("hook4"),
                                ))
                                {//begin description of loader clamp's children
                                    hook1(LoaderHookModule,
                                        argMap(aString("name", "hook1"),
                                        ref("lockSensor1"),
                                        ref("unlockSensor1"),
                                    ))
                                    {//begin description of hook1's children
                                        "lockSensor1" ( anImpl( NumericSensor,PlutoGWSensor) ,
                                            argMap(a ("name", "lockSensor1") ,
                                            aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 8, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:1..8]),
                                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:1..8])))
                                        "unlockSensor1" ( anImpl( NumericSensor,PlutoGWSensor) ,
                                            argMap(a ("name", "unlockSensor1") ,
                                            aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 4, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:1..8]),
                                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:1..8])))
                                    }//end description of hook1's children

                                    hook2(LoaderHookModule,
                                        argMap(aString("name", "hook2"),
                                        ref("lockSensor2"),
                                        ref("unlockSensor2"),
                                    ))
                                    {//begin description of hook2's children
                                        "lockSensor2" ( anImpl( NumericSensor,PlutoGWSensor) ,
                                            argMap(a ("name", "lockSensor2") ,
                                            aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 1, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:1..8]),
                                            anInt("byteNumero", 2, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:1..8])))
                                        "unlockSensor2" ( anImpl( NumericSensor,PlutoGWSensor) ,
                                            argMap(a ("name", "unlockSensor2") ,
                                            aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 5, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:1..8]),
                                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:1..8])))
                                    }//end description of hook2's children

                                    hook3(LoaderHookModule,
                                        argMap(aString("name", "hook3"),
                                        ref("lockSensor3"),
                                        ref("unlockSensor3"),
                                    ))
                                    {//begin description of hook3's children
                                        "lockSensor3" ( anImpl( NumericSensor,PlutoGWSensor) ,
                                            argMap(a ("name", "lockSensor3") ,
                                            aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 2, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:1..8]),
                                            anInt("byteNumero", 2, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:1..8])))
                                        "unlockSensor3" ( anImpl( NumericSensor,PlutoGWSensor) ,
                                            argMap(a ("name", "unlockSensor3") ,
                                            aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 6, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:1..8]),
                                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:1..8])))
                                    }//end description of hook3's children

                                    hook4(LoaderHookModule,
                                        argMap(aString("name", "hook4"),
                                        ref("lockSensor4"),
                                        ref("unlockSensor4"),
                                    ))
                                    {//begin description of hook4's children
                                        "lockSensor4" ( anImpl( NumericSensor,PlutoGWSensor) ,
                                            argMap(a ("name", "lockSensor4") ,
                                            aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 3, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:1..8]),
                                            anInt("byteNumero", 2, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:1..8])))
                                        "unlockSensor4" ( anImpl( NumericSensor,PlutoGWSensor) ,
                                            argMap(a ("name", "unlockSensor4") ,
                                            aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 7, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:1..8]),
                                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:1..8])))
                                    }//end description of hook4's children
                                }//end description of loader clamp's children

                        }//end description of loader's children

            }//end description of Main submodules

                


