/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.HygrometryGauge;
import org.lsst.ccs.subsystems.fcs.common.PressureGauge;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.testbench.CanOpenLED;

public class LPCTestBenchMainModule
extends MainModule {
    private final HygrometryGauge hygrometrySensor;
    private final PressureGauge pressureSensor;
    private final Thermometer thermometer;
    private final CanOpenLED led;
    private final CanOpenLED fakeLed;
    private final Thermometer fakeSensor;
    public double temperature;
    public double pressure;
    public double hygrometry;

    public LPCTestBenchMainModule(String aName, int aTickMillis, BridgeToHardware bridge, HygrometryGauge hygrometrySensor, PressureGauge pressureSensor, Thermometer thermometer, CanOpenLED led, CanOpenLED fakeLed, Thermometer fakeSensor) {
        super(aName, aTickMillis, bridge);
        this.hygrometrySensor = hygrometrySensor;
        this.pressureSensor = pressureSensor;
        this.thermometer = thermometer;
        this.led = led;
        this.fakeLed = fakeLed;
        this.fakeSensor = fakeSensor;
    }

    public double readHygrometry() throws HardwareException {
        this.hygrometry = this.hygrometrySensor.readHygrometry();
        return this.hygrometry;
    }

    public double readPressure() throws HardwareException {
        this.pressure = this.pressureSensor.readPressure();
        return this.pressure;
    }

    public double readTemperature() throws HardwareException {
        this.temperature = this.thermometer.readTemperature();
        return this.temperature;
    }

    public String turnOnLED() throws SDORequestException, HardwareNotDetectedException {
        return this.led.turnON();
    }

    public String turnOffLED() throws SDORequestException, HardwareNotDetectedException {
        return this.led.turnOFF();
    }

    public String turnOnFakeLED() throws SDORequestException, HardwareNotDetectedException {
        return this.fakeLed.turnON();
    }

    public String turnOffFakeLED() throws SDORequestException, HardwareNotDetectedException {
        return this.fakeLed.turnOFF();
    }

    public double readFakeSensor() throws HardwareException, BadCommandException {
        return this.fakeSensor.readTemperature();
    }

    public void tick() {
        try {
            this.readTemperature();
            this.readPressure();
            this.readHygrometry();
            this.publish("temperature", this.temperature);
            this.publish("hygrometry", this.hygrometry);
            this.publish("pressure", this.pressure);
        }
        catch (HardwareException hardwareException) {
            log.debug((Object)(String.valueOf(this.getName()) + "couldn't read sensors"), new String[0]);
        }
    }
}

