/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.subsystems.fcs.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.simulation.SimuPlutoGWSensor;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class SimuPlutoGateway
extends PlutoGatewayModule {
    SimuPlutoGWSensor lockSensor1;
    SimuPlutoGWSensor unlockSensor1;
    SimuPlutoGWSensor lockSensor2;
    SimuPlutoGWSensor unlockSensor2;
    SimuPlutoGWSensor lockSensor3;
    SimuPlutoGWSensor unlockSensor3;
    SimuPlutoGWSensor lockSensor4;
    SimuPlutoGWSensor unlockSensor4;

    public SimuPlutoGateway(String string, int i) {
        super(string, i);
    }

    @Override
    public void initModule() {
        super.initModule();
        this.hexaValues[0] = "78";
        this.hexaValues[1] = "00";
        this.lockSensor1 = (SimuPlutoGWSensor)this.getModule("lockSensor1");
        this.lockSensor2 = (SimuPlutoGWSensor)this.getModule("lockSensor2");
        this.lockSensor3 = (SimuPlutoGWSensor)this.getModule("lockSensor3");
        this.lockSensor4 = (SimuPlutoGWSensor)this.getModule("lockSensor4");
        this.unlockSensor1 = (SimuPlutoGWSensor)this.getModule("unlockSensor1");
        this.unlockSensor2 = (SimuPlutoGWSensor)this.getModule("unlockSensor2");
        this.unlockSensor3 = (SimuPlutoGWSensor)this.getModule("unlockSensor3");
        this.unlockSensor4 = (SimuPlutoGWSensor)this.getModule("unlockSensor4");
        this.simulateLoaderClampIsUnLocked();
    }

    @Override
    public String[] readNewHexaValues() {
        return this.hexaValues;
    }

    public void simulateLoaderClampIsLocked() {
        this.simulateHookIsLocked(this.lockSensor1, this.unlockSensor1);
        this.simulateHookIsLocked(this.lockSensor2, this.unlockSensor2);
        this.simulateHookIsLocked(this.lockSensor3, this.unlockSensor3);
        this.simulateHookIsLocked(this.lockSensor4, this.unlockSensor4);
    }

    public void simulateLoaderClampIsUnLocked() {
        this.simulateHookIsUnlocked(this.lockSensor1, this.unlockSensor1);
        this.simulateHookIsUnlocked(this.lockSensor2, this.unlockSensor2);
        this.simulateHookIsUnlocked(this.lockSensor3, this.unlockSensor3);
        this.simulateHookIsUnlocked(this.lockSensor4, this.unlockSensor4);
    }

    public void simulateHookIsLocked(SimuPlutoGWSensor lockSensor, SimuPlutoGWSensor unlockSensor) {
        this.replaceDigitalValues(lockSensor, "1");
        this.replaceDigitalValues(unlockSensor, "0");
    }

    public void simulateHookIsUnlocked(SimuPlutoGWSensor lockSensor, SimuPlutoGWSensor unlockSensor) {
        this.replaceDigitalValues(lockSensor, "0");
        this.replaceDigitalValues(unlockSensor, "1");
    }

    void simulateLoaderClampIsLockedStrongly() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void replaceDigitalValues(SimuPlutoGWSensor sensor, String digitalValue) {
        this.lock.lock();
        try {
            this.updatingValues = true;
            int byteNo = sensor.getByteNumero() - 1;
            log.debug((Object)(String.valueOf(this.getName()) + "=> old hexa value = " + this.hexaValues[byteNo]), new String[0]);
            StringBuilder bin = new StringBuilder(FcsUtils.hexToBinary(this.hexaValues[byteNo]));
            bin.replace(8 - sensor.getInputNumero(), 8 - sensor.getInputNumero() + 1, digitalValue);
            String newDIOHexaValue = Integer.toHexString(Integer.parseInt(bin.toString(), 2));
            log.debug((Object)(String.valueOf(this.getName()) + "=> new hexa value =" + newDIOHexaValue), new String[0]);
            this.hexaValues[byteNo] = newDIOHexaValue;
            log.debug((Object)(String.valueOf(this.getName()) + " HEXA VALUE READ: hexaValues[0]=" + this.hexaValues[0] + " hexaValues[1]=" + this.hexaValues[1]), new String[0]);
        }
        finally {
            this.updatingValues = false;
            this.valueUpdated.signal();
            this.lock.unlock();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/byte no1=");
        sb.append(this.hexaValues[0]);
        sb.append("/byte no2=");
        sb.append(this.hexaValues[1]);
        return sb.toString();
    }
}

