/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Random;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.bus.KVList;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClampActuator;
import org.lsst.ccs.subsystems.fcs.common.Actuator;
import org.lsst.ccs.subsystems.fcs.simulation.SimuClampLockSensor;
import org.lsst.ccs.subsystems.fcs.simulation.SimuFilterClampModule;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class SimuClampActuatorModule
extends Module
implements Actuator {
    public boolean on;
    public int readValue;
    public int sentValue;
    public int sentCurrentMinValue;
    public int sentCurrentMaxValue;
    Random r = new Random();
    CarouselModule carousel;

    @Override
    public boolean isOn() {
        return this.on;
    }

    @Override
    public boolean isOff() {
        return !this.on;
    }

    @Override
    public int getReadValue() {
        return this.readValue;
    }

    @Override
    public int getSentCurrentMinValue() {
        return this.sentCurrentMinValue;
    }

    @Override
    public int getSentCurrentMaxValue() {
        return this.sentCurrentMaxValue;
    }

    public void initModule() {
        this.on = false;
        this.carousel = (CarouselModule)this.getModule("carousel");
    }

    @Override
    public String on() throws BadCommandException, ErrorInCommandExecutionException {
        SimuFilterClampModule clamp;
        this.on = true;
        log.debug((Object)(String.valueOf(this.getName()) + "==========> ACTUATOR ON"), new String[0]);
        if (this.getName().contains("Xminus")) {
            clamp = (SimuFilterClampModule)this.carousel.getClampXminus();
        } else if (this.getName().contains("Xplus")) {
            clamp = (SimuFilterClampModule)this.carousel.getClampXplus();
        } else {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + ": unable to find the clamp to unlock.");
        }
        ((SimuClampLockSensor)clamp.getLockSensor()).simulateClampIsUNLOCKED(clamp);
        this.sentValue = 500;
        this.publishData();
        return String.valueOf(this.getName()) + " is turned ON.";
    }

    @Override
    public String off() throws BadCommandException, ErrorInCommandExecutionException {
        SimuFilterClampModule clamp;
        this.on = false;
        log.debug((Object)(String.valueOf(this.getName()) + "==========> ACTUATOR OFF"), new String[0]);
        if (this.getName().contains("Xminus")) {
            clamp = (SimuFilterClampModule)this.carousel.getClampXminus();
        } else if (this.getName().contains("Xplus")) {
            clamp = (SimuFilterClampModule)this.carousel.getClampXplus();
        } else {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + ": unable to find the clamp to unlock.");
        }
        ((SimuClampLockSensor)clamp.getLockSensor()).simulateClampIsLOCKED(clamp);
        this.sentValue = 0;
        this.publishData();
        return String.valueOf(this.getName()) + " is turned OFF.";
    }

    @Override
    public int getSentValue() {
        if (this.sentCurrentMinValue >= 0) {
            if (this.sentCurrentMaxValue > 0) {
                return this.r.nextInt(this.sentCurrentMaxValue);
            }
            String msg = String.valueOf(this.getName()) + ": ERROR in getSentValue: getSentCurrentMaxValue() should be positive";
            throw new IllegalArgumentException(msg);
        }
        return (int)this.r.nextGaussian() * this.sentCurrentMaxValue / 2;
    }

    public void tick() {
    }

    public String maintainUnclamped() throws BadCommandException, ErrorInCommandExecutionException {
        return String.valueOf(this.getName()) + "Maintaining Current";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        if (this.isOn()) {
            sb.append(" is ON");
        } else {
            sb.append(" is OFF");
        }
        return sb.toString();
    }

    public StatusDataPublishedByClampActuator getStatusData() {
        return FcsUtils.createStatusDataPublishedByClampActuator(this);
    }

    @Deprecated
    public void publishActuatorData() {
        KVList kvlist = new KVList(7);
        long timestamp = System.currentTimeMillis();
        kvlist.add("dataType", (Object)"carouselClampActuator");
        kvlist.add(String.valueOf(this.getName()) + "/sentValue", (Object)this.sentValue);
        this.publish(timestamp, kvlist);
    }

    public void publishData() {
        StatusDataPublishedByClampActuator status = this.getStatusData();
        this.publish("actuator", status);
    }
}

