/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

public class CanOpenPlutoGateway
extends PlutoGatewayModule
implements PieceOfHardware {
    CanOpenProxy tcpProxy;
    String serialNB;
    String nodeID;
    boolean initialized;

    public CanOpenPlutoGateway(String string, int i, String nodeID, String serialNB) {
        super(string, i);
        this.nodeID = nodeID;
        this.serialNB = serialNB;
        this.initialized = false;
    }

    @Override
    public String getSerialNB() {
        return this.serialNB;
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    @Override
    public boolean isNodeIdBootedAndOK() {
        return this.tcpProxy.isNodeIdBootedAndOK(this);
    }

    @Override
    public boolean isInitalized() {
        return this.initialized;
    }

    @Override
    public void initModule() {
        super.initModule();
        this.tcpProxy = (CanOpenProxy)this.getModule("tcpProxy");
    }

    @Override
    public String initializeHardware() throws SDORequestException, ErrorInCommandExecutionException {
        return String.valueOf(this.getName()) + "nothing to do";
    }

    public String configure() throws SDORequestException, ErrorInCommandExecutionException {
        String goodAck;
        String ack = this.tcpProxy.writeSDO(this.nodeID, "2002", "01", "01", "04");
        if (!ack.equals(goodAck = "OK")) {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + " :bad returned ack for wsdo, index 2002");
        }
        return String.valueOf(this.getName()) + " is configured.";
    }

    public String writeTransmissionType(String transmissionType) throws SDORequestException, ErrorInCommandExecutionException, BadCommandException {
        String goodAck;
        if (transmissionType == null) {
            throw new BadCommandException(String.valueOf(this.getName()) + ": Can't write transmission type to device because transmaission type is null.");
        }
        String ack = this.tcpProxy.writeSDO(this.nodeID, "2005", "1", "1", transmissionType);
        if (!ack.equals(goodAck = "OK")) {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + " :bad returned ack for wsdo, index 1801");
        }
        return String.format("Transmission type of device %s is now %s", this.name, transmissionType);
    }

    @Override
    public String[] readNewHexaValues() {
        try {
            this.hexaValues[0] = this.tcpProxy.readSDO(this.nodeID, "6000", "03");
            this.hexaValues[1] = this.tcpProxy.readSDO(this.nodeID, "6000", "04");
        }
        catch (SDORequestException ex) {
            String message = String.valueOf(this.name) + "=> ERROR IN READING SENSOR:";
            log.error((Object)(String.valueOf(message) + ex.toString()), new String[0]);
            return null;
        }
        return this.hexaValues;
    }
}

