/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.subsystems.fcs.common.HygrometryGauge;
import org.lsst.ccs.subsystems.fcs.common.PressureGauge;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenSensor14bits;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

public class CanOpenGaugeHD2001
extends CanOpenSensor14bits
implements Thermometer,
PressureGauge,
HygrometryGauge {
    private final int offsetTemp;
    private final int offsetPressure;

    public CanOpenGaugeHD2001(String moduleName, int aTickMillis, String adcName, int numOfAnalogInput) {
        super(moduleName, aTickMillis, adcName, numOfAnalogInput);
        this.offsetTemp = -20;
        this.offsetPressure = 600;
    }

    @Override
    public double readTemperature() throws SDORequestException, HardwareNotDetectedException {
        double voltage = this.adc.readVoltage(this.numOfAnalogInput);
        return voltage / 100.0 + (double)this.offsetTemp;
    }

    @Override
    public double readTemperatureWithPDO(CanOpenProxy.PDOStorage pdo) throws BadCommandException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double readPressure() throws HardwareException {
        double voltage = this.adc.readVoltage(this.numOfAnalogInput);
        return voltage / 500.0 + 600.0;
    }

    @Override
    public double readHygrometry() throws HardwareException {
        double voltage = this.adc.readVoltage(this.numOfAnalogInput);
        return voltage / 100.0;
    }
}

