/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

public class CanOpenDevice
extends Module
implements PieceOfHardware {
    CanOpenProxy tcpProxy;
    BridgeToHardware bridge;
    String serialNB;
    String nodeID;
    boolean initialized;

    public CanOpenDevice(String aName, int aTickMillis, String nodeID, String serialNB) {
        super(aName, aTickMillis);
        this.nodeID = nodeID;
        this.serialNB = serialNB;
    }

    @Override
    public String getSerialNB() {
        return this.serialNB;
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    @Override
    public boolean isNodeIdBootedAndOK() {
        return this.tcpProxy.isNodeIdBootedAndOK(this);
    }

    @Override
    public boolean isInitalized() {
        return this.initialized;
    }

    public void initModule() {
        Map.Entry entry = this.getParent();
        this.bridge = (BridgeToHardware)entry.getValue();
        this.tcpProxy = this.bridge.getTcpProxy();
        this.initialized = false;
    }

    @Override
    public String initializeHardware() throws Exception {
        this.initialized = true;
        return String.valueOf(this.getName()) + ": no hardware initialization for this device to be done.";
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Write on the Can Open Device with a command wsdo.")
    public String writeSDO(String index, String subindex, String length, String newValue) throws SDORequestException {
        return this.tcpProxy.writeSDO(this.nodeID, index, subindex, length, newValue);
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Reads the Can Open Device with a command rsdo.")
    public String readSDO(String index, String subindex) throws SDORequestException {
        return this.tcpProxy.readSDO(this.nodeID, index, subindex);
    }

    public String readErrorRegister() throws SDORequestException {
        String error = this.readSDO("1001", "0");
        return String.format("%02x", Integer.parseInt(error));
    }

    public String displayErrorRegister() throws SDORequestException {
        String errorInHexa = this.readErrorRegister();
        String errorName = CanOpenErrorsTable.errorRegisterCodes.getProperty(errorInHexa);
        log.debug((Object)("error register=" + errorInHexa), new String[0]);
        return errorName;
    }

    public String[] readErrorHistory() throws SDORequestException {
        int numberOfErrors = this.readNumberOfErrors();
        String[] errors = new String[numberOfErrors];
        int i = 0;
        while (i < numberOfErrors) {
            String subindex = Integer.toHexString(i + 1);
            errors[i] = this.readSDO("1003", subindex);
            ++i;
        }
        return errors;
    }

    public String displayErrorHistory() throws SDORequestException {
        String[] errorHistory = this.readErrorHistory();
        StringBuilder sb = new StringBuilder("Error history contains " + errorHistory.length + " errors.");
        if (errorHistory.length != 0) {
            sb.append("List of errors in history : the newest is the first, the oldest the last\n");
            int ix = 0;
            while (ix < errorHistory.length) {
                sb.append("Error code (in hexa)=");
                sb.append(errorHistory[ix]);
                sb.append("/ error name=");
                sb.append(CanOpenErrorsTable.deviceErrorCodes.getProperty(errorHistory[ix].toUpperCase()));
                sb.append("\n");
                ++ix;
            }
        }
        return sb.toString();
    }

    public int readNumberOfErrors() throws SDORequestException {
        String errorNBinHEXA = this.readSDO("1003", "0");
        return Integer.parseInt(errorNBinHEXA, 16);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("/SerialNumber=");
        sb.append(this.serialNB);
        sb.append("/NodeID_in_hexa=");
        sb.append(this.nodeID);
        int x = Integer.parseInt(this.nodeID, 16);
        sb.append("/NodeID_in_decimal=");
        sb.append(x);
        sb.append("/");
        if (this.tcpProxy == null) {
            return sb.toString();
        }
        if (this.isNodeIdBootedAndOK()) {
            sb.append("BOOTED/");
        } else {
            sb.append("NOT YET BOOTED/");
        }
        return sb.toString();
    }
}

