/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenNode;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.DeploymentException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareConfigurationException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;

public abstract class BridgeToCanOpenHardware
extends Module
implements BridgeToHardware {
    protected CanOpenProxy tcpProxy;
    protected boolean configurationChecked = false;
    protected boolean hardwareInitialized = false;
    protected Map<String, PieceOfHardware> hardwareMap;

    public BridgeToCanOpenHardware(String aName, int aTickMillis, CanOpenProxy tcpProxy) {
        super(aName, aTickMillis);
        this.tcpProxy = tcpProxy;
    }

    public abstract PieceOfHardware[] listHardware();

    @Command(type=Command.CommandType.QUERY, level=1, description="print my children; for tests")
    public void printChildren() {
        Map children = this.getChildren(PieceOfHardware.class);
        for (Map.Entry entry : children.entrySet()) {
            String key = (String)entry.getKey();
            log.debug((Object)("key=" + key), new String[0]);
            PieceOfHardware device = (PieceOfHardware)entry.getValue();
            log.debug((Object)("hardware=" + device.getName() + "#" + device.toString()), new String[0]);
        }
    }

    @Override
    public CanOpenProxy getTcpProxy() {
        return this.tcpProxy;
    }

    @Override
    public void startServer() {
        this.tcpProxy.startServer();
    }

    @Override
    public void startThreadReader() {
        this.tcpProxy.startThreadReader();
    }

    @Override
    public boolean isCWrapperConnected() {
        return this.tcpProxy.isReady(this.tcpProxy.getMyClientName());
    }

    @Override
    public boolean isHardwareReady() {
        return this.tcpProxy.isHardwareReady();
    }

    @Override
    public boolean isRealHardware() {
        return true;
    }

    public void initModule() {
        log.info((Object)("INIT MODULE BRIDGE TO REAL HARDWARE: " + this.name), new String[0]);
        this.hardwareMap = this.getChildren(PieceOfHardware.class);
        PieceOfHardware[] hardwareList = this.listHardware();
        this.tcpProxy.hardwareList = hardwareList;
        int numberOfNodes = hardwareList.length;
        this.tcpProxy.setExpectedNodesNB(numberOfNodes);
        log.info((Object)("Number of can open devices expected =" + numberOfNodes), new String[0]);
        log.info((Object)this.toString(), new String[0]);
        try {
            CanOpenErrorsTable.loadDeviceErrorTable();
            CanOpenErrorsTable.loadErrorRegisterTable();
            CanOpenErrorsTable.loadCommunicationErrorTable();
        }
        catch (DeploymentException ex) {
            log.error((Object)(String.valueOf(ex.getMessage()) + ": Could not load CanOpen Error Tables"), new String[0]);
            this.getSubsystem().raiseAlarm("Could not load CanOpen Error Tables" + ex.toString());
        }
    }

    public void checkMatos() throws HardwareNotDetectedException, HardwareConfigurationException {
        int bootedHardwareNb = this.hardwareMap.entrySet().size();
        log.info((Object)this.name, new String[]{"number of pieces of hardware expected=" + bootedHardwareNb});
        Map<String, CanOpenNode> bootedNodesMap = this.tcpProxy.bootedNodesMap;
        log.info((Object)this.name, new String[]{"number of pieces of hardware booted=" + bootedNodesMap.entrySet().size()});
        for (Map.Entry<String, PieceOfHardware> entry : this.hardwareMap.entrySet()) {
            entry.getKey();
            PieceOfHardware device = entry.getValue();
            log.debug((Object)("Checking hardware=" + device.getName() + "#" + device.toString()), new String[0]);
            String serial = device.getSerialNB();
            String nodeID = device.getNodeID();
            if (bootedNodesMap.containsKey(nodeID)) {
                CanOpenNode bootedNode = bootedNodesMap.get(nodeID);
                if (bootedNode.getSerialNB().equalsIgnoreCase(serial)) {
                    log.info((Object)("booted hardware=" + device.getName() + ":" + device.toString()), new String[0]);
                    continue;
                }
                log.error((Object)("hardware with nodeID" + nodeID + "is booted but with an unexpected serial number."), new String[0]);
                log.error((Object)("hardware in error:" + device.toString()), new String[0]);
                log.error((Object)("serial number found for this nodeID:" + bootedNode.getSerialNB()), new String[0]);
                throw new HardwareConfigurationException("Unexpected serial number", device.getName());
            }
            throw new HardwareNotDetectedException("Hardware is not booted:", device.getName(), device.getNodeID(), device.getSerialNB());
        }
    }

    public Object sendCanOpen(String command) throws InterruptedException, TimeoutException, BadCommandException {
        return this.tcpProxy.sendCanOpen(command);
    }

    @Override
    public CanOpenProxy.PDOStorage readPDOs() throws HardwareException, BadCommandException {
        log.debug((Object)(String.valueOf(this.name) + "/readPDOS"), new String[0]);
        return this.tcpProxy.readPDOs();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/hardware list={");
        PieceOfHardware[] pieceOfHardwareArray = this.listHardware();
        int n = pieceOfHardwareArray.length;
        int n2 = 0;
        while (n2 < n) {
            PieceOfHardware p = pieceOfHardwareArray[n2];
            sb.append(" ");
            sb.append(p.toString());
            sb.append(";");
            ++n2;
        }
        sb.append("}");
        return sb.toString();
    }
}

