/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;

public abstract class MobileItemModule
extends Module {
    protected volatile boolean itemMoving = false;
    protected volatile FcsEnumerations.MobileItemAction currentAction;
    protected final Lock lock = new ReentrantLock();
    protected final Condition motionCompleted = this.lock.newCondition();
    ScheduledFuture<?> readSensorsHandle;
    final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);
    protected AtomicBoolean haltRequired = new AtomicBoolean();

    public MobileItemModule(String moduleName, int aTickMillis) {
        super(moduleName, aTickMillis);
        this.haltRequired.set(false);
    }

    public boolean isItemMoving() {
        return this.itemMoving;
    }

    private void cancelReadingSensors() {
        this.lock.lock();
        try {
            log.debug((Object)(String.valueOf(this.getName()) + " => Stop reading sensors"), new String[0]);
            this.motionCompleted.signal();
        }
        finally {
            this.lock.unlock();
        }
        this.readSensorsHandle.cancel(true);
        log.debug((Object)(String.valueOf(this.getName()) + " => readingSensors canceled"), new String[0]);
    }

    public abstract boolean isActionCompleted(FcsEnumerations.MobileItemAction var1);

    public abstract void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception;

    public abstract void startAction(FcsEnumerations.MobileItemAction var1) throws BadCommandException, ErrorInCommandExecutionException, HardwareException;

    public abstract void stopAction(FcsEnumerations.MobileItemAction var1, long var2) throws BadCommandException, ErrorInCommandExecutionException, HardwareException;

    public abstract void postAction(FcsEnumerations.MobileItemAction var1) throws BadCommandException, ErrorInCommandExecutionException, HardwareException;

    protected String executeAction(FcsEnumerations.MobileItemAction action, long timeoutForAction) throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        this.lock.lock();
        try {
            this.itemMoving = true;
            this.currentAction = action;
            log.debug((Object)this.name, new String[]{"STARTING ACTION:" + action.toString()});
            this.startAction(action);
            this.readSensorsUntilActionIsCompleted(action, System.currentTimeMillis(), timeoutForAction);
            this.waitForEndOfAction(action);
            if (this.haltRequired.get()) {
                this.stopAction(action, 0L);
                String string = String.valueOf(this.name) + "=> Received an ABORT command for action :" + action.toString();
                return string;
            }
            if (this.isActionCompleted(action)) {
                this.postAction(action);
                String string = String.valueOf(this.name) + " " + action.doneString();
                return string;
            }
            throw new ErrorInCommandExecutionException(String.valueOf(this.name) + "=>" + action.getFailureMsg());
        }
        finally {
            this.stopAction(action, 0L);
            this.itemMoving = false;
            this.motionCompleted.signal();
            this.haltRequired.set(false);
            this.lock.unlock();
        }
    }

    public void readSensorsUntilActionIsCompleted(final FcsEnumerations.MobileItemAction action, final long beginTime, final long timeout) {
        Runnable readSensors = new Runnable(){

            @Override
            public void run() {
                try {
                    log.info((Object)(String.valueOf(MobileItemModule.this.name) + " : Reading sensors"), new String[0]);
                    long duration = System.currentTimeMillis() - beginTime;
                    MobileItemModule.this.updateStateWithSensorsToCheckIfActionIsCompleted();
                    boolean actionCompleted = MobileItemModule.this.isActionCompleted(action);
                    if (MobileItemModule.this.haltRequired.get()) {
                        MobileItemModule.this.itemMoving = false;
                        log.info((Object)(String.valueOf(action.toString()) + " ACTION ABORTED"), new String[0]);
                        MobileItemModule.this.stopAction(action, 0L);
                        MobileItemModule.this.cancelReadingSensors();
                    } else if (actionCompleted) {
                        MobileItemModule.this.itemMoving = false;
                        log.info((Object)(String.valueOf(action.toString()) + " ACTION COMPLETED"), new String[0]);
                        MobileItemModule.this.cancelReadingSensors();
                    } else {
                        if (duration >= timeout) {
                            MobileItemModule.this.itemMoving = false;
                            log.info((Object)(String.valueOf(action.toString()) + " ACTION NOT COMPLETED during allocated time"), new String[0]);
                            MobileItemModule.this.cancelReadingSensors();
                            throw new HardwareException(String.valueOf(action.toString()) + " exceeded timeout for this task: duration=" + duration + ",timeout=" + timeout);
                        }
                        log.info((Object)(String.valueOf(action.toString()) + " not completed....."), new String[0]);
                        log.info((Object)(String.valueOf(action.name()) + "/duration=" + duration), new String[0]);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)("ERROR during action:" + ex.getMessage()), new String[0]);
                    MobileItemModule.this.getSubsystem().raiseAlarm(ex.toString());
                    MobileItemModule.this.cancelReadingSensors();
                }
            }
        };
        this.readSensorsHandle = this.scheduler.scheduleAtFixedRate(readSensors, 500L, 500L, TimeUnit.MILLISECONDS);
    }

    private void waitForEndOfAction(FcsEnumerations.MobileItemAction action) {
        while (this.itemMoving) {
            try {
                log.info((Object)(String.valueOf(this.name) + " Waiting for end of " + action.toString()), new String[0]);
                this.motionCompleted.await();
            }
            catch (InterruptedException ex) {
                log.info((Object)(String.valueOf(this.name) + " " + ex.toString()), new String[0]);
            }
        }
        log.info((Object)(String.valueOf(this.name) + " STOP WAITING FOR END OF ACTION"), new String[0]);
    }

    private void halt(FcsEnumerations.MobileItemAction action, long delay) {
        try {
            log.debug((Object)(String.valueOf(this.name) + " STOPPING ACTION: " + action.toString()), new String[0]);
            this.stopAction(action, delay);
        }
        catch (BadCommandException | ErrorInCommandExecutionException | HardwareException throwable) {
            log.error((Object)(String.valueOf(this.name) + " couldn't stop action " + action.toString()), new String[0]);
        }
    }

    @Command(type=Command.CommandType.ABORT, level=1, description="Abort the running action.")
    public void abort(long delay) throws BadCommandException {
        if (!this.itemMoving) {
            throw new BadCommandException(String.valueOf(this.getName()) + " is not moving; nothing to stop.");
        }
        this.sendSignal(delay, "HALT");
    }

    @Command(type=Command.CommandType.ABORT, level=1, description="Abort the running action.")
    public void abort() throws BadCommandException {
        this.abort(0L);
    }

    @Command(type=Command.CommandType.ABORT, level=1, description="Abort the running action.")
    public void stop() throws BadCommandException {
        this.abort(0L);
    }

    public TreeWalkerDiag signal(Signal signal) {
        SignalLevel sl = signal.getLevel();
        log.info((Object)sl.toString(), new String[0]);
        if (this.itemMoving) {
            switch (signal.getLevel()) {
                case HALT: {
                    log.info((Object)(String.valueOf(this.getName()) + " HALT required"), new String[0]);
                    this.haltRequired.set(true);
                    this.halt(this.currentAction, signal.getExpectedMaxDelay());
                    break;
                }
                case STOP: {
                    log.info((Object)(String.valueOf(this.getName()) + " STOP required"), new String[0]);
                    this.haltRequired.set(true);
                    this.halt(this.currentAction, signal.getExpectedMaxDelay());
                    break;
                }
                case INTERRUPT1: {
                    break;
                }
                case INTERRUPT2: {
                    break;
                }
                case RE_START: {
                    this.haltRequired.set(false);
                }
            }
        } else {
            log.warning((Object)(String.valueOf(this.getName()) + " is not moving; nothing to stop."), new String[0]);
        }
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }
}

