/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.beans.ConstructorProperties;
import org.lsst.ccs.CurrentCommandContext;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.LoaderCarrierModule;
import org.lsst.ccs.subsystems.fcs.LoaderClampModule;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;

public class LoaderModule
extends Module {
    private LoaderCarrierModule carrier;
    private LoaderClampModule clamp;
    private AutoChangerModule autochanger;
    private NumericSensor filterPresenceSensor;
    private NumericSensor loaderOnCameraPresenceSensor;
    boolean empty;
    boolean loaderConnected;

    @ConstructorProperties(value={"name", "tickmillis", "carrier", "clamp", "filterPresenceSensor", "loaderOnCameraPresenceSensor"})
    public LoaderModule(String moduleName, int aTickMillis, LoaderCarrierModule carrier, LoaderClampModule clamp, NumericSensor filterPresenceSensor, NumericSensor loaderOnCameraPresenceSensor) {
        super(moduleName, aTickMillis);
        this.carrier = carrier;
        this.clamp = clamp;
        this.empty = true;
        this.loaderConnected = false;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if no filter is in the loader.")
    public boolean isEmpty() {
        return this.empty;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if no filter is in the loader.")
    public boolean isMoving() {
        return this.clamp.isItemMoving();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="A filter is there and it is held by the clamp.")
    public boolean isHoldingAFilter() {
        return false;
    }

    public LoaderClampModule getClamp() {
        return this.clamp;
    }

    public LoaderCarrierModule getCarrier() {
        return this.carrier;
    }

    public boolean isCarrierAtStoragePosition() {
        return this.carrier.isAtStoragePosition();
    }

    public void initModule() {
        this.autochanger = (AutoChangerModule)this.getModule("autochanger");
    }

    public void initializeHardware() throws HardwareException, ErrorInCommandExecutionException, BadCommandException {
        this.updateStateWithSensors();
        this.clamp.initializeHardware();
        this.carrier.initialiazeHardware();
    }

    public void tick() {
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Update clamp and carrier states in reading the sensors.")
    public void updateStateWithSensors() throws HardwareException, ErrorInCommandExecutionException {
        this.updateHookStateWithSensors();
        this.updateCarrierStateWithSensors();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close hooks.")
    public String closeHooks() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        return this.clamp.close();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Clamp hooks.")
    public String clampHooks() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        return this.clamp.clamp();
    }

    @Command(level=1, description="Open the hooks", type=Command.CommandType.ACTION)
    public String openHooks() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        return this.clamp.open();
    }

    @Command(level=1, description="Move the loader carrier to HANDOFF position", type=Command.CommandType.ACTION)
    public void moveToHandoff() {
        this.carrier.goToHandOff();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move the loader carrier to STORAGE position")
    public void moveToStorage() {
        this.carrier.goToStorage();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Update clamp state in reading the sensors.")
    private void updateHookStateWithSensors() {
        this.clamp.updateStateWithSensors();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Update carrier states in reading the sensors.")
    public void updateCarrierStateWithSensors() {
        this.carrier.updateStateWithSensors();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="List and display info on the hooks.")
    public String listHooks() {
        return this.clamp.listHooks();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display hooks sensors values.")
    public String listSensorsValues() {
        return this.clamp.listSensorsValues();
    }

    public void test() {
        CurrentCommandContext currentCmdContext = (CurrentCommandContext)Subsystem.LOCAL_EXECUTION_INFO.get();
        log.debug((Object)("Command running:" + currentCmdContext.getCommandName()), new String[0]);
        log.info((Object)("coming from:" + currentCmdContext.getCommandOriginator()), new String[0]);
        this.getSubsystem().interruptActionThread();
    }
}

