/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.Map;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.CurrentCommandContext;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.bus.KVList;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.LoaderHookModule;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class LoaderClampModule
extends MobileItemModule {
    private EPOSController hooksController;
    final LoaderHookModule hook1;
    final LoaderHookModule hook2;
    final LoaderHookModule hook3;
    final LoaderHookModule hook4;
    private PlutoGatewayModule plutoGateway;
    private final String plutoGatewayName;
    FcsEnumerations.LockStatus lockStatus;
    long timeoutForClosingHooks;
    long timeoutForClampingHooks;
    long timeoutForOpeningHooks;
    long timeoutForGoingToHomePosition;
    private volatile boolean initialized;
    final Condition stateUpdated;
    protected volatile boolean updatingState;
    int position;
    int minPosition;
    int maxPosition;
    int targetPositionToOpen;
    int targetPositionToClose;
    int targetPositionToClamp;
    int currentToClamp;
    int currentToGoHome;
    Map<String, Integer> paramsForCurrentToGoHome;
    Map<String, Integer> paramsForCurrentToClose;

    public LoaderClampModule(String moduleName, int aTickMillis, LoaderHookModule hook1, LoaderHookModule hook2, LoaderHookModule hook3, LoaderHookModule hook4, String plutoGWName, long timeoutForClosingHooks, long timeoutForClosingHooksStrongly, long timeoutForOpeningHooks, long timeoutForGoingToHomePosition, int targetPositionToOpen, int targetPositionToClose, int targetPositionToCloseStrongly, int currentToClose, int currentToGoHome, Map<String, Integer> paramsForCurrentToClose, Map<String, Integer> paramsForCurrentToGoHomePosition, int minPosition, int maxPosition) {
        super(moduleName, aTickMillis);
        this.stateUpdated = this.lock.newCondition();
        this.updatingState = false;
        this.hook1 = hook1;
        this.hook2 = hook2;
        this.hook3 = hook3;
        this.hook4 = hook4;
        this.plutoGatewayName = plutoGWName;
        this.initialized = false;
        this.timeoutForClosingHooks = timeoutForClosingHooks;
        this.timeoutForClampingHooks = timeoutForClosingHooksStrongly;
        this.timeoutForOpeningHooks = timeoutForOpeningHooks;
        this.timeoutForGoingToHomePosition = timeoutForGoingToHomePosition;
        this.targetPositionToOpen = targetPositionToOpen;
        this.targetPositionToClose = targetPositionToClose;
        this.targetPositionToClamp = targetPositionToCloseStrongly;
        this.currentToClamp = currentToClose;
        this.currentToGoHome = currentToGoHome;
        this.paramsForCurrentToClose = paramsForCurrentToClose;
        this.paramsForCurrentToGoHome = paramsForCurrentToGoHomePosition;
        this.minPosition = minPosition;
        this.maxPosition = maxPosition;
    }

    public LoaderHookModule getHook1() {
        return this.hook1;
    }

    public LoaderHookModule getHook2() {
        return this.hook2;
    }

    public LoaderHookModule getHook3() {
        return this.hook3;
    }

    public LoaderHookModule getHook4() {
        return this.hook4;
    }

    public int getPosition() {
        return this.position;
    }

    public int getMinPosition() {
        return this.minPosition;
    }

    public int getMaxPosition() {
        return this.maxPosition;
    }

    public int getTargetPositionToOpen() {
        return this.targetPositionToOpen;
    }

    public int getTargetPositionToClose() {
        return this.targetPositionToClose;
    }

    public int getTargetPositionToClamp() {
        return this.targetPositionToClamp;
    }

    public int getCurrentToClose() {
        return this.currentToClamp;
    }

    public int getCurrentToGoHome() {
        return this.currentToGoHome;
    }

    public long getTimeoutForClosingHooks() {
        return this.timeoutForClosingHooks;
    }

    public long getTimeoutForClampingHooks() {
        return this.timeoutForClampingHooks;
    }

    public long getTimeoutForOpeningHooks() {
        return this.timeoutForOpeningHooks;
    }

    public long getTimeoutForGoingToHomePosition() {
        return this.timeoutForGoingToHomePosition;
    }

    /*
     * Exception decompiling
     */
    public FcsEnumerations.LockStatus getLockStatus() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=LOCKED")
    public boolean isLocked() {
        return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.LOCKED);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=UNLOCKED")
    public boolean isUnlocked() {
        return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.UNLOCKED);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if loader is empty.")
    public boolean isEmpty() {
        return ((LoaderModule)this.getModule("loader")).isEmpty();
    }

    public void initModule() {
        this.hooksController = (EPOSController)this.getModule("hooksController");
        this.plutoGateway = (PlutoGatewayModule)this.getModule(this.plutoGatewayName);
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hook is open and at home position")
    public boolean isAtHomePosition() throws SDORequestException {
        return this.hooksController.isTargetPositionReached(0);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hook is closed and at clamped position")
    public boolean isAtClampedPosition() throws SDORequestException {
        return this.hooksController.isTargetPositionReached(this.targetPositionToClamp);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hook is at closed position.")
    public boolean isAtClosedPosition() throws SDORequestException {
        return this.hooksController.isTargetPositionReached(this.targetPositionToClose);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hook is at open position.")
    public boolean isAtOpenPosition() throws SDORequestException {
        return this.hooksController.isTargetPositionReached(this.targetPositionToOpen);
    }

    public void initializeHardware() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        this.updateStateWithSensors();
        if (this.isEmpty()) {
            this.goToHomePosition();
            this.hooksController.defineAbsolutePosition(0);
            this.initialized = true;
        } else {
            this.goToClampedPosition();
            this.hooksController.defineAbsolutePosition(this.targetPositionToClamp);
            this.initialized = true;
        }
    }

    public void tick() {
        if (!this.initialized) {
            this.initialized = true;
            log.debug((Object)(String.valueOf(this.getName()) + " is initialized"), new String[0]);
        }
        this.updateStateWithSensors();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Go to clamped position to intialize hardware.")
    public String goToClampedPosition() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        if (this.isEmpty()) {
            throw new BadCommandException(String.valueOf(this.getName()) + " can't go to close position if  empty.");
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.GOTOCLOSEPOSITION, this.timeoutForClampingHooks);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Go to home position to intialize hardware.")
    public String goToHomePosition() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        if (!this.isEmpty()) {
            throw new BadCommandException(String.valueOf(this.getName()) + " can't go to home position if not empty.");
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.GOTOHOMEPOSITION, this.timeoutForGoingToHomePosition);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close clamp.")
    public String close() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        if (!this.initialized) {
            throw new BadCommandException(String.valueOf(this.getName()) + " is not intialized. PLease initialize hardware first.");
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.CLOSELOADERHOOKS, this.timeoutForClosingHooks);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Clamp clamp.")
    public String clamp() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        if (!this.initialized) {
            throw new BadCommandException(String.valueOf(this.getName()) + " is not intialized. PLease initialize hardware first.");
        }
        if (!this.isLocked()) {
            throw new BadCommandException(String.valueOf(this.getName()) + " has to be LOCKED first. close hooks prior closeStrongly");
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.CLAMPLOADERHOOKS, this.timeoutForClampingHooks);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Open clamp.")
    public String open() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        if (!this.initialized) {
            throw new BadCommandException(String.valueOf(this.getName()) + " is not intialized. PLease initialize hardware first.");
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.OPENLOADERHOOKS, this.timeoutForOpeningHooks);
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case GOTOCLOSEPOSITION: {
                return this.lockStatus.equals((Object)FcsEnumerations.LockStatus.LOCKED);
            }
            case GOTOHOMEPOSITION: {
                return this.lockStatus.equals((Object)FcsEnumerations.LockStatus.UNLOCKED);
            }
            case CLOSELOADERHOOKS: {
                return this.lockStatus.equals((Object)FcsEnumerations.LockStatus.LOCKED);
            }
            case CLAMPLOADERHOOKS: {
                return this.lockStatus.equals((Object)FcsEnumerations.LockStatus.LOCKED);
            }
            case OPENLOADERHOOKS: {
                return this.lockStatus.equals((Object)FcsEnumerations.LockStatus.UNLOCKED);
            }
        }
        return false;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        this.updateStateWithSensors();
        if (this.currentAction.equals((Object)FcsEnumerations.MobileItemAction.CLAMPLOADERHOOKS) || this.currentAction.equals((Object)FcsEnumerations.MobileItemAction.CLOSELOADERHOOKS) || this.currentAction.equals((Object)FcsEnumerations.MobileItemAction.OPENLOADERHOOKS)) {
            this.position = this.hooksController.readPosition();
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        switch (action) {
            case GOTOCLOSEPOSITION: {
                this.hooksController.enable();
                this.hooksController.changeMode(CanOpenEPOS.EposMode.CURRENT);
                this.hooksController.writeParameters(this.paramsForCurrentToClose);
                this.hooksController.writeCurrent(this.currentToClamp);
                this.hooksController.on();
                break;
            }
            case GOTOHOMEPOSITION: {
                this.hooksController.enable();
                this.hooksController.changeMode(CanOpenEPOS.EposMode.CURRENT);
                this.hooksController.writeParameters(this.paramsForCurrentToGoHome);
                this.hooksController.writeCurrent(this.currentToGoHome);
                this.hooksController.on();
                break;
            }
            case CLOSELOADERHOOKS: {
                this.hooksController.enable();
                this.hooksController.changeMode(CanOpenEPOS.EposMode.PROFILE_POSITION);
                this.hooksController.writeParameters(CanOpenEPOS.EposMode.PROFILE_POSITION);
                this.hooksController.writeTargetPosition(this.targetPositionToClose);
                this.hooksController.on();
                break;
            }
            case CLAMPLOADERHOOKS: {
                if (!this.lockStatus.equals((Object)FcsEnumerations.LockStatus.LOCKED)) {
                    throw new BadCommandException(String.valueOf(this.getName()) + ": Hooks have to be LOCKED before being LOCKED STRONGLY");
                }
                this.hooksController.enable();
                this.hooksController.writeTargetPosition(this.targetPositionToClamp);
                this.hooksController.on();
                break;
            }
            case OPENLOADERHOOKS: {
                this.hooksController.enable();
                this.hooksController.changeMode(CanOpenEPOS.EposMode.PROFILE_POSITION);
                this.hooksController.writeParameters(CanOpenEPOS.EposMode.PROFILE_POSITION);
                this.hooksController.writeTargetPosition(this.targetPositionToOpen);
                this.hooksController.on();
            }
        }
    }

    @Override
    public void stopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        log.debug((Object)(String.valueOf(this.getName()) + " is STOPPING action " + action.toString() + " within delay " + delay), new String[0]);
        CurrentCommandContext currentCmdContext = (CurrentCommandContext)Subsystem.LOCAL_EXECUTION_INFO.get();
        log.debug((Object)("Command running:" + currentCmdContext.getCommandName()), new String[0]);
        log.info((Object)("coming from:" + currentCmdContext.getCommandOriginator()), new String[0]);
        this.hooksController.off();
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        switch (action) {
            case GOTOCLOSEPOSITION: {
                if (!this.isLocked() || !this.isAtClampedPosition()) break;
                this.hooksController.defineAbsolutePosition(this.targetPositionToClamp);
                this.lockStatus = FcsEnumerations.LockStatus.CLAMPED;
                this.publishData();
                break;
            }
            case GOTOHOMEPOSITION: {
                this.hooksController.off();
                this.hooksController.defineAbsolutePosition(0);
                this.hooksController.off();
                break;
            }
            case CLOSELOADERHOOKS: {
                this.hooksController.off();
                break;
            }
            case CLAMPLOADERHOOKS: {
                if (!this.isLocked() || !this.isAtClampedPosition()) break;
                this.lockStatus = FcsEnumerations.LockStatus.CLAMPED;
                this.publishData();
                break;
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update clamp state in reading sensors.")
    public void updateStateWithSensors() {
        this.lock.lock();
        try {
            boolean unlocked;
            this.updatingState = true;
            this.plutoGateway.updateValues();
            String[] readHexaValues = this.plutoGateway.getHexaValues();
            this.hook1.updateStateWithSensors(readHexaValues);
            this.hook2.updateStateWithSensors(readHexaValues);
            this.hook3.updateStateWithSensors(readHexaValues);
            this.hook4.updateStateWithSensors(readHexaValues);
            boolean inError = this.hook1.getLockStatus() == FcsEnumerations.LockStatus.ERROR || this.hook2.getLockStatus() == FcsEnumerations.LockStatus.ERROR || this.hook3.getLockStatus() == FcsEnumerations.LockStatus.ERROR || this.hook4.getLockStatus() == FcsEnumerations.LockStatus.ERROR;
            boolean locked = this.hook1.getLockStatus() == FcsEnumerations.LockStatus.LOCKED && this.hook2.getLockStatus() == FcsEnumerations.LockStatus.LOCKED && this.hook3.getLockStatus() == FcsEnumerations.LockStatus.LOCKED && this.hook4.getLockStatus() == FcsEnumerations.LockStatus.LOCKED;
            boolean bl = unlocked = this.hook1.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED && this.hook2.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED && this.hook3.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED && this.hook4.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED;
            if (locked && unlocked) {
                inError = true;
            }
            this.lockStatus = inError ? FcsEnumerations.LockStatus.ERROR : (locked ? (this.position == this.targetPositionToClose ? FcsEnumerations.LockStatus.CLAMPED : FcsEnumerations.LockStatus.LOCKED) : (unlocked ? FcsEnumerations.LockStatus.UNLOCKED : FcsEnumerations.LockStatus.UNKNOWN));
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update clamp position in reading controller.")
    public void updatePosition() throws BadCommandException, SDORequestException {
        this.position = this.hooksController.readPosition();
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display clamp info.")
    public String listHooks() {
        StringBuilder sb = new StringBuilder("Hooks status:");
        sb.append("\n");
        sb.append(this.hook1.toString());
        sb.append("/");
        sb.append(this.hook1.getLockStatus());
        sb.append("\n");
        sb.append(this.hook2.toString());
        sb.append("/");
        sb.append(this.hook2.getLockStatus());
        sb.append("\n");
        sb.append(this.hook3.toString());
        sb.append("/");
        sb.append(this.hook3.getLockStatus());
        sb.append("\n");
        sb.append(this.hook4.toString());
        sb.append("/");
        sb.append(this.hook4.getLockStatus());
        sb.append("\n");
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display clamp sensors values.")
    public String listSensorsValues() {
        StringBuilder sb = new StringBuilder(String.valueOf(this.getName()) + "Sensors values=");
        sb.append("/");
        sb.append(this.hook1.listSensorsValues());
        sb.append("/");
        sb.append(this.hook2.listSensorsValues());
        sb.append("/");
        sb.append(this.hook3.listSensorsValues());
        sb.append("/");
        sb.append(this.hook4.listSensorsValues());
        sb.append("/");
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display clamp sensors values.")
    public String listStatus() {
        StringBuilder sb = new StringBuilder("Clamp status:");
        sb.append(this.lockStatus);
        sb.append("\n");
        sb.append(this.hook1.getName());
        sb.append("/");
        sb.append(this.hook1.getLockStatus());
        sb.append("\n");
        sb.append(this.hook2.getName());
        sb.append("/");
        sb.append(this.hook2.getLockStatus());
        sb.append("\n");
        sb.append(this.hook3.getName());
        sb.append("/");
        sb.append(this.hook3.getLockStatus());
        sb.append("\n");
        sb.append(this.hook4.getName());
        sb.append("/");
        sb.append(this.hook4.getLockStatus());
        sb.append("\n");
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display clamp info.")
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("/timeoutForClosingHooks=");
        sb.append(this.timeoutForClosingHooks);
        sb.append("/timeoutForClosingHooksStrongly=");
        sb.append(this.timeoutForClampingHooks);
        sb.append("/timeoutForOpeningHooks=");
        sb.append(this.timeoutForOpeningHooks);
        return sb.toString();
    }

    public StatusDataPublishedByLoaderClamp getStatusData() {
        StatusDataPublishedByLoaderClamp status = FcsUtils.createStatusDataPublishedByLoaderClamp(this);
        return status;
    }

    public void publishData() {
        StatusDataPublishedByLoaderClamp status = this.getStatusData();
        this.publish("loaderClamp", status);
    }

    @Deprecated
    public void publishClampData() {
        LoaderHookModule[] listHooks;
        KVList kvlist = new KVList(7);
        long timestamp = System.currentTimeMillis();
        kvlist.add("dataType", (Object)"loaderClamp");
        kvlist.add(String.valueOf(this.getName()) + "/clampState", (Object)this.lockStatus.toString());
        kvlist.add("hook1Name", (Object)this.hook1.getName());
        kvlist.add("hook2Name", (Object)this.hook2.getName());
        kvlist.add("hook3Name", (Object)this.hook3.getName());
        kvlist.add("hook4Name", (Object)this.hook4.getName());
        LoaderHookModule[] loaderHookModuleArray = listHooks = new LoaderHookModule[]{this.hook1, this.hook2, this.hook3, this.hook4};
        int n = listHooks.length;
        int n2 = 0;
        while (n2 < n) {
            LoaderHookModule hook = loaderHookModuleArray[n2];
            kvlist.add(String.valueOf(hook.getName()) + "/lockStatus", (Object)hook.lockStatus.toString());
            kvlist.add(String.valueOf(hook.getName()) + "/lockSensorValue", (Object)hook.getLockSensor().digitalValue);
            kvlist.add(String.valueOf(hook.getName()) + "/unlockSensorValue", (Object)hook.getUnlockSensor().digitalValue);
            kvlist.add(String.valueOf(hook.getName()) + "/inError", (Object)hook.isInError());
            ++n2;
        }
        this.publish(timestamp, kvlist);
    }
}

