/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.ArrayList;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.CurrentCommandContext;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.bus.KVList;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.subsystems.fcs.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Sensor14bits;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClamp;
import org.lsst.ccs.subsystems.fcs.common.Actuator;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.SensorValueOutOfRangeException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class FilterClampModule
extends MobileItemModule {
    private BridgeToHardware bridge;
    private Actuator actuator;
    private final Sensor14bits filterPresenceSensor;
    private final Sensor14bits lockSensor;
    private final Thermometer thermometer;
    protected FcsEnumerations.FilterClampState clampState;
    protected FcsEnumerations.FilterPresenceStatus filterPresenceStatus;
    private FcsEnumerations.LockStatus lockStatus;
    protected double temperature;
    private int lockSensorValueA;
    private int lockSensorValueB;
    private int lockSensorValueC;
    private int lockSensorOffset;
    private static final int lockSensorMinValue = 0;
    private static final int lockSensorMaxValue = 32768;
    private static final int filterPositionMinValue = 0;
    private static final int filterPositionMaxValue = 32768;
    private int filterPositionValueA;
    private int filterPositionValueB;
    private int filterPositionValueC;
    private int filterPositionOffset;
    public String publishedByClampOutputName = "publishedByClamp";
    private boolean initialized = false;
    final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;
    protected long timeoutForUnlocking = 4000L;
    protected long timeoutForReleasing = 4000L;

    public FilterClampModule(String aName, int aTickMillis, Sensor14bits filterPresenceSensor, Sensor14bits lockSensor, Thermometer thermometer, int filterPositionValueA, int filterPositionValueB, int filterPositionValueC, int filterPositionOffset, int lockSensorValueA, int lockSensorValueB, int lockSensorValueC, int lockSensorOffset, int timeoutForUnlocking, int timeoutForReleasing) {
        super(aName, aTickMillis);
        this.filterPresenceSensor = filterPresenceSensor;
        this.lockSensor = lockSensor;
        this.thermometer = thermometer;
        this.filterPositionValueA = filterPositionValueA;
        this.filterPositionValueB = filterPositionValueB;
        this.filterPositionValueC = filterPositionValueC;
        this.filterPositionOffset = filterPositionOffset;
        this.lockSensorValueA = lockSensorValueA;
        this.lockSensorValueB = lockSensorValueB;
        this.lockSensorValueC = lockSensorValueC;
        this.lockSensorOffset = lockSensorOffset;
        this.timeoutForUnlocking = timeoutForUnlocking;
        this.timeoutForReleasing = timeoutForReleasing;
    }

    public Actuator getActuator() {
        return this.actuator;
    }

    public void setActuator(Actuator actuator) {
        this.actuator = actuator;
    }

    @ConfigChanger
    public void setFilterPositionValueA(int valueA) {
        this.filterPositionValueA = valueA;
    }

    @ConfigChanger
    public void setFilterPositionValueB(int valueB) {
        this.filterPositionValueB = valueB;
    }

    @ConfigChanger
    public void setFilterPositionValueC(int valueC) {
        this.filterPositionValueC = valueC;
    }

    public int getLockSensorValueA() {
        return this.lockSensorValueA;
    }

    @ConfigChanger
    public void setLockSensorValueA(int aValue) {
        this.lockSensorValueA = aValue;
    }

    public int getLockSensorValueB() {
        return this.lockSensorValueB;
    }

    @ConfigChanger
    public void setLockSensorValueB(int aValue) {
        this.lockSensorValueB = aValue;
    }

    public int getLockSensorValueC() {
        return this.lockSensorValueC;
    }

    @ConfigChanger
    public void setLockSensorValueC(int lockSensorValueC) {
        this.lockSensorValueC = lockSensorValueC;
    }

    public int getFilterPositionMaxValue() {
        return 32768;
    }

    public int getFilterPositionMinValue() {
        return 0;
    }

    public int getLockSensorMaxValue() {
        return 32768;
    }

    public int getLockSensorMinValue() {
        return 0;
    }

    @ConfigChanger
    public void setLockSensorOffset(int lockSensorOffset) {
        this.lockSensorOffset = lockSensorOffset;
    }

    public int getFilterPositionValueA() {
        return this.filterPositionValueA;
    }

    public int getFilterPositionValueB() {
        return this.filterPositionValueB;
    }

    public int getFilterPositionValueC() {
        return this.filterPositionValueC;
    }

    public int getLockSensorOffset() {
        return this.lockSensorOffset;
    }

    public int getFilterPositionOffset() {
        return this.filterPositionOffset;
    }

    public void setFilterPositionOffset(int filterPositionOffset) {
        this.filterPositionOffset = filterPositionOffset;
    }

    public Sensor14bits getFilterPresenceSensor() {
        return this.filterPresenceSensor;
    }

    public Sensor14bits getLockSensor() {
        return this.lockSensor;
    }

    public Thermometer getThermometer() {
        return this.thermometer;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        return this.lockStatus;
    }

    public void setLockStatus(FcsEnumerations.LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    public FcsEnumerations.FilterPresenceStatus getFilterPresenceStatus() {
        return this.filterPresenceStatus;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public long getTimeoutRelease() {
        return this.timeoutForReleasing;
    }

    @ConfigChanger
    public void setTimeoutRelease(long timeoutRelease) {
        this.timeoutForReleasing = timeoutRelease;
    }

    public long getTimeoutUnlock() {
        return this.timeoutForUnlocking;
    }

    @ConfigChanger
    public void setTimeoutUnlock(long timeoutUnlock) {
        this.timeoutForUnlocking = timeoutUnlock;
    }

    public void initModule() {
        this.bridge = (BridgeToHardware)this.getModule("bridge");
        this.clampState = FcsEnumerations.FilterClampState.UNDEFINED;
        this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE;
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        this.temperature = 0.0;
    }

    /*
     * Exception decompiling
     */
    public FcsEnumerations.FilterClampState getClampState() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Command(level=1, description="Returns true if the clamp is locked", type=Command.CommandType.QUERY)
    public boolean isLocked() {
        return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.LOCKED);
    }

    @Command(level=1, description="Returns true if filter is engaged on the clamp : filter presence sensors sees it ", type=Command.CommandType.QUERY)
    public synchronized boolean isFilterEngaged() {
        return this.filterPresenceStatus.equals((Object)FcsEnumerations.FilterPresenceStatus.LOCKABLE);
    }

    public void updateFilterPresenceStatus() throws HardwareException {
        this.filterPresenceSensor.updateValue();
        int newFilterPresenceSensorValue = this.filterPresenceSensor.getValue();
        int mechaValue = newFilterPresenceSensorValue - this.filterPositionOffset;
        if (mechaValue < this.filterPositionValueA) {
            this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.ERROR;
            log.error((Object)(String.valueOf(this.getName()) + " ERROR new read value FOR FILTER POSITION SENSOR  = " + newFilterPresenceSensorValue), new String[0]);
            throw new SensorValueOutOfRangeException("FILTER POSITION SENSOR", this.filterPresenceSensor.getName(), 0, this.filterPositionValueA, mechaValue);
        }
        this.filterPresenceStatus = mechaValue < this.filterPositionValueB ? FcsEnumerations.FilterPresenceStatus.LOCKABLE : (mechaValue < this.filterPositionValueC ? FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE : FcsEnumerations.FilterPresenceStatus.NOFILTER);
    }

    private void updateFilterPresenceStatus(CanOpenProxy.PDOStorage pdoStorage) throws HardwareException {
        int newFilterPresenceSensorValue = this.filterPresenceSensor.updateValue(pdoStorage);
        int mechaValue = newFilterPresenceSensorValue - this.filterPositionOffset;
        if (mechaValue < this.filterPositionValueA) {
            this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.ERROR;
            log.error((Object)(String.valueOf(this.getName()) + " ERROR new read value FOR FILTER POSITION SENSOR  = " + newFilterPresenceSensorValue), new String[0]);
            throw new SensorValueOutOfRangeException("FILTER POSITION SENSOR", this.filterPresenceSensor.getName(), 0, 32768, mechaValue);
        }
        this.filterPresenceStatus = mechaValue < this.filterPositionValueB ? FcsEnumerations.FilterPresenceStatus.LOCKABLE : (mechaValue < this.filterPositionValueC ? FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE : FcsEnumerations.FilterPresenceStatus.NOFILTER);
    }

    public void updateLockStatus() throws HardwareException {
        this.lockSensor.updateValue();
        int newLockSensorValue = this.lockSensor.getValue();
        int mechaValue = newLockSensorValue - this.lockSensorOffset;
        if (mechaValue < this.lockSensorValueA) {
            this.lockStatus = FcsEnumerations.LockStatus.UNLOCKED;
        } else if (mechaValue <= this.lockSensorValueB) {
            this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        } else if (mechaValue <= this.lockSensorValueC) {
            this.lockStatus = FcsEnumerations.LockStatus.LOCKED;
        } else {
            this.lockStatus = FcsEnumerations.LockStatus.ERROR;
            log.error((Object)(String.valueOf(this.getName()) + " ERROR new read value FOR LOCK SENSOR  = " + newLockSensorValue), new String[0]);
            throw new SensorValueOutOfRangeException("ERROR in reading LOCK SENSOR", this.lockSensor.getName(), 0, 32768, mechaValue);
        }
    }

    private void updateLockStatus(CanOpenProxy.PDOStorage pdoStorage) throws HardwareException {
        int newLockSensorValue = this.lockSensor.updateValue(pdoStorage);
        int mechaValue = newLockSensorValue - this.lockSensorOffset;
        if (mechaValue < this.lockSensorValueA) {
            this.lockStatus = FcsEnumerations.LockStatus.UNLOCKED;
        } else if (mechaValue <= this.lockSensorValueB) {
            this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        } else if (mechaValue <= this.lockSensorValueC) {
            this.lockStatus = FcsEnumerations.LockStatus.LOCKED;
        } else {
            this.lockStatus = FcsEnumerations.LockStatus.ERROR;
            log.error((Object)(String.valueOf(this.getName()) + " ERROR new read value FOR LOCK SENSOR  = " + newLockSensorValue), new String[0]);
            throw new SensorValueOutOfRangeException("ERROR in reading LOCK SENSOR", this.lockSensor.getName(), 0, 32768, mechaValue);
        }
    }

    @Deprecated
    public void updateStateWithSensorsFromSDO() throws HardwareException {
        this.lock.lock();
        this.updatingState = true;
        try {
            this.updateFilterPresenceStatus();
            this.updateLockStatus();
            this.clampState = this.computeClampState();
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
        }
        this.publishData();
    }

    @Command(level=1, description="Read clamp sensors and update clampState", type=Command.CommandType.QUERY, alias="updState")
    public void updateStateWithSensors() throws HardwareException, BadCommandException {
        this.updateStateWithSensors(this.bridge.readPDOs());
    }

    void updateStateWithSensors(CanOpenProxy.PDOStorage pdoStorage) throws HardwareException {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.updateFilterPresenceStatus(pdoStorage);
            this.updateLockStatus(pdoStorage);
            this.clampState = this.computeClampState();
        }
        finally {
            this.lock.unlock();
            this.updatingState = false;
            this.stateUpdated.signal();
        }
        this.publishData();
    }

    @Deprecated
    public void publishTrendingData(StatusDataPublishedByClamp status) {
        long timeStamp = System.currentTimeMillis();
        ArrayList<ValueNotification> trendingValues = new ArrayList<ValueNotification>();
        trendingValues.add(new ValueNotification(String.valueOf(this.getName()) + "/clampState", (Object)status.getClampState(), timeStamp));
        trendingValues.add(new ValueNotification(String.valueOf(this.getName()) + "/filterPositionInClamp", (Object)status.getFilterPositionInClamp(), timeStamp));
        trendingValues.add(new ValueNotification(String.valueOf(this.getName()) + "/filterPositionSensorValue", (Object)status.getFilterPositionSensorValue(), timeStamp));
        trendingValues.add(new ValueNotification(String.valueOf(this.getName()) + "/lockStatus", (Object)this.lockStatus, timeStamp));
        trendingValues.add(new ValueNotification(String.valueOf(this.getName()) + "/lockSensorValue", (Object)status.getLockSensorValue(), timeStamp));
        this.publishData(trendingValues);
    }

    public void publishData() {
        StatusDataPublishedByClamp status = this.getStatusData();
        this.publish("carouselClamp", status);
    }

    @Deprecated
    public void publishClampData() {
        KVList kvlist = new KVList(7);
        long timestamp = System.currentTimeMillis();
        kvlist.add("dataType", (Object)"carouselClamp");
        kvlist.add(String.valueOf(this.getName()) + "/clampState", (Object)this.clampState.toString());
        kvlist.add(String.valueOf(this.getName()) + "/filterPositionInClamp", (Object)this.filterPresenceStatus.toString());
        kvlist.add(String.valueOf(this.getName()) + "/filterPositionSensorValue", (Object)this.filterPresenceSensor.getValue());
        kvlist.add(String.valueOf(this.getName()) + "/lockStatus", (Object)this.lockStatus.toString());
        kvlist.add(String.valueOf(this.getName()) + "/lockSensorValue", (Object)this.lockSensor.getValue());
        this.publish(timestamp, kvlist);
    }

    public FcsEnumerations.FilterClampState computeClampState() {
        if (this.filterPresenceStatus.equals((Object)FcsEnumerations.FilterPresenceStatus.ERROR) || this.lockStatus.equals((Object)FcsEnumerations.LockStatus.ERROR)) {
            return FcsEnumerations.FilterClampState.ERROR;
        }
        if (this.filterPresenceStatus.equals((Object)FcsEnumerations.FilterPresenceStatus.LOCKABLE)) {
            if (this.lockStatus.equals((Object)FcsEnumerations.LockStatus.LOCKED)) {
                return FcsEnumerations.FilterClampState.CLAMPEDONFILTER;
            }
            if (this.lockStatus.equals((Object)FcsEnumerations.LockStatus.UNLOCKED)) {
                return FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER;
            }
            return FcsEnumerations.FilterClampState.UNDEFINED;
        }
        if (this.filterPresenceStatus.equals((Object)FcsEnumerations.FilterPresenceStatus.NOFILTER)) {
            if (this.lockStatus.equals((Object)FcsEnumerations.LockStatus.LOCKED)) {
                return FcsEnumerations.FilterClampState.READYTOCLAMP;
            }
            if (this.lockStatus.equals((Object)FcsEnumerations.LockStatus.UNLOCKED)) {
                return FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY;
            }
            return FcsEnumerations.FilterClampState.ERROR;
        }
        if (this.filterPresenceStatus.equals((Object)FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE)) {
            return FcsEnumerations.FilterClampState.UNDEFINED;
        }
        return FcsEnumerations.FilterClampState.UNDEFINED;
    }

    public StatusDataPublishedByClamp getStatusData() {
        StatusDataPublishedByClamp status = FcsUtils.createStatusDataPublishedByClamp(this);
        return status;
    }

    @Command(level=3, description="Release clamp in order to get ready to clamp a filter again", type=Command.CommandType.ACTION)
    public String release() throws HardwareException, BadCommandException, ErrorInCommandExecutionException {
        log.info((Object)("Checking conditions for release clamp " + this.getName() + " on socket at standby position."), new String[0]);
        this.updateStateWithSensors();
        if (!this.getClampState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY)) {
            throw new BadCommandException("Can't release a clamp if isn't unclamped and empty.");
        }
        log.info((Object)("Releasing clamp " + this.getName() + " on socket at standby position."), new String[0]);
        return this.executeAction(FcsEnumerations.MobileItemAction.RELEASE, this.timeoutForReleasing);
    }

    @Command(level=3, description="Unlock the clamp", type=Command.CommandType.ACTION)
    public String unlock() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        log.info((Object)(String.valueOf(this.getName()) + ": " + "UNLOCK State1 = " + this.clampState.toString()), new String[0]);
        this.updateStateWithSensors();
        if (!this.getClampState().equals((Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER)) {
            throw new BadCommandException("Can't unlock a clamp if it is already unlocked.");
        }
        BasicAutoChangerModule autochanger = (BasicAutoChangerModule)this.environment.getComponentByName("autochanger");
        if (autochanger == null) {
            throw new BadCommandException("NO AUTOCHANGER");
        }
        if (!autochanger.isHoldingFilterAtStandby()) {
            throw new BadCommandException("CANNOT UNLOCK A CLAMP if FILTER is not HELD by autochanger.");
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.UNLOCK, this.timeoutForUnlocking);
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws SDORequestException, BadCommandException, ErrorInCommandExecutionException {
        if (action.equals((Object)FcsEnumerations.MobileItemAction.UNLOCK)) {
            this.actuator.on();
        } else if (action.equals((Object)FcsEnumerations.MobileItemAction.RELEASE)) {
            this.actuator.off();
        } else {
            throw new IllegalArgumentException("Action on clamp must be UNLOCK or RELEASE");
        }
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action.equals((Object)FcsEnumerations.MobileItemAction.UNLOCK)) {
            return this.getClampState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER);
        }
        if (action.equals((Object)FcsEnumerations.MobileItemAction.RELEASE)) {
            return this.getClampState().equals((Object)FcsEnumerations.FilterClampState.READYTOCLAMP);
        }
        throw new IllegalArgumentException("Action on clamp must be UNLOCK or RELEASE");
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws HardwareException, BadCommandException {
        this.updateStateWithSensors();
    }

    public double updateTemperature() throws HardwareException {
        double temp;
        this.temperature = temp = this.thermometer.readTemperature();
        return temp;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("/filterPresenceSensor=");
        sb.append(this.filterPresenceSensor.getName());
        sb.append("#valueA=");
        sb.append(this.filterPositionValueA);
        sb.append("#valueB=");
        sb.append(this.filterPositionValueB);
        sb.append("#valueC=");
        sb.append(this.filterPositionValueC);
        sb.append("/lockSensor=");
        sb.append(this.lockSensor.getName());
        sb.append("#valueA=");
        sb.append(this.lockSensorValueA);
        sb.append("#valueB=");
        sb.append(this.lockSensorValueB);
        sb.append("#valueC=");
        sb.append(this.lockSensorValueC);
        return sb.toString();
    }

    @Override
    public void stopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        CurrentCommandContext currentCmdContext = (CurrentCommandContext)Subsystem.LOCAL_EXECUTION_INFO.get();
        log.debug((Object)("Command running:" + currentCmdContext.getCommandName()), new String[0]);
        log.info((Object)("coming from:" + currentCmdContext.getCommandOriginator()), new String[0]);
    }
}

