/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.FilterLocation;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;

public class FcsMainModule
extends MainModule {
    private static final long serialVersionUID = 7669526660659959402L;
    private CarouselModule carousel;
    private AutoChangerModule autochanger;
    private LoaderModule loader;
    private Double standbyPosition;
    private Map<String, Filter> filters = new HashMap<String, Filter>();
    private static final String ack = "[FCSMainModule]";

    public FcsMainModule(String aName, int aTickMillis, BridgeToHardware bridge) {
        super(aName, aTickMillis, bridge);
    }

    @Override
    public void initModule() {
        log.info((Object)"[FcsMainModule] Initializing the FCS Main module ", new String[0]);
        try {
            this.carousel = (CarouselModule)this.getModule("carousel");
            this.autochanger = (AutoChangerModule)this.getModule("autochanger");
            this.loader = (LoaderModule)this.getModule("loader");
            this.locateFilters();
            this.autochanger.locateTrucks();
            log.info((Object)("SUBSYSTEM NAME= " + this.getSubsystem().getName()), new String[0]);
            this.carousel.publishData();
            this.autochanger.publishData();
        }
        catch (RuntimeException e) {
            log.fatal((Object)("[FcsMainModule] ERROR: " + this.name + " Initialization failed for FCS main module : " + e.getMessage()), new String[0]);
            throw e;
        }
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        this.publish(v.getName(), v.getValue());
    }

    public String printFilters() {
        StringBuilder mess = new StringBuilder(ack);
        mess.append(" printFilters %n ");
        for (String key : this.filters.keySet()) {
            mess.append(this.filters.get(key).getName());
            mess.append(" ");
            mess.append((Object)this.filters.get(key).getFilterLocation());
            if (this.filters.get(key).isOnCarousel()) {
                mess.append(" position: ").append(this.carousel.getFilterPosition(this.filters.get(key)));
                mess.append(" socket number: ").append(this.carousel.getSocketNumber(this.filters.get(key)));
                mess.append(" standby position: ").append(this.carousel.getStandbyPositionForFilter(this.filters.get(key)));
            }
            mess.append(" %n ");
        }
        log.info((Object)mess.toString(), new String[0]);
        return mess.toString();
    }

    public String displayData() {
        StringBuilder sb = new StringBuilder("Data published by ");
        sb.append(this.getContext().getSubsystem().getName()).append("\n  ");
        sb.append(this.carousel.toString()).append("\n  ");
        sb.append(this.autochanger.toString());
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(this.carousel.toString());
        sb.append(this.autochanger.toString());
        return sb.toString();
    }

    @Deprecated
    public String stop(String moduleName) throws IllegalArgumentException {
        if (moduleName == null) {
            throw new IllegalArgumentException("Please enter the FCS subsystem you want to stop : carousel, autochanger or fliprail");
        }
        if (moduleName.equals("carousel")) {
            return this.carousel.stop();
        }
        if (moduleName.equals("autochanger")) {
            return this.autochanger.stopAutochanger();
        }
        throw new IllegalArgumentException("Bad module name : must be carousel or autochanger or fliprail ");
    }

    public String moveFilterToOnline(Object filterName) throws InterruptedException, IllegalArgumentException, BadCommandException, ErrorInCommandExecutionException, HardwareException, CanOpenException {
        this.controlFilterName(filterName);
        log.info((Object)("Filter to move : " + filterName), new String[0]);
        log.info((Object)("Filter location :" + (Object)((Object)this.getFilterByName((String)filterName).getFilterLocation())), new String[0]);
        return ack + this.moveFilterToOnline(this.getFilterByName((String)filterName));
    }

    public String moveFilterToStandby(Object filterName) throws InterruptedException, IllegalArgumentException, BadCommandException, ErrorInCommandExecutionException {
        this.controlFilterName(filterName);
        log.info((Object)("Filter to move : " + filterName), new String[0]);
        log.info((Object)("Filter location : " + (Object)((Object)this.getFilterByName((String)filterName).getFilterLocation())), new String[0]);
        return ack + this.moveFilterToStandby(this.getFilterByName((String)filterName));
    }

    private void locateFilters() {
        this.carousel.getSockets()[0].putFilterOnSocket(this.filters.get("filterU"));
        this.carousel.getSockets()[1].putFilterOnSocket(this.filters.get("filterG"));
        this.carousel.getSockets()[2].putFilterOnSocket(this.filters.get("filterR"));
        this.carousel.getSockets()[3].putFilterOnSocket(this.filters.get("filterI"));
        this.carousel.getSockets()[4].putFilterOnSocket(this.filters.get("filterZ"));
        this.carousel.engageClampsContact();
        this.filters.get("filterY").setFilterLocation(FilterLocation.OUT);
    }

    private String moveFilterToOnline(Filter filter) throws InterruptedException, BadCommandException, ErrorInCommandExecutionException, HardwareException, CanOpenException {
        if (this.carousel.isRotating() || this.autochanger.isMoving()) {
            throw new BadCommandException(String.valueOf(this.getName()) + " Please wait the end of the last command or send a stop command.");
        }
        if (filter == this.autochanger.getFilterOnTrucks()) {
            return this.autochanger.moveFilterToOnline(filter);
        }
        if (filter.isOnCarousel()) {
            if (!this.autochanger.isTrucksEmpty()) {
                Filter filterOnTrucks = this.autochanger.getFilterOnTrucks();
                if (!this.carousel.isReadyToGrabAFilterAtStandby()) {
                    throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + "/Carousel is not ready to grabbe a filter at standby position");
                }
                this.autochanger.moveFilterToStandby(filterOnTrucks);
                this.carousel.grabFilterAtStandby(filterOnTrucks);
                this.autochanger.ungrabFilterAtStandby();
            }
            this.carousel.moveFilterToStandby(filter);
            this.autochanger.grabFilterAtStandby(filter);
            this.carousel.ungrabFilterAtStandby(filter);
            this.autochanger.moveFilterToOnline(filter);
            this.carousel.releaseClamps();
            this.autochanger.closeOnlineClamp();
            return String.valueOf(this.getName()) + ": command moveFilterToOnline completed / filter on line: " + filter.getName();
        }
        String message = "Panic : filter is neither on carousel, neither on autochanger";
        log.error((Object)message, new String[0]);
        return message;
    }

    private String moveFilterToStandby(Filter filter) throws BadCommandException, InterruptedException, ErrorInCommandExecutionException {
        String message = null;
        if (filter.isOnCarousel()) {
            message = this.carousel.moveFilterToStandby(filter);
        } else if (filter.isOnAutoChanger()) {
            message = this.autochanger.moveFilterToStandby(filter);
        }
        return message;
    }

    public Filter getFilterAtStandby() {
        return this.carousel.getFilterAtStandby();
    }

    protected void controlFilterName(Object o) throws IllegalArgumentException {
        if (!(o instanceof String)) {
            throw new IllegalArgumentException("Incorrect filter name : " + o);
        }
        String filterName = (String)o;
        if (!this.filters.containsKey(filterName)) {
            throw new IllegalArgumentException("Unknown filter name : " + o);
        }
        if (this.getFilterByName(filterName).isUnknown()) {
            throw new IllegalArgumentException("Filter: " + o + " is at unknown location.");
        }
        if (this.getFilterByName(filterName).isOut()) {
            throw new IllegalArgumentException("Filter: " + o + " is out of the camera.");
        }
    }

    public Filter getFilterByName(String filterName) {
        return this.filters.get(filterName);
    }

    public boolean isEmptyStandBy() {
        return false;
    }

    public boolean isEmptyOnline() {
        return true;
    }

    protected Filter getFilterOnline() {
        return this.autochanger.getFilterOnline();
    }

    public Map<String, Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<String, Filter> filters) {
        this.filters = filters;
    }

    public Double getStandbyPosition() {
        return this.standbyPosition;
    }

    public void setStandbyPosition(Double standbyPosition) {
        this.standbyPosition = standbyPosition;
    }

    public void loadFilter(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        if (!this.carousel.isReadyToGrabAFilterAtStandby()) {
            throw new BadCommandException(String.valueOf(this.getName()) + " can't load a filter when socket at STANDBY position is not empty and ready.");
        }
        if (!this.autochanger.isAtStandoff() || !this.autochanger.isTrucksEmpty()) {
            throw new BadCommandException(String.valueOf(this.getName()) + " autochanger is not empty at STANDOFF position; can't load a filter.");
        }
        this.connectLoader();
        if (!this.loader.isHoldingAFilter() || !this.loader.isCarrierAtStoragePosition()) {
            throw new BadCommandException(String.valueOf(this.getName()) + " can't load filter because loader is not holding a filter at storage position.");
        }
        this.loader.moveToHandoff();
        this.autochanger.goToHandOff();
        this.autochanger.grabFilterAtHandoff(aFilter);
        aFilter.setFilterLocation(FilterLocation.ONAUTOCHANGER);
        this.loader.openHooks();
        this.loader.moveToStorage();
        this.disconnectLoader();
    }

    public void unloadFilter(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        if (!aFilter.isOnCarousel()) {
            throw new BadCommandException(String.valueOf(this.getName()) + " " + aFilter.getName() + " is not on the carousel, can't unload it.");
        }
        if (!this.carousel.isOnStandby(aFilter)) {
            throw new BadCommandException(String.valueOf(this.getName()) + " " + aFilter.getName() + " is not on the carousel at standby position, can't unload it.");
        }
        if (!this.autochanger.isAtStandoff() || !this.autochanger.isTrucksEmpty()) {
            throw new BadCommandException(String.valueOf(this.getName()) + " autochanger is not empty at STANDOFF position; can't unload a filter.");
        }
        this.connectLoader();
        log.info((Object)"=======> Autochanger trucks about to move empty to standby position.", new String[0]);
        this.autochanger.grabFilterAtStandby(aFilter);
        log.info((Object)"=======> Carousel is ungrabbing filter at standby position.", new String[0]);
        this.carousel.ungrabFilterAtStandby(aFilter);
        log.info((Object)"=======> Autochanger trucks about to move loaded with the filter to handoff position.", new String[0]);
        this.autochanger.moveFilterToHandoff(aFilter);
        log.info((Object)"=======> Carousel about to release Clamps.", new String[0]);
        this.carousel.releaseClamps();
        this.loader.moveToHandoff();
        this.loader.closeHooks();
        this.autochanger.ungrabFilterAtHandoff(aFilter);
        this.loader.clampHooks();
        this.loader.moveToStorage();
        aFilter.setFilterLocation(FilterLocation.OUT);
        this.disconnectLoader();
    }

    private void connectLoader() {
    }

    private void disconnectLoader() {
    }
}

