/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.List;
import java.util.Observable;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.bus.KVList;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.FcsMainModule;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterClampModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.common.Actuator;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.Carousel;
import org.lsst.ccs.subsystems.fcs.common.EngineState;
import org.lsst.ccs.subsystems.fcs.common.GenericLatch;
import org.lsst.ccs.subsystems.fcs.common.ModuleState;
import org.lsst.ccs.subsystems.fcs.common.Motor;
import org.lsst.ccs.subsystems.fcs.common.RunningWay;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CarouselModule
extends Module
implements Carousel {
    private static final long serialVersionUID = -2376279469784152348L;
    private final Motor carouselMotor;
    private Actuator clampActuatorXminus;
    private Actuator clampActuatorXplus;
    private BasicAutoChangerModule autochanger;
    private final int nbSockets;
    private static final CarouselSocket[] socketsModel = new CarouselSocket[0];
    private final CarouselSocket[] sockets;
    private BridgeToHardware bridge;
    private final GenericLatch brake;
    public static final String publishedByCarouselOutputName = "publishedByCarousel";
    private volatile ModuleState state = ModuleState.HALTED;
    private boolean stopped = false;

    public CarouselModule(String aName, int aTickMillis, Motor carouselMotor, GenericLatch brake, int nbSockets, List<CarouselSocket> socketsList) {
        super(aName, aTickMillis);
        this.carouselMotor = carouselMotor;
        this.brake = brake;
        this.nbSockets = nbSockets;
        this.sockets = socketsList.toArray(socketsModel);
    }

    public CarouselSocket[] getSockets() {
        return this.sockets;
    }

    @Override
    public double getPosition() {
        return this.carouselMotor.getPosition();
    }

    public synchronized ModuleState getState() {
        return this.state;
    }

    public synchronized void setState(ModuleState state) {
        this.state = state;
    }

    public int getNbSockets() {
        return this.nbSockets;
    }

    public Actuator getClampActuatorXminus() {
        return this.clampActuatorXminus;
    }

    public Actuator getClampActuatorXplus() {
        return this.clampActuatorXplus;
    }

    public FilterClampModule getClampXminus() {
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            return null;
        }
        return socketAtStandby.getClampXminus();
    }

    public FilterClampModule getClampXplus() {
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            return null;
        }
        return socketAtStandby.getClampXplus();
    }

    public void initModule() {
        log.info((Object)"[CarouselModule] Initializing the carousel module ", new String[0]);
        this.setState(ModuleState.HALTED);
        this.bridge = (BridgeToHardware)this.getModule("bridge");
        this.clampActuatorXminus = (Actuator)this.getModule("clampActuatorXminus");
        this.clampActuatorXplus = (Actuator)this.getModule("clampActuatorXplus");
        this.autochanger = (BasicAutoChangerModule)this.getModule("autochanger");
    }

    public StatusDataPublishedByCarousel getStatusData() {
        return FcsUtils.createStatusDataPublishedByCarousel(this);
    }

    @Deprecated
    public void publishCarouselData() {
        KVList kvlist = new KVList(7);
        long timestamp = System.currentTimeMillis();
        kvlist.add("dataType", (Object)"carousel");
        kvlist.add(String.valueOf(this.getName()) + "/nbSockets", (Object)this.nbSockets);
        kvlist.add(String.valueOf(this.getName()) + "/position", (Object)this.getPosition());
        kvlist.add(String.valueOf(this.getName()) + "/isLocked", (Object)this.isLocked());
        kvlist.add(String.valueOf(this.getName()) + "/filterInStandbyName", (Object)this.getFilterInStandbyName());
        this.publish(timestamp, kvlist);
    }

    public void publishData() {
        StatusDataPublishedByCarousel status = this.getStatusData();
        this.publish("carousel", status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("\n Numbers of sockets: ");
        sb.append(this.nbSockets);
        int i = 0;
        while (i < this.nbSockets) {
            sb.append("\n Socket number ");
            sb.append(i);
            sb.append(" / ");
            sb.append(String.valueOf((Object)this.sockets[i]));
            ++i;
        }
        return sb.toString();
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        StatusDataPublishedByCarousel status = this.getStatusData();
        this.publishData();
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, publishedByCarouselOutputName, (Object)status));
        log.info((Object)(String.valueOf(this.getName()) + ": Filter at standby position : " + this.getFilterInStandbyName()), new String[0]);
    }

    @Override
    public synchronized CarouselSocket getSocketAtStandby() {
        if (this.isRotating()) {
            return null;
        }
        CarouselSocket[] carouselSocketArray = this.sockets;
        int n = this.sockets.length;
        int n2 = 0;
        while (n2 < n) {
            CarouselSocket socket = carouselSocketArray[n2];
            if (this.getPosition() == socket.getStandbyPosition()) {
                return socket;
            }
            ++n2;
        }
        return null;
    }

    public synchronized Filter getFilterAtStandby() {
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            return null;
        }
        return socketAtStandby.getFilter();
    }

    public synchronized String getFilterInStandbyName() {
        Filter filterAtStandby = this.getFilterAtStandby();
        if (filterAtStandby == null) {
            return "none";
        }
        return filterAtStandby.getName();
    }

    @Command(level=1, description="Returns true if Carousel is stopped and no filter is at STANDBY position", type=Command.CommandType.QUERY)
    public boolean isReadyToGrabAFilterAtStandby() throws HardwareException {
        if (this.isRotating()) {
            return false;
        }
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            return false;
        }
        return socketAtStandby.isEmpty() && socketAtStandby.isReadyToClamp();
    }

    @Command(level=1, description="Returns true if a filter is clamped at STANDBY position", type=Command.CommandType.QUERY)
    public boolean isHoldingFilterAtStandby() throws HardwareException {
        if (this.isRotating()) {
            return false;
        }
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            return false;
        }
        if (socketAtStandby.isEmpty()) {
            return false;
        }
        return socketAtStandby.isClampedOnFilter();
    }

    public boolean isRotating() {
        return this.carouselMotor.getEngineState().equals(EngineState.RUNNING);
    }

    @Override
    @Command(level=1, description="Returns true if the brake is released", type=Command.CommandType.QUERY)
    public boolean isAbleToMove() {
        return !this.brake.isLocked();
    }

    public boolean isLocked() {
        return this.brake.isLocked();
    }

    @Override
    public String stop() {
        String message;
        if (this.isRotating()) {
            this.stopped = true;
            message = "Stopping carousel";
            this.carouselMotor.stop();
            this.setState(ModuleState.HALTED);
        } else {
            message = "Carousel is already stopped";
        }
        return message;
    }

    @Override
    @Command(level=1, description="Engage the carousel brake to stop the rotation", type=Command.CommandType.ACTION)
    public String engageBrake() {
        this.brake.lock();
        return String.valueOf(this.getName()) + " locked";
    }

    @Override
    @Command(level=1, description="Release the carousel brake", type=Command.CommandType.ACTION)
    public String releaseBrake() {
        this.brake.unlock();
        return String.valueOf(this.getName()) + " unlocked";
    }

    @Deprecated
    public void updateClampsStateWithSensorsFromSDO() throws BadCommandException, HardwareException {
        if (this.getSocketAtStandby() == null) {
            throw new BadCommandException(String.valueOf(this.getName()) + " can't update Clamps State because there is no socket at standby.");
        }
        this.getSocketAtStandby().updateClampsStateWithSensors();
    }

    public void updateClampsStateWithSensorsFromPDO() throws BadCommandException, HardwareException {
        if (this.getSocketAtStandby() == null) {
            throw new BadCommandException(String.valueOf(this.getName()) + " can't update Clamps State because there is no socket at standby.");
        }
        CanOpenProxy.PDOStorage pdoStore = this.bridge.readPDOs();
        this.getSocketAtStandby().updateClampsStateWithSensors(pdoStore);
    }

    @Command(level=1, description="Read clamps sensors and update clamps state", type=Command.CommandType.QUERY)
    public void updateClampsStateWithSensors() throws BadCommandException, HardwareException {
        this.updateClampsStateWithSensorsFromPDO();
    }

    @Override
    @Command(level=1, description="Rotate carousel for an angle", type=Command.CommandType.ACTION)
    public String rotate(double angle) throws IllegalArgumentException, BadCommandException {
        double absAngle;
        if (angle < -360.0 || angle > 360.0) {
            throw new IllegalArgumentException("Please enter an angle between -360 and +360");
        }
        RunningWay way = null;
        if (angle >= 0.0) {
            absAngle = angle;
            way = RunningWay.POSITIVE;
        } else {
            absAngle = -angle;
            way = RunningWay.NEGATIVE;
        }
        double requiredPosition = CarouselModule.addAngle(this.getPosition(), angle);
        return this.rotate(absAngle, way, requiredPosition);
    }

    private String rotate(double angle, RunningWay runningWay, double finalPosition) throws BadCommandException, IllegalArgumentException {
        if (angle < 0.0 || angle > 360.0) {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + " command rotate accepts angle only between 0 and 360)");
        }
        if (finalPosition < 0.0 || finalPosition > 360.0) {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + " command rotate accepts finalPosition only between 0 and 360)");
        }
        String message = null;
        if (this.isRotating()) {
            message = "Carousel is rotating, stop it before sending a new rotate command.";
            log.error((Object)message, new String[0]);
            throw new BadCommandException(message);
        }
        if (!this.isAbleToMove()) {
            message = "Carousel is unable to move. Check lock or flip rail.";
            log.error((Object)message, new String[0]);
            throw new BadCommandException(message);
        }
        this.stopped = false;
        this.setState(ModuleState.RUNNING);
        this.carouselMotor.setRequiredPosition(finalPosition);
        this.sendToReply(new CommandReply((Object)"Please wait during carousel rotation...", CommandReply.CommandStatus.OK));
        this.carouselMotor.move(angle, runningWay);
        message = "Rotating to required position: " + finalPosition;
        log.info((Object)message, new String[0]);
        while (this.isRotating()) {
            try {
                log.info((Object)"...carousel rotating, please wait.....", new String[0]);
                log.info((Object)(String.valueOf(this.getName()) + " WAITING TO BE AT REQUIRED POSITION=" + finalPosition), new String[0]);
                log.info((Object)this.state.toString(), new String[0]);
                Thread.sleep(this.tickMillis);
            }
            catch (InterruptedException interruptedException) {
                return "Sleeping interrupted";
            }
        }
        if (!this.isRotating()) {
            log.info((Object)("THREAD=" + Thread.currentThread().getName()), new String[0]);
            this.setState(ModuleState.HALTED);
            log.info((Object)"carousel is now stopped.", new String[0]);
            if (this.getPosition() == finalPosition) {
                message = "Command completed";
                log.info((Object)message, new String[0]);
            } else {
                message = "Command non completed: carousel is not stopped at the required position";
                log.info((Object)message, new String[0]);
            }
        }
        if (this.stopped) {
            message = "Command rotate carousel interrupted by command stop";
            log.info((Object)message, new String[0]);
        }
        if (!this.stopped && this.getPosition() != finalPosition) {
            message = "Command non completed: carousel is not stopped at the required position";
            log.error((Object)message, new String[0]);
        }
        return message;
    }

    public void tick() {
        try {
            this.updateClampsStateWithSensors();
        }
        catch (BadCommandException | HardwareException ex) {
            log.error((Object)ex.getMessage(), new String[0]);
            this.getSubsystem().raiseAlarm(ex.toString());
        }
        this.publishData();
    }

    private synchronized void putFilterOnCarousel(Filter filter) throws ErrorInCommandExecutionException, BadCommandException, HardwareException {
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            throw new BadCommandException(String.valueOf(this.getName()) + ": there is no socket at standby position to put a filter in.");
        }
        socketAtStandby.putFilterOnSocket(filter);
        StatusDataPublishedByCarousel status = this.getStatusData();
        this.publishData();
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, publishedByCarouselOutputName, (Object)status));
    }

    public synchronized void removeFilterFromCarousel(Filter filter) throws BadCommandException, HardwareException, ErrorInCommandExecutionException {
        if (filter == null) {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + " : removeFilterFromCarousel must have an argument not null");
        }
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            throw new BadCommandException(String.valueOf(this.getName()) + " : " + " : removeFilterFromCarousel can't remove the filter because there is no socket at standby position");
        }
        if (socketAtStandby.getFilter() == null) {
            throw new BadCommandException(String.valueOf(this.getName()) + " : " + " : removeFilterFromCarousel can't remove the filter because there is no filter at standby position");
        }
        if (!socketAtStandby.getFilter().equals(filter)) {
            throw new BadCommandException(String.valueOf(this.getName()) + " : can't remove a filter which is not at standby position");
        }
        socketAtStandby.removeFilter();
        StatusDataPublishedByCarousel status = this.getStatusData();
        this.publishData();
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, publishedByCarouselOutputName, (Object)status));
    }

    public double getFilterPosition(Filter filter) {
        double filterPosition = 0.0;
        int ix = 0;
        while (ix < this.sockets.length) {
            if (this.sockets[ix].getFilter() == filter) {
                filterPosition = this.sockets[ix].getPosition();
            }
            ++ix;
        }
        return filterPosition;
    }

    public double getStandbyPositionForFilter(Filter filter) {
        double position = 0.0;
        CarouselSocket[] carouselSocketArray = this.sockets;
        int n = this.sockets.length;
        int n2 = 0;
        while (n2 < n) {
            CarouselSocket socket = carouselSocketArray[n2];
            if (socket.getFilter() == filter) {
                position = socket.getStandbyPosition();
                return position;
            }
            ++n2;
        }
        return position;
    }

    public int getSocketNumber(Filter filter) {
        int socketNumber = 0;
        int ix = 0;
        while (ix < this.sockets.length) {
            if (this.sockets[ix].getFilter() == filter) {
                socketNumber = ix;
            }
            ++ix;
        }
        return socketNumber;
    }

    @Command(level=1, description="Rotate carousel to put filter at standby position", type=Command.CommandType.ACTION)
    protected String moveFilterToStandby(Filter filter) throws BadCommandException {
        RunningWay runningWay;
        double angle;
        if (!filter.isOnCarousel()) {
            throw new IllegalArgumentException("filter: " + filter.getName() + " is not on carousel.");
        }
        String message = " [CarouselModule]";
        double requiredPosition = this.getStandbyPositionForFilter(filter);
        if (this.state == ModuleState.RUNNING) {
            throw new BadCommandException("Carousel is running, stop it before sending a new command.");
        }
        if (this.getPosition() == requiredPosition) {
            log.info((Object)(String.valueOf(filter.getName()) + " is at STANDBY position on carousel."), new String[0]);
            return String.valueOf(filter.getName()) + " is at STANDBY position on carousel.";
        }
        if (this.brake.isLocked()) {
            log.info((Object)"Carousel is locked. Unlocking carousel", new String[0]);
            this.releaseBrake();
        }
        if ((angle = CarouselModule.addAngle(this.getPosition(), this.getFilterPosition(filter))) < 180.0) {
            runningWay = RunningWay.NEGATIVE;
        } else {
            angle = 360.0 - angle;
            runningWay = RunningWay.POSITIVE;
        }
        this.releaseClampsContact();
        this.rotate(angle, runningWay, requiredPosition);
        this.engageClampsContact();
        message = String.valueOf(message) + this.engageBrake();
        return message;
    }

    public void printSockets() {
        int ix = 0;
        while (ix < this.sockets.length) {
            log.info((Object)("Socket number: " + ix + " socket position: " + this.sockets[ix].getPosition() + " contains filter: " + this.sockets[ix].getFilter().getName()), new String[0]);
            ++ix;
        }
    }

    public String grabFilterAtStandby(Object filterName) throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        FcsMainModule fcsMainModule = (FcsMainModule)this.getModule("main");
        fcsMainModule.controlFilterName(filterName);
        Filter filterToGrabbe = fcsMainModule.getFilterByName((String)filterName);
        log.info((Object)("Filter to move : " + filterName), new String[0]);
        log.info((Object)("Filter location : " + (Object)((Object)filterToGrabbe.getFilterLocation())), new String[0]);
        return String.valueOf(this.getName()) + this.grabFilterAtStandby(filterToGrabbe);
    }

    public synchronized String grabFilterAtStandby(Filter filter) throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        if (filter == null) {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + ": grabbeFilterAtStandby must receive a non null argument as a filter");
        }
        if (this.isRotating()) {
            throw new BadCommandException(String.valueOf(this.getName()) + ": grabbeFilterAtStandby can't grabbe a filter while rotating");
        }
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            throw new BadCommandException(String.valueOf(this.getName()) + ": grabbeFilterAtStandby can't be executed because there is no socket at standby position.");
        }
        socketAtStandby.updateClampsStateWithSensors();
        if (socketAtStandby.isEmpty()) {
            throw new BadCommandException(String.valueOf(this.getName()) + ": grabbeFilterAtStandby can't be executed because no filter is detected in socket at standby position.");
        }
        if (socketAtStandby.isClampedOnFilter()) {
            log.info((Object)(String.valueOf(this.getName()) + ": grabbing " + filter.getName() + " at standby position."), new String[0]);
            this.putFilterOnCarousel(filter);
            log.info((Object)(String.valueOf(this.getName()) + ": " + filter.getName() + " is grabbed on carousel."), new String[0]);
            String ack = String.valueOf(this.getName()) + ": " + filter.getName() + " is grabbed at standby position";
            return ack;
        }
        throw new BadCommandException(String.valueOf(this.getName()) + ": grabbeFilterAtStandby can't be executed because the clamps are not CLAMPED ON FILTER.");
    }

    public void ungrabFilterAtStandby(Filter filter) throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        if (filter == null) {
            throw new IllegalArgumentException("Filter to ungrabbe should not be null");
        }
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            throw new BadCommandException(String.valueOf(this.getName()) + ":A socket has to be halted at standby position for this operation.");
        }
        if (!this.isOnStandby(filter)) {
            throw new BadCommandException(String.valueOf(this.getName()) + ": filter has to be at standby position to be ejected");
        }
        if (!socketAtStandby.isClampedOnFilter()) {
            throw new BadCommandException(String.valueOf(this.getName()) + ": can't ungrabbe filter which is already unclamped.");
        }
        log.info((Object)(String.valueOf(this.getName()) + ": ungrabbing " + filter.getName() + " at standby position."), new String[0]);
        this.unlockClamps(filter);
        log.info((Object)(String.valueOf(this.getName()) + ": socket at standby state : " + socketAtStandby.toString()), new String[0]);
        log.info((Object)(String.valueOf(this.getName()) + ": " + filter.getName() + " is ungrabbed from carousel."), new String[0]);
    }

    @Override
    @Command(level=1, description="Release clamps at standby position to get ready to clamp again", type=Command.CommandType.ACTION)
    public String releaseClamps() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            throw new BadCommandException(String.valueOf(this.getName()) + ":Can't release clamps while a socket is not halted at standby position.");
        }
        socketAtStandby.updateClampsStateWithSensors();
        if (!socketAtStandby.isEmpty()) {
            throw new BadCommandException(String.valueOf(this.getName()) + ":Can't release clamps while " + "a filter is in the socket at standby.");
        }
        if (!socketAtStandby.isUnclampedEmpty()) {
            throw new BadCommandException(String.valueOf(this.getName()) + ":Can't release clamps when both clamps are not in state UNCLAMPEDEMPTY.");
        }
        socketAtStandby.releaseClamps();
        socketAtStandby.updateClampsStateWithSensors();
        if (socketAtStandby.isReadyToClamp()) {
            return "Clamps are released and ready to clamp again.";
        }
        throw new ErrorInCommandExecutionException("Could not release clamps.");
    }

    @Override
    public synchronized String unlockClamps(Filter filter) throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        CarouselSocket socketAtStandby = this.getSocketAtStandby();
        if (socketAtStandby == null) {
            throw new BadCommandException("Can't unlock clamps while a socket is not halted at standby position.");
        }
        socketAtStandby.updateClampsStateWithSensors();
        if (!this.autochanger.isHoldingFilterAtStandby()) {
            throw new BadCommandException("Can't unlock clamps if the filter is not held by the autochanger.");
        }
        if (!socketAtStandby.isClampedOnFilter()) {
            throw new BadCommandException("Can't unlock clamps when a filter is not clamped at standby.");
        }
        log.info((Object)"Unlocking clamps at standby.", new String[0]);
        socketAtStandby.unlockClamps();
        socketAtStandby.updateClampsStateWithSensors();
        if (socketAtStandby.isUnclampedOnFilter()) {
            log.info((Object)"Just about to remove filter from carousel", new String[0]);
            this.removeFilterFromCarousel(filter);
            log.info((Object)"Command unlockClamps completed", new String[0]);
            return "Clamps unlocked";
        }
        log.info((Object)this.state, new String[0]);
        throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + ":Could not unlock filter at standby");
    }

    @Command(level=3, description="Unlock the clamps", type=Command.CommandType.ACTION)
    public String unlockClamps() throws BadCommandException, HardwareException, ErrorInCommandExecutionException {
        return this.unlockClamps(this.getFilterAtStandby());
    }

    public synchronized boolean isOnStandby(Filter filter) {
        return this.getPosition() == this.getStandbyPositionForFilter(filter);
    }

    public static double addAngle(double angle1, double angle2) {
        double angle = angle1 + angle2;
        if (angle >= 360.0) {
            angle -= 360.0;
        }
        if (angle < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    @Override
    public void releaseClampsContact() {
    }

    @Override
    public void engageClampsContact() {
    }
}

