/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterLatchModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.TruckModule;
import org.lsst.ccs.subsystems.fcs.common.EngineState;
import org.lsst.ccs.subsystems.fcs.common.FilterLatch;
import org.lsst.ccs.subsystems.fcs.common.ModuleState;
import org.lsst.ccs.subsystems.fcs.common.Motor;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class AutoChangerModule
extends BasicAutoChangerModule {
    private static final long serialVersionUID = -3737919230282962231L;
    private FilterLatch onlineClamp;
    private double trucksPositionOnline;
    private double trucksPositionAtStandby;
    private double trucksPositionSwapout;
    Motor motor;

    public AutoChangerModule(FilterLatch onlineClamp, double trucksPositionOnline, double trucksPositionAtStandby, double trucksPositionSwapout, Motor motor, String moduleName, int aTickMillis, FilterLatchModule latchXminus, FilterLatchModule latchXplus, TruckModule truckXminus, TruckModule truckXplus, String railsSensorsDIOName, String filterSensorsDIOName) {
        super(moduleName, aTickMillis, latchXminus, latchXplus, truckXminus, truckXplus, railsSensorsDIOName, filterSensorsDIOName);
        this.onlineClamp = onlineClamp;
        this.trucksPositionOnline = trucksPositionOnline;
        this.trucksPositionAtStandby = trucksPositionAtStandby;
        this.trucksPositionSwapout = trucksPositionSwapout;
        this.motor = motor;
    }

    @Override
    public void initModule() {
        log.info((Object)"[AutoChangerModule] Initializing the Auto Changer module ", new String[0]);
        this.setState(ModuleState.HALTED);
        this.motor.setMinimalPosition(this.getTrucksPositionAtStandby());
        this.motor.setMaximalPosition(this.getTrucksPositionOnline());
    }

    public StatusDataPublishedByAutoChanger getStatusData() {
        return FcsUtils.createStatusDataPublishedByAutoChanger(this);
    }

    private boolean isAbleToMove() {
        return !this.onlineClamp.isLocked();
    }

    public String closeOnlineClamp() throws ErrorInCommandExecutionException {
        if (!this.onlineClamp.isLocked()) {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + "online clamp couldn't be closed.");
        }
        String ack = String.valueOf(this.getName()) + ": online clamp closed";
        log.info((Object)ack, new String[0]);
        return ack;
    }

    public String openOnlineClamp() throws ErrorInCommandExecutionException {
        if (this.onlineClamp.isLocked()) {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + "online clamp couldn't be open.");
        }
        String ack = String.valueOf(this.getName()) + ": online clamp open";
        log.info((Object)ack, new String[0]);
        return ack;
    }

    public FilterLatch getOnlineClamp() {
        return this.onlineClamp;
    }

    public void setOnlineClamp(FilterLatch onlineClamp) {
        this.onlineClamp = onlineClamp;
    }

    @Override
    public String goToPosition(double requiredPosition) throws IllegalArgumentException, BadCommandException {
        String message = null;
        if (requiredPosition > this.getTrucksPositionOnline() || requiredPosition < this.getTrucksPositionAtStandby()) {
            throw new IllegalArgumentException("Please enter a position between " + this.getTrucksPositionAtStandby() + " and " + this.getTrucksPositionOnline());
        }
        if (this.isMoving()) {
            message = "Auto-changer is moving, stop it before sending a new motion command.";
            log.error((Object)message, new String[0]);
            throw new BadCommandException(message);
        }
        if (!this.isAbleToMove()) {
            message = "Auto-changer is unable to move because fliprail is open or online clamp is locked.";
            log.error((Object)message, new String[0]);
            throw new BadCommandException(message);
        }
        this.setState(ModuleState.RUNNING);
        this.motor.setRequiredPosition(requiredPosition);
        log.info((Object)(String.valueOf(this.getName()) + " is moving to position: " + requiredPosition), new String[0]);
        log.info((Object)"Please wait during auto-changer motion...", new String[0]);
        message = "Moving to required position: " + requiredPosition;
        double displacement = requiredPosition - this.getTrucksPosition();
        this.motor.move(displacement);
        log.info((Object)("AutoChanger moving to required position: " + requiredPosition + ", please wait..."), new String[0]);
        while (this.isMoving()) {
            try {
                log.info((Object)"...auto-changer moving, please wait.....", new String[0]);
                log.info((Object)(String.valueOf(this.getName()) + " WAITING TO BE AT REQUIRED POSITION=" + requiredPosition), new String[0]);
                log.info((Object)this.state.toString(), new String[0]);
                Thread.sleep(this.tickMillis);
            }
            catch (InterruptedException interruptedException) {
                return "Sleeping interrupted";
            }
        }
        if (!this.isMoving()) {
            log.info((Object)("THREAD=" + Thread.currentThread().getName()), new String[0]);
            this.state = ModuleState.HALTED;
            this.publishDataAndNotifyObservers();
            log.info((Object)"auto-changer is now halted.", new String[0]);
            log.info((Object)("filter on truck: " + this.getFilterOnTrucksName()), new String[0]);
            if (this.getTrucksPosition() == requiredPosition) {
                message = "goToPosition command completed";
                log.info((Object)message, new String[0]);
            } else {
                message = "goToPosition command non completed: auto-changer is not stopped at the required position";
                log.info((Object)message, new String[0]);
            }
        }
        log.error((Object)message, new String[0]);
        return message;
    }

    @Deprecated
    public String stopAutochanger() {
        String message;
        if (this.isMoving()) {
            message = "Stopping auto-changer";
            this.motor.stop();
            this.state = ModuleState.HALTED;
        } else {
            message = "Auto-changer is already stopped";
        }
        return message;
    }

    @Override
    public String moveFilterToOnline(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException {
        if (this.isTrucksEmpty()) {
            throw new BadCommandException("Autochanger is empty");
        }
        if (this.getTrucksPosition() == this.getTrucksPositionOnline()) {
            throw new BadCommandException("Filter " + aFilter.getName() + " is already at online position.");
        }
        this.goToPosition(this.getTrucksPositionOnline());
        if (this.getTrucksPosition() == this.getTrucksPositionOnline()) {
            log.info((Object)(String.valueOf(this.getName()) + ": " + aFilter.getName() + " is at online position"), new String[0]);
            return this.closeOnlineClamp();
        }
        log.error((Object)"", new String[0]);
        return null;
    }

    @Override
    public String moveFilterToStandby(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException {
        if (this.isTrucksEmpty()) {
            throw new BadCommandException("Autochanger is empty");
        }
        if (this.getTrucksPosition() == this.getTrucksPositionAtStandby()) {
            throw new BadCommandException("Filter " + this.filterOnTrucks.getName() + " is already at standby position.");
        }
        this.openOnlineClamp();
        this.goToPosition(this.getTrucksPositionAtStandby());
        if (this.getTrucksPosition() == this.getTrucksPositionAtStandby()) {
            log.info((Object)(String.valueOf(this.getName()) + ": " + this.filterOnTrucks.getName() + " is at standby position."), new String[0]);
            return String.valueOf(this.getName()) + ": " + this.filterOnTrucks.getName() + " is at standby position.";
        }
        String message = "the autochanger truck is not at the required position.";
        log.error((Object)message, new String[0]);
        throw new ErrorInCommandExecutionException(message);
    }

    public Filter getFilterOnline() {
        if (this.getTrucksPosition() == this.getTrucksPositionOnline() && !this.isMoving()) {
            return this.filterOnTrucks;
        }
        return null;
    }

    public String getFilterOnlineName() {
        if (this.getFilterOnline() == null) {
            return "none";
        }
        return this.getFilterOnline().getName();
    }

    @Override
    public double getTrucksPosition() {
        return this.motor.getPosition();
    }

    public double getTrucksPositionAtStandby() {
        return this.trucksPositionAtStandby;
    }

    public double getTrucksPositionOnline() {
        return this.trucksPositionOnline;
    }

    public double getTrucksPositionSwapout() {
        return this.trucksPositionSwapout;
    }

    @Override
    public synchronized void locateTrucks() {
        this.filterOnTrucks = null;
        this.setTrucksEmpty(true);
    }

    public void setTrucksPositionAtStandby(double trucksPositionAtStandby) {
        this.trucksPositionAtStandby = trucksPositionAtStandby;
    }

    public void setTrucksPositionOnline(double trucksPositionOnline) {
        this.trucksPositionOnline = trucksPositionOnline;
    }

    public void setTrucksPositionSwapout(double trucksPositionSwapout) {
        this.trucksPositionSwapout = trucksPositionSwapout;
    }

    public Motor getMotor() {
        return this.motor;
    }

    public void setMotor(Motor motor) {
        this.motor = motor;
    }

    @Override
    public boolean isMoving() {
        return this.motor.getEngineState().equals(EngineState.RUNNING);
    }

    @Override
    public boolean isAtStandby() {
        return this.getTrucksPosition() == this.trucksPositionOnline;
    }

    @Override
    public String goToStandback() throws BadCommandException, ErrorInCommandExecutionException {
        return this.goToPosition(this.trucksPositionSwapout);
    }

    @Override
    public String goToStandby() throws BadCommandException {
        return this.goToPosition(this.trucksPositionAtStandby);
    }

    @Override
    public String moveFilterToStandback(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException {
        return this.moveFilterToOnline(aFilter);
    }

    @Override
    public boolean isMovingToStandback() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isMovingToStandby() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateStateWithSensors() throws HardwareException, ErrorInCommandExecutionException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void goToHandOff() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Command(level=1, description="Return true if the trucks are at HANDOFF position and hold a filter", type=Command.CommandType.QUERY)
    public boolean isHoldingFilterAtHandoff() {
        if (this.isMoving()) {
            return false;
        }
        if (!this.isAtHandoff()) {
            return false;
        }
        if (this.isTrucksEmpty()) {
            return false;
        }
        return this.getLatchesState().equals((Object)FcsEnumerations.LockStatus.LOCKED);
    }

    @Override
    public void closeLatchesAtHandoff() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void moveFilterToHandoff(Filter aFilter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    boolean isAtStandoff() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

