/*
 * To change this template, choose Tools | Templates
 * and on the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.utils;

import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FilterClampModule;
import org.lsst.ccs.subsystems.fcs.FilterLatchModule;
import org.lsst.ccs.subsystems.fcs.LoaderHookModule;
import org.lsst.ccs.subsystems.fcs.LatchActuatorModule;
import org.lsst.ccs.subsystems.fcs.LoaderCarrierModule;
import org.lsst.ccs.subsystems.fcs.LoaderClampModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClampActuator;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderHook;
import org.lsst.ccs.subsystems.fcs.common.Actuator;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderCarrierConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderClampConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderHookConfig;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftMainModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.ActuatorConfig;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.ClampConfig;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.SingleFilterTestConfig;
import org.lsst.ccs.subsystems.fcs.testbench.LPSCTestBenchMainModule;

/**
 *
 * @author turri
 */
public class FcsUtils {
    

    public static SingleFilterTestConfig createSingleFilterTestConfig(SftMainModule main) {
        CarouselModule carouselModule = main.getCarouselModule();
        boolean controlRealHardware = main.controlRealHardware();
        BasicAutoChangerModule autochanger = (BasicAutoChangerModule)main.getAutoChangerModule();
        return new SingleFilterTestConfig(controlRealHardware,
                createClampConfig(carouselModule.getClampXminus()), 
                createClampConfig(carouselModule.getClampXplus()), 
                createActuatorConfig((Actuator)(carouselModule.getClampActuatorXminus())),
                createActuatorConfig((Actuator)(carouselModule.getClampActuatorXplus())),
                createActuatorConfig((LatchActuatorModule)(((FilterLatchModule)autochanger.getLatchXminus()).getLatchActuator())),
                createActuatorConfig((LatchActuatorModule)(((FilterLatchModule)autochanger.getLatchXplus()).getLatchActuator()))
                );
    }
    

    

    public static ClampConfig createClampConfig(FilterClampModule filterModule) {
        return new ClampConfig(filterModule.getName(), filterModule.getFilterPositionValueA(), filterModule.getFilterPositionValueB(),
                filterModule.getFilterPositionValueC(), filterModule.getLockSensorValueA(), filterModule.getLockSensorValueB(), filterModule.getLockSensorValueC(),
                filterModule.getFilterPositionMinValue(),filterModule.getFilterPositionMaxValue(),
                filterModule.getLockSensorMinValue(), filterModule.getLockSensorMaxValue());
    }
    
    public static ActuatorConfig createActuatorConfig(Actuator actuator) {
        return new ActuatorConfig(
                actuator.getSentCurrentMinValue(),
                actuator.getSentCurrentMaxValue()
                );
    }
    
    public static ActuatorConfig createActuatorConfig(LatchActuatorModule actuatorModule) {
        return new ActuatorConfig(
                actuatorModule.getSpeedVoltageMinValue(),
                actuatorModule.getSpeedVoltageMaxValue()
                );
    }
    
    public static LoaderConfig createLoaderConfig(LPSCTestBenchMainModule main) {
        return new LoaderConfig(main.controlRealHardware(), createLoaderClampConfig(main.getLoader().getClamp()), 
                createLoaderCarrierConfig(main.getLoader().getCarrier()));
    }
    
    public static LoaderClampConfig createLoaderClampConfig(LoaderClampModule clamp) {
        return new LoaderClampConfig(clamp.getMinPosition(),
                clamp.getMaxPosition(),
                clamp.getTargetPositionToOpen(),
                clamp.getTargetPositionToClose(),
                clamp.getTargetPositionToClamp(),
                clamp.getTimeoutForOpeningHooks(),
                clamp.getTimeoutForClosingHooks(),
                clamp.getTimeoutForClampingHooks(),
                clamp.getTimeoutForGoingToHomePosition(),
                createLoaderHookConfig(clamp.getHook1()), 
                createLoaderHookConfig(clamp.getHook2()), 
                createLoaderHookConfig(clamp.getHook3()), 
                createLoaderHookConfig(clamp.getHook4()));      
    }
    
    public static LoaderHookConfig createLoaderHookConfig(LoaderHookModule hook) {        
        LoaderHookConfig loaderHookConfig = new LoaderHookConfig(hook.getName(), 
                hook.getLockSensor().getDigitalValue(),
                hook.getUnlockSensor().getDigitalValue(),
                hook.isInError());
        return loaderHookConfig;
        
    }
    
    public static LoaderCarrierConfig createLoaderCarrierConfig(LoaderCarrierModule carrier) {
        return new LoaderCarrierConfig(carrier.getName());
    }

    
    public static StatusDataPublishedByBasicAutoChanger createStatusDataPublishedByBasicAutoChanger(BasicAutoChangerModule basicAutoChanger) {
        StatusDataPublishedByBasicAutoChanger status = new StatusDataPublishedByBasicAutoChanger();
        status.setName(basicAutoChanger.getName());
        status.setFilterOnTrucksName(basicAutoChanger.getFilterOnTrucksName());
        status.setTrucksEmpty(basicAutoChanger.isTrucksEmpty()); 
        //status.setTrucksLocation(basicAutoChanger.getLastTrucksLocation());        
        status.setRailSensorStandbackXminusValue(basicAutoChanger.getTruckXminus().getRailSensorStandback().getDigitalValue());
        status.setRailSensorStandbackXplusValue(basicAutoChanger.getTruckXplus().getRailSensorStandback().getDigitalValue());
        status.setRailSensorStandbyXminusValue(basicAutoChanger.getTruckXminus().getRailSensorStandby().getDigitalValue());
        status.setRailSensorStandbyXplusValue(basicAutoChanger.getTruckXplus().getRailSensorStandby().getDigitalValue());
        status.setMovingToStandback(basicAutoChanger.isMovingToStandback());
        status.setMovingToStandby(basicAutoChanger.isMovingToStandby());
        return status;
    }
    
    public static StatusDataPublishedByAutoChanger  createStatusDataPublishedByAutoChanger(AutoChangerModule autochanger) {
        StatusDataPublishedByAutoChanger status = new StatusDataPublishedByAutoChanger();
        status.setName(autochanger.getName());
        status.setFilterOnTrucksName(autochanger.getFilterOnTrucksName());
        status.setTrucksEmpty(autochanger.isTrucksEmpty());
        status.setTrucksLocation(autochanger.getTrucksLocation());
        status.setIsLockedOnlineClamp(autochanger.getOnlineClamp().isLocked());
        return status;
    }
    
    
    public static StatusDataPublishedByCarousel createStatusDataPublishedByCarousel(CarouselModule carousel) {
        int nbSockets = carousel.getNbSockets();
        StatusDataPublishedByCarousel status = new StatusDataPublishedByCarousel(nbSockets); 
        status.setRotationInDegrees(carousel.getPosition());
        status.setIsLocked(carousel.isLocked());
        
        
        for (int i = 0; i < nbSockets; i++) {
            status.setFilterName(i, carousel.getSockets()[i].getFilter() == null ? "empty" : carousel.getSockets()[i].getFilter().getName());
            
            StringBuilder sb = new StringBuilder("Socket number: ");
            sb.append(i).append("\n");
            sb.append(carousel.getSockets()[i].toString());
            //status.setClampsInfo(i, sb.toString());
            
        }
        status.setFilterInStandbyName(carousel.getFilterInStandbyName());

        status.setActuatorXminusState(carousel.getClampActuatorXminus().toString());
        status.setActuatorXplusState(carousel.getClampActuatorXplus().toString());
        return status;
    }
    

    public static StatusDataPublishedByClamp createStatusDataPublishedByClamp(FilterClampModule clamp) {
        StatusDataPublishedByClamp status = new StatusDataPublishedByClamp();
        status.setName(clamp.getName());
        status.setClampState(clamp.getClampState().toString());
        status.setFilterPositionInClamp(clamp.getFilterPresenceStatus().toString());
        status.setFilterPositionSensorValue(clamp.getFilterPresenceSensor().getValue());
        status.setLockSensorValue(clamp.getLockSensor().getValue());
        status.setLockStatus(clamp.getLockStatus().toString());      
        status.setTemperature(clamp.getTemperature());
        return status;
    }
    
    public static StatusDataPublishedByClampActuator createStatusDataPublishedByClampActuator(Actuator actuator) {
        StatusDataPublishedByClampActuator status = new StatusDataPublishedByClampActuator();
        status.setName(actuator.getName());
        status.setReadValue(actuator.getReadValue());
        status.setSentValue(actuator.getSentValue());
        status.setOn(actuator.isOn());
        return status;
    }
        
    public static StatusDataPublishedByLatch createStatusDataPublishedByLatch(FilterLatchModule latch) {
        StatusDataPublishedByLatch status = new StatusDataPublishedByLatch();
        status.setName(latch.getName());
        status.setLockSensorValue(latch.getLockSensor().getDigitalValue());
        status.setUnlockSensorValue(latch.getUnlockSensor().getDigitalValue());
        status.setFilterPositionSensorValue(latch.getFilterPresenceSensor().getDigitalValue());
        status.setLockStatus(latch.getLockStatus().toString());
        return status;
    }
    
    public static StatusDataPublishedByLoaderClamp createStatusDataPublishedByLoaderClamp(LoaderClampModule clamp) {
        StatusDataPublishedByLoaderClamp status = new StatusDataPublishedByLoaderClamp();
        //if I use the following constructer I get an error :
        //java.lang.IllegalArgumentException: can't encode this value: clamp/position=0/state=UNLOCKED
//        StatusDataPublishedByLoaderClamp status = new StatusDataPublishedByLoaderClamp(clamp.getName(),
//            clamp.getLockStatus().toString(),
//            clamp.getPosition(),           
//            createStatusDataPublishedByLoaderHook(clamp.getHook1()),
//            createStatusDataPublishedByLoaderHook(clamp.getHook2()),
//            createStatusDataPublishedByLoaderHook(clamp.getHook3()),
//            createStatusDataPublishedByLoaderHook(clamp.getHook4())
//            );
        status.setName(clamp.getName());
        status.setPosition(clamp.getPosition());
        status.setClampState(clamp.getLockStatus().toString());       
        status.setStatusPublishedByHook1(createStatusDataPublishedByLoaderHook(clamp.getHook1()));
        status.setStatusPublishedByHook2(createStatusDataPublishedByLoaderHook(clamp.getHook2()));
        status.setStatusPublishedByHook3(createStatusDataPublishedByLoaderHook(clamp.getHook3()));
        status.setStatusPublishedByHook4(createStatusDataPublishedByLoaderHook(clamp.getHook4()));
        return status;
    }

    private static StatusDataPublishedByLoaderHook createStatusDataPublishedByLoaderHook(LoaderHookModule hook) {
        StatusDataPublishedByLoaderHook status = new StatusDataPublishedByLoaderHook(hook.getName(),
                hook.getLockSensor().getDigitalValue(),
                hook.getUnlockSensor().getDigitalValue(),
                hook.isInError(),
                hook.getLockStatus().toString()
            );
//        status.setName(hook.getName());
//        status.setLockSensorValue(hook.getLockSensor().getDigitalValue());
//        status.setUnlockSensorValue(hook.getUnlockSensor().getDigitalValue());
//        status.setLockStatusString(hook.getLockStatus().toString());       
        return status;
    }

    /**
     *
     * @param bin
     * @return
     */
    public static String binaryToHex(String bin) {
        int binaryToInt = Integer.parseInt(bin, 2);
        return Integer.toHexString(binaryToInt);
    }

    /**
     * The String argument represents an integer in hexa.
     * This methods eturns a string representation of this integer argument as an unsigned integer in base 2.
     * @param Hex
     * @return the binary form of this integer with 8 digits
     * examples :
     * HexToBinary(4)  returns 00000100
     * HexToBinary(AA) returns 10101010
     * HexToBinary(FF) returns 11111111
     */
    public static String hexToBinary(String Hex) {
        int integer = Integer.parseInt(Hex, 16);
        String bin = Integer.toBinaryString(integer);
        return String.format("%08d", Integer.parseInt(bin));
    }




    

    
}
