/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import java.beans.ConstructorProperties;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderCarrierConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderClampConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderConfig;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import static org.lsst.ccs.subsystems.fcs.utils.FcsUtils.createLoaderClampConfig;
import static org.lsst.ccs.subsystems.fcs.utils.FcsUtils.createLoaderCarrierConfig;

/**
 * This is the Main Module for the LPSC test bench control software.
 * The test bench is to test the hardware of the loader.
 * @author virieux
 */
public class LPSCTestBenchMainModule  extends MainModule {
 
    
    private LoaderModule loader;
    private AutoChangerModule autochanger;
    private final NumericSensor autochangerPresenceSensor;
    
    @ConstructorProperties({"name", "tickmillis", "bridge", "autochangerPresenceSensor"})
    public LPSCTestBenchMainModule(String aName, int aTickMillis, 
            BridgeToHardware bridge,
            NumericSensor autochangerPresenceSensor) {
        super(aName, aTickMillis, bridge);
        this.autochangerPresenceSensor = autochangerPresenceSensor;
    }

    public LoaderModule getLoader() {
        return loader;
    }
    
   
    
    

    @Override
    public void initModule() {
        super.initModule();
        this.loader = (LoaderModule)this.getModule("loader");
        this.autochanger = (AutoChangerModule) this.getModule("autochanger");
    }
    
    @Command(type=Command.CommandType.ACTION, level=Command.NORMAL, description="Open the loader clamp.")
    public String openHooks() throws SDORequestException, BadCommandException, ErrorInCommandExecutionException, HardwareException  {  
       return loader.openHooks();
    }
    
    @Command(type=Command.CommandType.ACTION, level=Command.NORMAL, description="Close the loader clamp.")
    public String closeHooks() throws BadCommandException, SDORequestException, ErrorInCommandExecutionException, HardwareException {  
        return loader.closeHooks();
    }
    
    @Command(type=Command.CommandType.ACTION, level=Command.NORMAL, description="Clamp the loader clamp.")
    public String clampHooks() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        return loader.clampHooks();
    }
    
    @Command(type=Command.CommandType.ACTION, level=Command.NORMAL, description="Update loader state in reading the sensors.")
    public void updateStateWithSensors() throws HardwareException, ErrorInCommandExecutionException {
        this.loader.getClamp().updateStateWithSensors();
    }
    
    @Command(type=Command.CommandType.QUERY, level=Command.NORMAL, description="List and display hooks sensors.")
    public String listHooksSensors() {
        return this.loader.getClamp().listHooks();
    }
    
    @Command(type=Command.CommandType.QUERY, level=Command.NORMAL, description="List and display the hooks sensors values.")
    public String listSensorsValues() {
        return this.loader.getClamp().listSensorsValues();
    }
    
    @Command(type=Command.CommandType.QUERY, level=Command.NORMAL, description="The GUIs need that for the initialization.")
    public LoaderConfig getFullState() {
        return FcsUtils.createLoaderConfig(this);
    }
    
    //just for tests
    public String testClampConfig() {
        LoaderClampConfig loaderClampConfig = createLoaderClampConfig(this.getLoader().getClamp());
        return loaderClampConfig.toString();
    }
    
    //just for tests
    public String testCarrierConfig() {
        LoaderCarrierConfig loaderCarrierConfig = createLoaderCarrierConfig(this.getLoader().getCarrier());
        return loaderCarrierConfig.toString();
    }
    
    @Override
    public TreeWalkerDiag signal(Signal signal) {
        switch(signal.getLevel()) {
            case HALT :
                log.debug("HALT required");
                this.haltRequired.set(true);
                break;
            case INTERRUPT1 :
                break;
            case INTERRUPT2 :
                break;
            case RE_START :
                this.haltRequired.set(false);
                break;
        }
        //we want the signal to go to all my children.
        return TreeWalkerDiag.GO;
    }
 
    

    
    
}
