/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.HygrometryGauge;
import org.lsst.ccs.subsystems.fcs.common.PressureGauge;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

/**
 * Main Module for the test bench in LPC in Clermont-Ferrand.
 * @author virieux
 */
public class LPCTestBenchMainModule extends MainModule {
    
    
    private final HygrometryGauge hygrometrySensor;
    private final PressureGauge pressureSensor;
    private final Thermometer thermometer;
    private final CanOpenLED led;
    private final CanOpenLED fakeLed;
    private final Thermometer fakeSensor;
    
    public double temperature;
    public double pressure;
    public double hygrometry;



    public LPCTestBenchMainModule(String aName, int aTickMillis, BridgeToHardware bridge, 
            HygrometryGauge hygrometrySensor, 
            PressureGauge pressureSensor, 
            Thermometer thermometer, 
            CanOpenLED led, 
            CanOpenLED fakeLed, 
            Thermometer fakeSensor) {
        super(aName, aTickMillis, bridge);
        this.hygrometrySensor = hygrometrySensor;
        this.pressureSensor = pressureSensor;
        this.thermometer = thermometer;
        this.led = led;
        this.fakeLed = fakeLed;
        this.fakeSensor = fakeSensor;
    }
    
    public double readHygrometry() throws HardwareException {
        this.hygrometry = this.hygrometrySensor.readHygrometry();
        return this.hygrometry;
    }
    
    public double readPressure() throws HardwareException {
        this.pressure = this.pressureSensor.readPressure();
        return this.pressure;
    }
    
    public double readTemperature() throws HardwareException {
        this.temperature = this.thermometer.readTemperature();
        return this.temperature;
    }
    
    public String turnOnLED() throws SDORequestException, HardwareNotDetectedException {
        return led.turnON();
    }
    

    
    public String turnOffLED() throws SDORequestException, HardwareNotDetectedException {
        return led.turnOFF();       
    }
    
    public String turnOnFakeLED() throws SDORequestException, HardwareNotDetectedException {
        return fakeLed.turnON();       
    }
    
    public String turnOffFakeLED() throws SDORequestException, HardwareNotDetectedException {
        return fakeLed.turnOFF();       
    }
    
    public double readFakeSensor() throws HardwareException, BadCommandException {
//        CanOpenProxy.PDOStorage pdoStore = this.bridge.readPDOs();
//        return this.fakeSensor.readTemperatureWithPDO(pdoStore);
        return this.fakeSensor.readTemperature();
    }
    
    @Override
    public void tick() {
        try {
            readTemperature();
            readPressure();
            readHygrometry();            
            this.publish("temperature", this.temperature);
            this.publish("hygrometry", this.hygrometry);
            this.publish("pressure", this.pressure);
            
        } catch (HardwareException ex) {
            log.debug(getName() + "couldn't read sensors");
        }
    }
    
    
    
}
