/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.framework.Module;
//import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAPCTestBench;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy.PDOStorage;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ReadingADCException;

/**
 *This is the main module for the control software of the APC test bench.
 * 
 * When the TestBenchMainModule starts, it starts a a TCP-IP server.
 * the can open wrapper software will connect. 
 * Then the TestBenchProxy and the Wrapper will communicate over this TCP connection 
 * with a protocol to be define.
 * In a first version :
 * 1- The TCP server is started and waits for a client connection,
 * 2- When the client connects, it sends first a key word "TestBench".
 * 3- When the server receives the key word "TestBench", it's ready to boot the hardware 
 * and receive commands.
 * @author virieux
 */
public class APCTestBenchMainModule extends Module {
    
    
    
    private BridgeToHardware bridge;
    
    /*** The thermometer mesures the temperature inside the clamp.
    */
    private Thermometer thermometer;
    private CanOpenLED led;
    private CanOpenLED fakeLed;
    private Thermometer fakeSensor;
    
    public double temperature;


    public BridgeToHardware getBridge() {
        return bridge;
    }

    public void setBridge(BridgeToHardware bridge) {
        this.bridge = bridge;
    }
    

    public Thermometer getThermometer() {
        return thermometer;
    }

    public void setThermometer(Thermometer thermometer) {
        this.thermometer = thermometer;
    }

    public CanOpenLED getLed() {
        return led;
    }

    public void setLed(CanOpenLED led) {
        this.led = led;
    }

    public CanOpenLED getFakeLed() {
        return fakeLed;
    }

    public void setFakeLed(CanOpenLED fakeLed) {
        this.fakeLed = fakeLed;
    }

    public Thermometer getFakeSensor() {
        return fakeSensor;
    }

    public void setFakeSensor(Thermometer fakeSensor) {
        this.fakeSensor = fakeSensor;
    }
    

    
    

    

    

    
        /**
     * Returns the value read on the socket for the input of the ADC given as an argument.
     * @param responseLine A string read on the socket.
     * @param inputNB  The numero if the input on the ADC. (1<=inputNB<=8)
     * @return the value (int) given 
     * @throws ReadingADCError 
     */
    public int getReturnValue(String responseLine, int inputNB) throws ReadingADCException {
            if (inputNB <1 || inputNB >8) throw new IllegalArgumentException();
            String[] words = ((String) responseLine).split(",");
            //String command = words[0];
            log.debug("Value in HEXA:" + words[inputNB]);
            int value = Integer.parseInt(words[inputNB],16);
            log.debug("Value in decimal:" + words[inputNB]);
            return value;
    }
    
    
    public double readTemperature() throws HardwareException {
        return this.thermometer.readTemperature();
    }
    
    public double readTemperatureFromPDO() throws HardwareException, BadCommandException {
        PDOStorage pdoStore = this.bridge.readPDOs();
        return this.thermometer.readTemperatureWithPDO(pdoStore);
    }
   
    
    

    
    
//    public void turnOnLED() throws InterruptedException, SDORequestError, HardwareNotDetectedException {
//        if (!tcpProxy.isHardwareIdentified()) throw new HardwareControlNotReady(getMyClientName());
//        //getTcpProxy().call(getMyClientName(), "dac,3000,0000,0000,0000");
//        //tcpProxy.writeSDO(dac.getNodeID(), "6411", "01", "2", "3000");
//        dac.writeAnalogOutput(1, 14000);
//    }
    
    public String turnOnLED() throws SDORequestException, HardwareNotDetectedException {
        return led.turnON();
    }
    

    
    public String turnOffLED() throws SDORequestException, HardwareNotDetectedException {
        return led.turnOFF();       
    }
    
    public String turnOnFakeLED() throws SDORequestException, HardwareNotDetectedException {
        return fakeLed.turnON();       
    }
    
    public String turnOffFakeLED() throws SDORequestException, HardwareNotDetectedException {
        return fakeLed.turnOFF();       
    }
    
    public double readFakeSensor() throws HardwareException, BadCommandException {
        PDOStorage pdoStore = this.bridge.readPDOs();
        return this.fakeSensor.readTemperatureWithPDO(pdoStore);
    }
    
    @Override
    public void initModule() {
        String channelName = "temperature";
        String tempLow = String.valueOf(20.0);
        String tempHigh = String.valueOf(25.0);
        this.getSubsystem().publishMetaData(channelName, "tempLow", tempLow);
        this.getSubsystem().publishMetaData(channelName, "tempHigh", tempHigh);
        
        this.getSubsystem().publishMetaData("fakeTemperature", "fakeTempLow", tempLow);
        this.getSubsystem().publishMetaData("fakeTemperature", "fakeTempHigh", tempHigh);
        this.getSubsystem().publishMetaData("bidon", "ici", "maintenant");
    }
    
    @Override
    public void tick() {
//        try {
//            
//            this.temperature = readTemperatureFromPDO();
//            log.debug("TEMPERATURE=" + this.temperature);
////            Status statusData = new StatusDataPublishedByAPCTestBench(temperature);
////            this.sendToStatus(statusData);
//            getSubsystem().publishData("temperature", this.temperature);
//            double fakeTemperature = readFakeSensor();
//            getSubsystem().publishData("fakeTemperature", fakeTemperature);
//            getSubsystem().publishData("bidon", "coucou");
//            
//            
//            
//        } catch (HardwareException ex) {
//            log.error("ERROR in reading temperature" + ex.getMessage());
//        } catch (BadCommandException ex) {
//            log.error("ERROR in reading temperature" + ex.getMessage());
//        }
    }

    
}
