/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;

/**
 * Thois soft is to test the FCS with 2 CAN BUS :
 * - one for the carousel and the autochanger
 * - one for the loader
 * @author virieux
 */
public class APCTestBench2CanBusMain extends MainModule {
    
    
     /**
     * this bridge is to communicate with the canbus1 on the PC104
     */
    protected BridgeToHardware bridgeToLoader;
    
        /*** The thermometer mesures the temperature inside the clamp.
    */
    private Thermometer thermometer;
    private CanOpenLED led;
    private CanOpenLED fakeLed;
    private Thermometer fakeSensor;
    
    public double temperature;
    
    

    public APCTestBench2CanBusMain(String aName, int aTickMillis, BridgeToHardware bridge, BridgeToHardware bridgeToLoader) {
        super(aName, aTickMillis, bridge);
        this.bridgeToLoader = bridgeToLoader;
    }

    public APCTestBench2CanBusMain(String aName, int aTickMillis, 
            BridgeToHardware bridge, 
            BridgeToHardware bridgeToLoader, 
            Thermometer thermometer, 
            CanOpenLED led, 
            CanOpenLED fakeLed, 
            Thermometer fakeSensor) {
        super(aName, aTickMillis, bridge);
        this.bridgeToLoader = bridgeToLoader;
        this.thermometer = thermometer;
        this.led = led;
        this.fakeLed = fakeLed;
        this.fakeSensor = fakeSensor;
    }
       
    public boolean isChangerConnected() {
        return this.bridge.isCWrapperConnected();
    }
    
    public boolean isLoaderConnected() {
        return this.bridgeToLoader.isCWrapperConnected();
    }
    
    public boolean isChangerReady() {
        return this.bridge.isHardwareReady();
    }
    
    public boolean isLoaderReady() {
        return this.bridgeToLoader.isHardwareReady();
    }
    
    public void disconnectLoader() throws InterruptedException {
        this.bridgeToLoader.getTcpProxy().disconnectHardware();
    }
    
    public void connectLoader() throws BadCommandException {
        this.bridgeToLoader.startServer();
        this.bridgeToLoader.startThreadReader();
    }
    
    
    
}
