package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.subsystems.fcs.common.Motor;
import org.lsst.ccs.subsystems.fcs.common.EngineState;
import org.lsst.ccs.subsystems.fcs.common.RunningWay;
/**
 * This is the concrete state where we know what to be done when the engine is
 * in the state "Stop".
 * Not used for single-filter-test test bench.
 * This is old stuff when I tried to implement State pattern.
 * Not sure I will continue to use that in the next version of FCS.
 * 
 * @author virieux
 * 
 */
@Deprecated
public class StopState implements EngineState {
	
	protected final static Logger log = Logger.getLogger("org.lsst.ccs.subsystems.fcs.simulation");

	
	public double computeDisplacement(Motor engine, double period,
			RunningWay runningWay) {
		return 0;
	}

	public String error(Motor motor) {
		motor.setEngineState(ERROR);
		return motor.getName() + ": going in state " + this.toString();

	}

	
	public String go(Motor motor, double period, RunningWay runningWay) {
		motor.setStateChangeTime(System.currentTimeMillis());
		motor.setPeriod(period);		
		motor.setEngineState(RUNNING);
		String message = motor.getName() + ": starting...";
		log.info(message);
		return message;

	}

	public String stop(Motor motor) {
		return motor.getName() + ": is already stopped [StopState]";

	}

	@Override
	public String toString() {
		return "stop";
	}

}
