/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.simulation;

import java.math.BigDecimal;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.subsystems.fcs.Sensor14bits;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy.PDOStorage;


/**
 * This class is to simulate a sensor which returns a value coded on 12bits.
 * It returns a random value between value1 and value2.
 * 
 * @author virieux
 */
public class SimuSensor14bits extends Sensor14bits {

    int value1 = Sensor14bits.minValue;
    int value2 = Sensor14bits.maxValue;
    Random randomGenerator = new Random();

    public SimuSensor14bits(String moduleName, int aTickMillis, int aValue) {
        super(moduleName, aTickMillis);
        this.value = aValue;
    }
    

    
    /**
     * Constructeur for a simulated sensor
     * TODO: the values cannot be greater than maxValue
     * @param aValue1
     * @param aValue2 
     */
    SimuSensor14bits(String moduleName, int aTickMillis, int aValue1, int aValue2) {
        super(moduleName, aTickMillis);
        this.value1 = aValue1;
        this.value2 = aValue2;
    }
    
    
    void setNewRange(int aValue1, int aValue2) {
        if ((aValue2 < aValue1) || (aValue2 > Sensor14bits.maxValue)) {
            String message = String.format("we must have : value1 < value2 < maxValue / value1= %s, value2=%s, maxValue=%s",value1,value2,Sensor14bits.maxValue);
            throw new IllegalArgumentException(message);
        }
        this.value1 = aValue1;
        this.value2 = aValue2;
    }

    /**
     * 
     * @return a random between value1 and value2
     */
    @Override
    public int readNewValue() {
        if (value2 > 0) {
            int n = randomGenerator.nextInt(value2);  

            if (n > value1) {
                return n;
            } else {
                BigDecimal bd = new BigDecimal(value1 + n * (value2 - value1)/value2);           
                return bd.intValue();
            }
        } else {
            String msg = getName() + ": ERROR in readNewValue: value2 should be positive";
            throw new IllegalArgumentException(msg);
        }

    }

    /**
     * We don't need this as the simulated software doesn't read sensors from PDO
     * @param pdoStorage
     * @return 
     */
    @Override
    public int updateValue(PDOStorage pdoStorage) {
        throw new UnsupportedOperationException("Not supported yet.");
    }


}
