/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.subsystems.fcs.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

/**
 * This class simulates the Can Open PLuto Gateway we use to communicate with the
 * sensors in the whole size prototype.
 * @author virieux
 */
public class SimuPlutoGateway extends PlutoGatewayModule  {
    
    
    SimuPlutoGWSensor lockSensor1;
    SimuPlutoGWSensor unlockSensor1;
    SimuPlutoGWSensor lockSensor2;
    SimuPlutoGWSensor unlockSensor2;
    SimuPlutoGWSensor lockSensor3;
    SimuPlutoGWSensor unlockSensor3;
    SimuPlutoGWSensor lockSensor4;
    SimuPlutoGWSensor unlockSensor4;

    public SimuPlutoGateway(String string, int i) {
        super(string, i);
    }

   
    @Override
    public void initModule() {
        super.initModule();
        this.hexaValues[0] = "78";
        this.hexaValues[1] = "00";
        this.lockSensor1 = (SimuPlutoGWSensor) getModule("lockSensor1");
        this.lockSensor2 = (SimuPlutoGWSensor) getModule("lockSensor2");
        this.lockSensor3 = (SimuPlutoGWSensor) getModule("lockSensor3");
        this.lockSensor4 = (SimuPlutoGWSensor) getModule("lockSensor4");
        this.unlockSensor1 = (SimuPlutoGWSensor) getModule("unlockSensor1");
        this.unlockSensor2 = (SimuPlutoGWSensor) getModule("unlockSensor2");
        this.unlockSensor3 = (SimuPlutoGWSensor) getModule("unlockSensor3");
        this.unlockSensor4 = (SimuPlutoGWSensor) getModule("unlockSensor4");
        simulateLoaderClampIsUnLocked();
    }
    
    /* 
     * @return simulated values in hexa 
     */   
    @Override
    public String[] readNewHexaValues() {
            return hexaValues;
    }

    public void simulateLoaderClampIsLocked() {
        simulateHookIsLocked(lockSensor1, unlockSensor1);
        simulateHookIsLocked(lockSensor2, unlockSensor2);
        simulateHookIsLocked(lockSensor3, unlockSensor3);
        simulateHookIsLocked(lockSensor4, unlockSensor4);
        
    }
    
    
    public void simulateLoaderClampIsUnLocked() {
        //simulateHookIsUnlocked(lockSensor1, lockSensor1);
        simulateHookIsUnlocked(lockSensor1, unlockSensor1);
        simulateHookIsUnlocked(lockSensor2, unlockSensor2);
        simulateHookIsUnlocked(lockSensor3, unlockSensor3);
        simulateHookIsUnlocked(lockSensor4, unlockSensor4);
        
    }
    
    public void simulateHookIsLocked(SimuPlutoGWSensor lockSensor, SimuPlutoGWSensor unlockSensor) {
        replaceDigitalValues(lockSensor,"1");
        replaceDigitalValues(unlockSensor,"0");
        
    }

    public void simulateHookIsUnlocked(SimuPlutoGWSensor lockSensor, SimuPlutoGWSensor unlockSensor) {
        replaceDigitalValues(lockSensor,"0");
        replaceDigitalValues(unlockSensor,"1");
    }
    
    void simulateLoaderClampIsLockedStrongly() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
    
    /**
     * Set the digital value for a sensor. 
     * @param sensor
     * @param digitalValue 
     */
    public void replaceDigitalValues(SimuPlutoGWSensor sensor, String digitalValue) {
        
       lock.lock();       
            
       try {
            updatingValues = true;
            //this.hexaValues = readNewHexaValues();
            int byteNo = sensor.getByteNumero() - 1;
            log.debug(getName() + "=> old hexa value = " + this.hexaValues[byteNo]);
            StringBuilder bin = new StringBuilder(FcsUtils.hexToBinary(this.hexaValues[byteNo]));
            bin.replace(8 - sensor.getInputNumero(), 8 - sensor.getInputNumero() + 1, digitalValue);
            String newDIOHexaValue = Integer.toHexString(Integer.parseInt(bin.toString(), 2));
            log.debug(getName() + "=> new hexa value ="  + newDIOHexaValue);
            this.hexaValues[byteNo] = newDIOHexaValue;
            log.debug(getName() + " HEXA VALUE READ: hexaValues[0]=" + this.hexaValues[0]
                + " hexaValues[1]=" + this.hexaValues[1]);
            

       } finally {
           
           updatingValues = false;
           valueUpdated.signal();
           lock.unlock();
           
       }
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/byte no1=");sb.append(this.hexaValues[0]);
        sb.append("/byte no2=");sb.append(this.hexaValues[1]);
        return sb.toString();
    }



}
