/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.CurrentCommandContext;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.LoaderClampModule;
import org.lsst.ccs.subsystems.fcs.LoaderHookModule;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;

/**
 * This is a simulated Loader Clamp Module.
 * Because the stopAction commands has to interrupt the running command.
 * @author virieux
 */
public class SimuLoaderClampModule extends LoaderClampModule {

//    public SimuLoaderClampModule(String moduleName, int aTickMillis, long timeoutForClosingHooks, long timeoutForClosingHooksStrongly, long timeoutForOpeningHooks, long timeoutForGoingToHomePosition, int minPosition, int maxPosition, int targetPositionToOpen, int targetPositionToClose, int targetPositionToCloseStrongly, int currentToClose, int currentToGoHome, Map<String, Integer> paramsForCurrentToClose, Map<String, Integer> paramsForCurrentToGoHomePosition, LoaderHookModule hook1, LoaderHookModule hook2, LoaderHookModule hook3, LoaderHookModule hook4, String plutoGWName) {
//        super(moduleName, aTickMillis, timeoutForClosingHooks, timeoutForClosingHooksStrongly, timeoutForOpeningHooks, timeoutForGoingToHomePosition, minPosition, maxPosition, targetPositionToOpen, targetPositionToClose, targetPositionToCloseStrongly, currentToClose, currentToGoHome, paramsForCurrentToClose, paramsForCurrentToGoHomePosition, hook1, hook2, hook3, hook4, plutoGWName);
//    }
    public SimuLoaderClampModule(String moduleName, int aTickMillis, LoaderHookModule hook1, LoaderHookModule hook2, LoaderHookModule hook3, LoaderHookModule hook4, String plutoGWName, long timeoutForClosingHooks, long timeoutForClosingHooksStrongly, long timeoutForOpeningHooks, long timeoutForGoingToHomePosition, int targetPositionToOpen, int targetPositionToClose, int targetPositionToCloseStrongly, int currentToClose, int currentToGoHome, Map<String, Integer> paramsForCurrentToClose, Map<String, Integer> paramsForCurrentToGoHomePosition, int minPosition, int maxPosition) {       
        super(moduleName, aTickMillis, hook1, hook2, hook3, hook4, plutoGWName, timeoutForClosingHooks, timeoutForClosingHooksStrongly, timeoutForOpeningHooks, timeoutForGoingToHomePosition, targetPositionToOpen, targetPositionToClose, targetPositionToCloseStrongly, currentToClose, currentToGoHome, paramsForCurrentToClose, paramsForCurrentToGoHomePosition, minPosition, maxPosition);
    }
    
    
    
    //for the simulation 
    public void test() {       
        CurrentCommandContext currentCmdContext = Subsystem.LOCAL_EXECUTION_INFO.get();
        log.debug("Command running:" + currentCmdContext.getCommandName() );
        log.info("coming from:" + currentCmdContext.getCommandOriginator());
        this.getSubsystem().interruptActionThread();
    }
    
    @Override
    public void stopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        super.stopAction(action, delay);
        this.getSubsystem().interruptActionThread();
    }
    
    
    

    
}
