/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.LatchActuatorModule;

/**
 *
 * @author virieux
 */
public class SimuLatchActuatorModule extends LatchActuatorModule {
    
    SimuCompactIOModule simuDIO;
    
    //for initModule
    String filterSensorsDIOName;

    public SimuLatchActuatorModule(String aName, int aTickMillis, 
            double currentLimitInVolt, 
            double speedVoltageInVolt, 
            int speedVoltageMinValue, 
            int speedVoltageMaxValue,
            String filterSensorsDIOName) {
        super(aName, aTickMillis, currentLimitInVolt, speedVoltageInVolt, speedVoltageMinValue, speedVoltageMaxValue);
        this.filterSensorsDIOName = filterSensorsDIOName;
    }

       
    
    @Override
    public void initModule() {
        this.simuDIO = (SimuCompactIOModule) this.getModule(filterSensorsDIOName);
    }

    /**
     * For the simulated Latch Actuator the command open has to update the value of the lock and unlock 
     * sensors on the same side of the filter (Xminus or Xplus).
     * @return
     * @throws BadCommandException
     * @throws ErrorInCommandExecutionException 
     */
    @Override
    public String open() throws BadCommandException, ErrorInCommandExecutionException {

        int lockSensorInputNumero;
        int unlockSensorInputNumero;
        if (getName().endsWith("Xminus")) {
            lockSensorInputNumero = ((SimuNumericSensor) this.getModule("lockSensorLatchXminus")).getInputNumero();
            unlockSensorInputNumero = ((SimuNumericSensor) this.getModule("unlockSensorLatchXminus")).getInputNumero();
        } else if (getName().endsWith("Xplus")) {
            lockSensorInputNumero = ((SimuNumericSensor) this.getModule("lockSensorLatchXplus")).getInputNumero();
            unlockSensorInputNumero = ((SimuNumericSensor) this.getModule("unlockSensorLatchXplus")).getInputNumero();
        } else throw new ErrorInCommandExecutionException(getName() + " Can't retrieve the latch for which I work.");
        
        //For the simulated Actuator, the command open updates the value of the lock and unlock sensors.
        simuDIO.replaceDigitalValues(lockSensorInputNumero, "0", unlockSensorInputNumero, "1");
        log.debug(getName() + " is OPEN");
        return getName() + " is OPEN";
    }
    
    /**
     * For the simulated latch actuator, the command close has just to update the values of the 
     * lock and unlock simulated sensors.
     * @return
     * @throws BadCommandException
     * @throws ErrorInCommandExecutionException 
     */
    @Override
    public String close() throws BadCommandException, ErrorInCommandExecutionException {

        int lockSensorInputNumero;
        int unlockSensorInputNumero;
        if (getName().endsWith("Xminus")) {
            lockSensorInputNumero = ((SimuNumericSensor) this.getModule("lockSensorLatchXminus")).getInputNumero();
            unlockSensorInputNumero = ((SimuNumericSensor) this.getModule("unlockSensorLatchXminus")).getInputNumero();
        } else if (getName().endsWith("Xplus")) {
            lockSensorInputNumero = ((SimuNumericSensor) this.getModule("lockSensorLatchXplus")).getInputNumero();
            unlockSensorInputNumero = ((SimuNumericSensor) this.getModule("unlockSensorLatchXplus")).getInputNumero();
        } else throw new ErrorInCommandExecutionException(getName() + " Can't retrieve the latch for which I work.");
        
        //For the simulated Actuator, the command close updates the value of the lock and unlock sensors.
        simuDIO.replaceDigitalValues(lockSensorInputNumero, "1", unlockSensorInputNumero, "0");
        return getName() + " is CLOSED";
    }
    

    @Override
    public String powerOff() throws BadCommandException, ErrorInCommandExecutionException {
        return getName() + " is OFF";
    }
    
}
