/*
 * To change this template, choose Tools | Templates
 * and on the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Random;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.bus.KVList;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClampActuator;
import org.lsst.ccs.subsystems.fcs.common.Actuator;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

/**
 *
 * @author virieux
 */
//public class SimuClampActuatorModule extends ClampActuatorModule {
public class SimuClampActuatorModule extends Module implements Actuator {
    
    public boolean on;
    public int readValue;
    public int sentValue;
    public int sentCurrentMinValue;
    public int sentCurrentMaxValue;

    Random r = new Random();
    
    CarouselModule carousel;


    
    @Override
    public boolean isOn() {
        return on;
    }

    @Override
    public boolean isOff() {
        return !on;
    }

    @Override
    public int getReadValue() {
        return readValue;
    }

    @Override
    public int getSentCurrentMinValue() {
        return sentCurrentMinValue;
    }

    @Override
    public int getSentCurrentMaxValue() {
        return sentCurrentMaxValue;
    }
    
    

    @Override
    public void initModule() {
        this.on = false;
        this.carousel = (CarouselModule) this.getModule("carousel");
    }

    @Override
    public String on() throws BadCommandException, ErrorInCommandExecutionException {
        on = true;
        
        log.debug(getName() + "==========> ACTUATOR ON");

        //the clamp is now UNLOCKED : we have to simulate that.
        SimuFilterClampModule clamp;
        if (getName().contains("Xminus")) {
            clamp = (SimuFilterClampModule) this.carousel.getClampXminus();            
        } else if (getName().contains("Xplus")){
            clamp = (SimuFilterClampModule) this.carousel.getClampXplus();
        } else throw new ErrorInCommandExecutionException(getName() + ": unable to find the clamp to unlock.");
        ((SimuClampLockSensor) clamp.getLockSensor()).simulateClampIsUNLOCKED(clamp);
        
        //we have to publish on status bus the sentValue (for the GUI)
        this.sentValue = 500;
        //this.sendToStatus(this.getStatusData());
        //this.publishActuatorData();
        this.publishData();
        
        return getName() + " is turned ON.";
    }

    @Override
    public String off() throws BadCommandException, ErrorInCommandExecutionException {
        on = false;
        log.debug(getName() + "==========> ACTUATOR OFF");
        //the clamp is now LOCKED : we have to simulate that.
        SimuFilterClampModule clamp;
        if (getName().contains("Xminus")) {
            clamp = (SimuFilterClampModule) this.carousel.getClampXminus();            
        } else if (getName().contains("Xplus")){
            clamp = (SimuFilterClampModule) this.carousel.getClampXplus();
        } else throw new ErrorInCommandExecutionException(getName() + ": unable to find the clamp to unlock.");
        ((SimuClampLockSensor) clamp.getLockSensor()).simulateClampIsLOCKED(clamp);

        this.sentValue = 0;
        //this.sendToStatus(this.getStatusData());
        //this.publishActuatorData();
        this.publishData();
        return getName() + " is turned OFF.";
    }

    public int getSentValue() {
//        if (isOn()) {
            if (this.sentCurrentMinValue >= 0) {
                
                if (this.sentCurrentMaxValue > 0) {
                    return r.nextInt(this.sentCurrentMaxValue);
                } else {
                    String msg = getName() + ": ERROR in getSentValue: getSentCurrentMaxValue() should be positive";
                    throw new IllegalArgumentException(msg);
                }
            }
            return (int) (r.nextGaussian()) * this.sentCurrentMaxValue / 2;
//        }
//        return 0;
    }

    @Override
    public void tick() {
        //this.publishActuatorData();
    }

    public String maintainUnclamped() throws BadCommandException, ErrorInCommandExecutionException {
        return getName() + "Maintaining Current";
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(getName());
        if (isOn()) {
            sb.append(" is ON");
        } else {
            sb.append(" is OFF");
        }
        return sb.toString();
    }
    
    public StatusDataPublishedByClampActuator getStatusData() {
        return FcsUtils.createStatusDataPublishedByClampActuator(this);
    }
    
        /**
     * Publish Data on status bus for trending data base and GUIs.
     * If a key is changed here, it has to be changed also in the GUIs (FilterExchangeMainPanel)
     */
    @Deprecated // because GUIs implement DataStatusPersister
    public void publishActuatorData() {
        KVList kvlist = new KVList(7);
        long timestamp = System.currentTimeMillis();
        kvlist.add("dataType", "carouselClampActuator");
        kvlist.add(getName() + "/sentValue", this.sentValue);
        publish(timestamp,kvlist);
        
    }
    
     /**
     * Publish Data on status bus for trending data base and GUIs.
     * 
     */
     public void publishData() {
        StatusDataPublishedByClampActuator status = this.getStatusData(); 
        this.publish("actuator", status);
     }







}
