/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;

/**
 *
 * @author virieux
 */
public class SimuBridgeForLPSCTestBench extends Module implements BridgeToHardware {
    
    public SimuEPOSControllerModule hooksController;
    public SimuEPOSControllerModule carrierController;

    public SimuBridgeForLPSCTestBench(String name, int tickmillis, 
            SimuEPOSControllerModule hookController, 
            SimuEPOSControllerModule carrierController) {
        super(name, tickmillis);
        this.hooksController = hookController;
        this.carrierController = carrierController;
    }
    
    
    @Command(type=Command.CommandType.QUERY, level=Command.ENGINEERING1, description="print my children; for tests")
    public void printChildren() {
        Map<String,SimuEPOSControllerModule> children = this.getChildren(org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSControllerModule.class);
        for(Map.Entry<String,SimuEPOSControllerModule> entry : children.entrySet()) {
            String key = entry.getKey();
            log.debug("key=" + key);
            SimuEPOSControllerModule epos = entry.getValue();
            log.debug("epos=" + epos.getName() + "#" + epos.toString());
            
        }
    }
    
    @Command(type=Command.CommandType.QUERY, level=Command.ENGINEERING1, description="print my children; for tests")
    public void printChildren2() {
        Map<String,EPOSController> children = this.getChildren(org.lsst.ccs.subsystems.fcs.common.EPOSController.class);
        for(Map.Entry<String,EPOSController> entry : children.entrySet()) {
            String key = entry.getKey();
            log.debug("key=" + key);
            EPOSController epos = entry.getValue();
            log.debug("epos=" + epos.getName() + "#" + epos.toString());
            
        }
    }
    
    

    @Override
    public boolean isCWrapperConnected() {
        return true;
    }

    @Override
    public boolean isHardwareReady() {
        return true;
    }
    
    @Override
    public boolean isRealHardware() {
        return false;
    }

    @Override
    public CanOpenProxy getTcpProxy() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    //to be complient with the real hardware bridge 
    public void startThreadReader() {
    }

    @Override
    public CanOpenProxy.PDOStorage readPDOs() throws HardwareException, BadCommandException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void startServer() {
    }


    
}
