/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.drivers;

/**
 * The tcp server for the loader when we want to connect or disconnect loader hardware.
 * So this tcp proxy won't start during initialisation phase.
 * @author virieux
 */
public class LoaderCanOpenProxy extends CanOpenProxy {

    public LoaderCanOpenProxy(String aName, int aTickMillis, int portNumber, String aClientName, int expectedNodesNB, long hardwareBootTimeout) {
        super(aName, aTickMillis, portNumber, aClientName, expectedNodesNB, hardwareBootTimeout);
    }
    
    /**
     * We don't want the tcp server to be started during INITIALISATION phase.
     */
    @Override
    public void start() {
    }
    
     /**
     * This methods stops the CWrapper client, and the TCP server.
     */
    @Override
    public void disconnectHardware() {
            this.stopServer();
    }

    @Override
    public void connectHardware() {
        this.startServer();
        this.startThreadReader();
    }
    
}
