/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.framework.annotations.ConfigChanger;

/**
 * This is a model for the numeric sensors we have to monitor the latches in the autochanger,
 * the autochanger trucks position in single-filter-test and the loader hooks.
 * 
 * 
 * This sensor is used to monitor the latches in the autochanger 
 * of the single-filter-test.
 * 
 * This is also used in the loader test bench where the sensors are connected to a 
 * Pluto PLC for the camera protection system.
 * We read the sensors through a Gateway (CanOpenPlutoGateway) byte by byte.
 * So we need to know on which byte this sensor is coded.
 * 
 * @author virieux
 */
public class CanOpenNumericSensor extends NumericSensor {
    
     /**
     * This is the name of the DIO in the groovy file.
     * Used in the toString method, just for tracing purpose when the subsystem starts 
     * from groovy configuration.
     * 
     */
    String dioName;
    
    /**
     * Numero of input chanel on the device where this sensor is plugged.
     */
    int inputNumero;
    
     /**
     * Gateway byte number where the sensor is coded.
     * value = 1 or 2 in january 2014
     */
    int byteNumero;

    public CanOpenNumericSensor(String aName, String dioName, int inputNumero) {
        super(aName);
        this.dioName = dioName;
        this.inputNumero = inputNumero;
    }

    public CanOpenNumericSensor(String aName, String dioName, int inputNumero, int byteNumero) {
        super(aName);
        this.dioName = dioName;
        this.inputNumero = inputNumero;
        this.byteNumero = byteNumero;
    }
    
    
    
   

    public int getInputNumero() {
        return inputNumero;
    }

    @ConfigChanger
    public void setInputNumero(int inputNumero) {
        this.inputNumero = inputNumero;
    }
    

    /**
     * This methods updates the digital value for this sensor.
     * It takes as an argument the value in hexa sent by the CompactIOModule.
     * This hexa value represents the 8 values for the 8 channels.
     * To retrieve the value for this sensor, the hexa value is transformed in binary, 
     * then reverse and the digital value is the digit at the index= inputNumero.
     * exmaple if hex = 80, and inputNumero=8, digital value=1 otherwise digital value=0.
     * @param hex 
     */
    @Override
    public synchronized void updateValue(String hex) {
        //log.debug(Thread.currentThread().toString());
        //log.debug(getName() + " INPUT NO=" + inputNumero);
        
        String bin = Integer.toBinaryString(Integer.parseInt(hex, 16));
        
        //to add leading zeros on the left
        String s = String.format("%08d", Integer.parseInt(bin));
        //log.debug("binary value=" + s);
        
        //to retrieve the digital value for this sensor
        //(the digits are given from left to right
        //1010000 => DIO[8]=1,DIO[7]=0,DIO[6]=1,DIO[5]=0,DIO[4]=0,DIO[3]=0,DIO[2]=0,DIO[1]=0
        int myValue = Character.digit(s.charAt(8-inputNumero), 16);
        //log.debug(getName() + " Value updated=" + myValue);

        this.digitalValue = myValue;
    }
    
     /**
     * Update the field digitalValue from the bytes read on the gateway.
     * @param hexaValues 
     */
    @Override
    public synchronized void updateValue(String[] hexaValues) {
        this.updateValue(hexaValues[byteNumero - 1]);        
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(getName());
        sb.append("/DIO module=");sb.append(this.dioName);
        sb.append("/Input numero=");sb.append(String.valueOf(this.inputNumero));
        sb.append("/byteNumero=");sb.append(String.valueOf(this.byteNumero));
        return sb.toString();
    }



//     /**
//     * @param args the command line arguments
//     */
//    public static void main(String[] args) {
//

//        CanOpenNumericSensor sensor1 = new CanOpenNumericSensor("sensor1", "GW", 1);
//        sensor1.updateValue("79");
//        System.out.println("valeur de sensor1=" + sensor1.digitalValue);
//        
//        CanOpenNumericSensor sensor2 = new CanOpenNumericSensor("sensor2", "GW", 2);
//        sensor2.updateValue("79");
//        System.out.println("valeur de sensor2=" + sensor2.digitalValue);
//        
//        CanOpenNumericSensor sensor3 = new CanOpenNumericSensor("sensor3", "GW", 3);
//        sensor3.updateValue("79");
//        System.out.println("valeur de sensor3=" + sensor3.digitalValue);
//        
//        CanOpenNumericSensor sensor4 = new CanOpenNumericSensor("sensor4", "GW", 4);
//        sensor4.updateValue("79");
//        System.out.println("valeur de sensor4=" + sensor4.digitalValue);
//        
//        CanOpenNumericSensor sensor5 = new CanOpenNumericSensor("sensor5", "GW", 5);
//        sensor5.updateValue("79");
//        System.out.println("valeur de sensor5=" + sensor5.digitalValue);
//        
//        CanOpenNumericSensor sensor6 = new CanOpenNumericSensor("sensor6", "GW", 6);
//        sensor6.updateValue("79");
//        System.out.println("valeur de sensor6=" + sensor6.digitalValue);
//        
//        CanOpenNumericSensor sensor7 = new CanOpenNumericSensor("sensor7", "GW", 7);
//        sensor7.updateValue("79");
//        System.out.println("valeur de sensor7=" + sensor7.digitalValue);
//        
//        CanOpenNumericSensor sensor8 = new CanOpenNumericSensor("sensor8", "GW", 8);
//        sensor8.updateValue("79");
//        System.out.println("valeur de sensor8=" + sensor8.digitalValue);
//        
//        String hex = "79";
//        String bin = Integer.toBinaryString(Integer.parseInt(hex, 16));
//        System.out.println(bin);
//        //to add leading zeros on the left
//        String s = String.format("%08d", Integer.parseInt(bin));
//        System.out.println("s=" + s);
//
//     
//    }



    
    
    
}
