/*
 * To change this template, choose Tools | Templates
 * and on the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.subsystems.fcs.LatchActuatorModule;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;


/**
 * This is a model for a motor which locks or unlocks a latch.
 * The motor is driven by a CAN-CBX-AO412.
 * We sent to the CAN-CBX-AO412 a current value.
 * @author virieux
 */
public class CanOpenLatchActuatorModule extends LatchActuatorModule {
    
    
     /**
     * The DAC which controls the motor.
     */
    CanOpenDAC dac;
    
     /**
     * This is the name of the DAC on which the actuator is plugged.
     * Used in the groovy file and in initModule.
     * 
     */
    String dacName;
    
    /**
     * The numero of analog output where we send the value of the current to the motor.
     * (variable)
     */
    int numOfAnalogOutputForSpeedVoltage;
    
     /**
     * The numero of analog output where we send the value of the current limit to the motor.
     * current limit (fixed)
     */
    int numOfAnalogOutputForCurrentLimit;

    public CanOpenLatchActuatorModule(String aName, int aTickMillis, 
            double currentLimitInVolt, 
            double speedVoltageInVolt, 
            int speedVoltageMinValue, 
            int speedVoltageMaxValue, 
            String dacName, 
            int numOfAnalogOutputForSpeedVoltage, 
            int numOfAnalogOutputForCurrentLimit) {
        super(aName, aTickMillis, currentLimitInVolt, speedVoltageInVolt, speedVoltageMinValue, speedVoltageMaxValue);
        this.dacName = dacName;
        this.numOfAnalogOutputForSpeedVoltage = numOfAnalogOutputForSpeedVoltage;
        this.numOfAnalogOutputForCurrentLimit = numOfAnalogOutputForCurrentLimit;
    }

    public void setNumOfAnalogOutputForSpeedVoltage(int numOfAnalogOutputForSpeedVoltage) {
        this.numOfAnalogOutputForSpeedVoltage = numOfAnalogOutputForSpeedVoltage;
    }

    public void setNumOfAnalogOutputForCurrentLimit(int numOfAnalogOutputForCurrentLimit) {
        this.numOfAnalogOutputForCurrentLimit = numOfAnalogOutputForCurrentLimit;
    }
    
    public void initModule() {
        this.dac = (CanOpenDAC) this.getModule(dacName);
    }
    
    @Override
    public String open() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        
        
//        try {
            //set the current limit
            int currentLimitInDecimal = (int) (this.currentLimitInVolt * CanOpenDAC.bitOverVolts);           
            dac.writeAnalogOutput(this.numOfAnalogOutputForCurrentLimit, currentLimitInDecimal);
            //start the motor
            int speedVoltageInDecimal = (int) (this.speedVoltageInVolt * CanOpenDAC.bitOverVolts);
            dac.writeAnalogOutput(this.numOfAnalogOutputForSpeedVoltage, speedVoltageInDecimal);
            //this.setOn(true);
//        } catch (HardwareNotDetectedException ex) {
//            String message = getName() + " CANNOT BE TURNED ON";
//            log.error(message);
//            //this.getSubsystem().updateState(State.InError, ex.getMessage() + message);
//            return message;
//        } catch (SDORequestError ex) {
//            String message = getName() + " CANNOT BE TURNED ON";
//            log.error(message);
//            //this.getSubsystem().updateState(State.InError, message );
//            return message;
//        }
        return getName() + " is OPEN";
    }
    
    
    @Override
    public String close() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        
//        try {        
            //set the current limit
            int currentLimitInDecimal = (int) (this.getCurrentLimitInVolt() * CanOpenDAC.bitOverVolts);
            dac.writeAnalogOutput(this.numOfAnalogOutputForCurrentLimit, currentLimitInDecimal);
            //start the motor
            int speedVoltageInDecimal = (int) (this.getSpeedVoltageInVolt() * CanOpenDAC.bitOverVolts);
            dac.writeAnalogOutput(this.numOfAnalogOutputForSpeedVoltage, -speedVoltageInDecimal);
            //this.setOn(false);
//        } catch (HardwareNotDetectedException ex) {
//            String message = getName() + " CANNOT BE TURNED OFF";
//            log.error(message);
//            //this.getSubsystem().updateState(State.InError, ex.getMessage() + message);
//            return message;
//        } catch (SDORequestError ex) {
//            String message = getName() + " CANNOT BE TURNED OFF";
//            log.error(message);
//            //this.getSubsystem().updateState(State.InError, message );
//            return message;
//        }
        return getName() + " is CLOSED";
    }

    @Override
    public String powerOff() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
//        try {
            dac.writeAnalogOutput(this.numOfAnalogOutputForCurrentLimit, 0);
            dac.writeAnalogOutput(this.numOfAnalogOutputForSpeedVoltage, 0);
            return getName() + " is POWER OFF";
//        } catch (SDORequestError ex) {
//            String message = getName() + " CANNOT BE POWERED OFF";
//            log.error(message);
//            //this.getSubsystem().updateState(State.InError, message );
//            return message;
//        } catch (HardwareNotDetectedException ex) {
//            String message = getName() + " CANNOT BE POWERED OFF";
//            log.error(message);
//            //this.getSubsystem().updateState(State.InError, ex.getMessage() + message);
//            return message;
//        }
    }

    
}
