/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.subsystems.fcs.common.HygrometryGauge;
import org.lsst.ccs.subsystems.fcs.common.PressureGauge;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

/**
 * A hygrometry, pressure and temperature gauge used for the test bench at LPC in Clermont-Ferrand.
 * @author virieux
 */
public class CanOpenGaugeHD2001 extends CanOpenSensor14bits implements Thermometer, PressureGauge, HygrometryGauge {
    
    private final int offsetTemp;
    private final int offsetPressure;

    public CanOpenGaugeHD2001(String moduleName, int aTickMillis, String adcName, int numOfAnalogInput) {
        super(moduleName, aTickMillis, adcName, numOfAnalogInput);
        this.offsetTemp = -20;
        this.offsetPressure = 600;
    }
    
    /**
     * Read the temparature and returns the new value in degree celcius.
     * @return
     * @throws SDORequestException
     * @throws HardwareNotDetectedException 
     */
    @Override
    public double readTemperature() throws SDORequestException, HardwareNotDetectedException {

        double voltage = adc.readVoltage(numOfAnalogInput);
        return (voltage / 100) + this.offsetTemp;
    }

    @Override
    public double readTemperatureWithPDO(CanOpenProxy.PDOStorage pdo) throws BadCommandException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    /**
     * Read the pressure sensors and returns the new value in mbar 
     * @return pressure in mbar
     * @throws HardwareException 
     */
    @Override
    public double readPressure() throws HardwareException {
        double voltage = adc.readVoltage(numOfAnalogInput);
        return (voltage / 500) + 600;
    }

    /**
     * Read the hygrometry with the sensor and returns the new value in %RH
     * @return
     * @throws HardwareException 
     */
    @Override
    public double readHygrometry() throws HardwareException {
        double voltage = adc.readVoltage(numOfAnalogInput);
        return (voltage / 100);
    }
    
}
