/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.common;

import java.util.Map;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS.EposMode;
import org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

/**
 *
 * @author virieux
 */
public interface EPOSController extends Actuator {

    /**
     * This methods changes the mode to the new mode given as an argument.
     * It writes the new mode in the CPU of the EPOS controller and updates the field mode.
     * @param newMode
     * @return
     * @throws SDORequestException
     */
    String changeMode(EposMode newMode) throws SDORequestException;

    /**
     * This methods read the parameters of the motor stored in the actuator
     * (hardware configuration)and compare with the configuration stored in the
     * Configuration Data Base (software configuration).
     * @return true if the hardware and software configuration are the same,
     *         false otherwise.
     * @throws org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException
     * @throws org.lsst.ccs.subsystems.fcs.errors.SDORequestException
     */
    boolean checkMotorParameters() throws EPOSConfigurationException, SDORequestException;

    /**
     * Defines the actual position as the absolute position which value is given as an argument.
     * @param position
     * @throws SDORequestException
     * @throws ErrorInCommandExecutionException
     * @throws BadCommandException
     */
    void defineAbsolutePosition(int position) throws SDORequestException, ErrorInCommandExecutionException, BadCommandException;

    /**
     * This methods writes in the CPU of the EPOS devis the values of the parameters set for the mode.
     * Usually the values of the parameters are given by the configuration system.
     * @param mode
     * @throws SDORequestException
     * @throws org.lsst.ccs.bus.ErrorInCommandExecutionException
     */
    void writeParameters(EposMode mode) throws SDORequestException, ErrorInCommandExecutionException;

    /**
     * In PROFILE_POSITION mode this methods set the target position.
     * This make run the motor.
     * @param aValue UNIT=mA / FORMAT=decimal the value of the current to be sent.
     * @throws BadCommandException
     * @throws org.lsst.ccs.subsystems.fcs.errors.SDORequestException
     *
     */
    void writeTargetPosition(int aValue) throws BadCommandException, SDORequestException;

    /**
     * Write to the CPU of the EPOS a map of parameters.
     * @param paramMap
     * @throws SDORequestException
     */
    void writeParameters(Map<String, Integer> paramMap) throws SDORequestException;

    /*Methods available in CURRENT mode*/
    /**
     * In current mode this methods send a current to the motor.
     * This make run the motor.
     * @param aValue UNIT=mA / FORMAT=decimal the value of the current to be sent.
     * @throws BadCommandException
     * @throws org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException
     * @throws org.lsst.ccs.subsystems.fcs.errors.SDORequestException
     *
     */
    void writeCurrent(int aValue) throws BadCommandException, EPOSConfigurationException, SDORequestException;


    public boolean isTargetPositionReached(int position) throws SDORequestException;
    
    public int readPosition() throws SDORequestException;
    
    public String enable() throws SDORequestException;
    
}
