/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.PlutoGatewayInterface;

/**
 * This represents the gateway to the pluto PLC involved in the camera protection system.
 * The sensors are read through this gateway.
 * We read the data from the gateway byte by byte. Usually we read 2 bytes at one time.
 * This class has to be extended to fit the real hardware control software needs and the 
 * simulator.
 * 
 * @author virieux
 */
public abstract class PlutoGatewayModule extends Module implements PlutoGatewayInterface {

   public String[] hexaValues;
    
   //updatingValue is true while we are reading the value sent by the Sensor
   //this could take some time
   protected volatile boolean updatingValues = false;
   protected final Lock lock = new ReentrantLock();
   protected final Condition valueUpdated = lock.newCondition();

    public PlutoGatewayModule(String string, int i) {
        super(string, i);
    }
   
   
        
    @Override
   public void initModule() {
       this.hexaValues = new String[2];
       this.hexaValues[0] = "00";
       this.hexaValues[1] = "00";
   }
   
     /**
     * @return the hexa values.
     */
    public String[] getHexaValues() {
       lock.lock();
       try {
           while (updatingValues) {
                try {
                    //TODO put a timeout
                    valueUpdated.await();
                } catch (InterruptedException ex) {
                    log.error(getName() + ex.getMessage());
      
                }
           }
           return this.hexaValues;
       } finally {
           lock.unlock();
       }
    }
    

    public void updateValues() {
       lock.lock();       
       
       
       try {
            updatingValues = true;
            this.hexaValues = readNewHexaValues();
//            log.debug(getName() + " HEXA VALUE READ: hexaValues[0]=" + this.hexaValues[0]
//                + " hexaValues[1]=" + this.hexaValues[1]);

       } finally {
           

           updatingValues = false;
           valueUpdated.signal();
           lock.unlock();
           
       }
    }

    
}
