/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.atomic.AtomicBoolean;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.utilities.tracers.Tracer;

/**
 * This is the Main Module for every software related to the Filters Exchanger :
 * - single-filter-test control-command
 * - scale 1 prototype control-command
 * - real Filters Exchanger
 * This class is designed to gather the commons methods to all these softwares.
 *
 * @author virieux
 */
public abstract class MainModule extends Module {
    protected BridgeToHardware bridge;
    protected boolean hardwareReady;
    protected AtomicBoolean haltRequired;
    

    public MainModule(String aName, int aTickMillis, BridgeToHardware bridge) {
        super(aName, aTickMillis);
        this.hardwareReady = false;
        this.bridge = bridge;
    }

    @Override
    public void initModule() {
//        this.bridge.startThreadReader();
        haltRequired = new AtomicBoolean(false);
    }
    
    /**
     * This methods updates the boolean hardwareReady from the hardware bridge.
     * But when the hardware is ready, it doesn't not ask hardware bridge again to avoid
     * too much messages on the log bus, could be replace by :
     * return this.bridge.isHardwareReady();
     * @return true if hardware is booted, identified and initialized
     */
    @Command ( level=Command.ENGINEERING1, description="Return true if hardware is booted, identified and initialized.", type=Command.CommandType.QUERY)
    public boolean isHardwareReady() {
        if (hardwareReady) {
            return this.hardwareReady;
        } else {
            this.hardwareReady = this.bridge.isHardwareReady();
            return this.hardwareReady;
        }
    }
    
    @Command ( type=Command.CommandType.QUERY, description="Return true if this main module controls real hardware.")
    public boolean controlRealHardware() {
        return this.bridge.isRealHardware();
    }
    
    /**
     * This method returns the list of hardware that this bridge will manage.
     * @return 
     */
    @Command ( level=Command.ENGINEERING1, description="Return the list of can open hardware that this subsystem manage.", type=Command.CommandType.QUERY)
    public String listHardware() {
        return this.bridge.getTcpProxy().listHardware();
    }
    
    @Override
    public String toString() {
        return super.toString();
    }
    
    //To retrieve the FCS version number.
    //To use with a properties : org.lsst.ccs.traces=VERSION and option : -ea
    static {
        assert Tracer.version("$Rev$", MainModule.class, "org-lsst-ccs-subsystems-fcs");
    }
    




    
}
