/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs;

import java.beans.ConstructorProperties;
import org.lsst.ccs.CurrentCommandContext;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;

/**
 * This is the model for the loader in the Filter Exchange System. 
 * The loader is used to load a filter into the camera or to unload a filter from the camera.
 * @author virieux
 */
public class LoaderModule extends Module {
    
    private LoaderCarrierModule carrier;
    private LoaderClampModule clamp;
    private AutoChangerModule autochanger;
    private NumericSensor filterPresenceSensor;
    private NumericSensor loaderOnCameraPresenceSensor;
    

    
    boolean empty;
    boolean loaderConnected;
    



    @ConstructorProperties({"name","tickmillis","carrier","clamp",
            "filterPresenceSensor", "loaderOnCameraPresenceSensor"})
    public LoaderModule(String moduleName, int aTickMillis, 
            LoaderCarrierModule carrier, 
            LoaderClampModule clamp,
            NumericSensor filterPresenceSensor, 
            NumericSensor loaderOnCameraPresenceSensor) {
        super(moduleName, aTickMillis);
        this.carrier = carrier;
        this.clamp = clamp;
        this.empty = true; //TODO set to false when we have the carrier
        this.loaderConnected = false;
    }
    
    @Command(type=Command.CommandType.QUERY, level=Command.NORMAL, description="Return true if no filter is in the loader.")
    public boolean isEmpty() {
        return this.empty;
    }
    
    @Command(type=Command.CommandType.QUERY, level=Command.NORMAL, description="Return true if no filter is in the loader.")
    public boolean isMoving() {
        return this.clamp.isItemMoving();
    }
    
    
    @Command(type=Command.CommandType.QUERY, level=Command.NORMAL, description="A filter is there and it is held by the clamp.")
    public boolean isHoldingAFilter() {
        return false;
    }

    public LoaderClampModule getClamp() {
        return this.clamp;
    }

    public LoaderCarrierModule getCarrier() {
        return carrier;
    }
    
    public boolean isCarrierAtStoragePosition() {
        return carrier.isAtStoragePosition();
    }
    
    
    
    @Override
    public void initModule() {
        this.autochanger = (AutoChangerModule) this.getModule("autochanger");
    }
    

    public void initializeHardware() throws HardwareException, ErrorInCommandExecutionException, BadCommandException {
        this.updateStateWithSensors();
        
        this.clamp.initializeHardware();
        
        this.carrier.initialiazeHardware();
            
        
    }
    
    @Override
    public void tick() {
//        try {
//            this.updateStateWithSensors();
//        } catch (ErrorInCommandExecutionException | HardwareException ex) {
//                log.error(ex.getMessage());
//                Alarm alarm = new FcsAlarm(ex.toString());
//                //                
//                this.getSubsystem().switchToErrorState(ex.toString());
//                this.sendToStatus(alarm);
//        }
        //sendToStatus(getStatusData());
    }
    
    /**
     * This updates the clamps state of the loader : clampsLockStatus
     * @throws HardwareException
     * @throws ErrorInCommandExecutionException 
     */
    @Command(type=Command.CommandType.ACTION, level=Command.NORMAL, description="Update clamp and carrier states in reading the sensors.")
    public void updateStateWithSensors() throws HardwareException, ErrorInCommandExecutionException {
        this.updateHookStateWithSensors();       
        this.updateCarrierStateWithSensors();
    }
    
    /**
     * This method closes the clamps.
     * When this action is completed the filter is clamped softly on the loader and can't fall.
     * @return a message for the end user.
     * @throws org.lsst.ccs.bus.BadCommandException
     * @throws org.lsst.ccs.bus.ErrorInCommandExecutionException
     * @throws org.lsst.ccs.subsystems.fcs.errors.HardwareException
     */
    @Command(type=Command.CommandType.ACTION, level=Command.ENGINEERING1, description="Close hooks.")
    public String closeHooks() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        return clamp.close();
    }
    
    /**
     * This method closes the clamps strongly.
     * When this action is completed, the filter is clamped softly on the loader and is tight fermely on the carrier.
     * 
     * @return a message for the end user.
     * @throws org.lsst.ccs.bus.BadCommandException
     * @throws org.lsst.ccs.bus.ErrorInCommandExecutionException
     * @throws org.lsst.ccs.subsystems.fcs.errors.HardwareException
     */
    @Command(type=Command.CommandType.ACTION, level=Command.ENGINEERING1, description="Clamp hooks.")
    public String clampHooks() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        return clamp.clamp();
    }
    
    /**
     * This method opens the clamp.
     * @return a message for the end user.
     * @throws org.lsst.ccs.bus.BadCommandException
     * @throws org.lsst.ccs.bus.ErrorInCommandExecutionException
     * @throws org.lsst.ccs.subsystems.fcs.errors.HardwareException
     */
    //TODO check the preconditions
    @Command ( level=Command.ENGINEERING1, description="Open the hooks", type=Command.CommandType.ACTION)
    public String openHooks() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        return clamp.open();
    }

//    @Command ( level=Command.ENGINEERING1, description="Return true if the carrier can move.", type=Command.CommandType.QUERY)
//    public boolean checkPreConditionsForCarrierMotion() {
//        return carrier.isEmpty() || carrier.isHoldingFilter();
//    }
    
     /**
     * Moves the loader carrier to the handoff position.
     */
    //TODO check the preconditions
    @Command ( level=Command.ENGINEERING1, description="Move the loader carrier to HANDOFF position", type=Command.CommandType.ACTION)
    public void moveToHandoff() {
        carrier.goToHandOff();
    }

    /**
     * Moves the loader carrier to the storage position.
     */
    //TODO check the preconditions
    @Command ( type=Command.CommandType.ACTION, level=Command.ENGINEERING1, description="Move the loader carrier to STORAGE position")
    public void moveToStorage() {
        carrier.goToStorage();
    }

    @Command(type=Command.CommandType.ACTION, level=Command.NORMAL, description="Update clamp state in reading the sensors.")
    private void updateHookStateWithSensors() {
        this.clamp.updateStateWithSensors();
    }
    
    @Command(type=Command.CommandType.ACTION, level=Command.NORMAL, description="Update carrier states in reading the sensors.")
    public void updateCarrierStateWithSensors() {
        carrier.updateStateWithSensors();
    }
    

    @Command(type=Command.CommandType.QUERY, level=Command.NORMAL, description="List and display info on the hooks.")
    public String listHooks() {
        return this.clamp.listHooks();
    }
    
    @Command(type=Command.CommandType.QUERY, level=Command.ENGINEERING1, description="List and display hooks sensors values.")
    public String listSensorsValues() {
        return this.clamp.listSensorsValues();
    }
    
    //for the simulation 
    public void test() {       
        CurrentCommandContext currentCmdContext = Subsystem.LOCAL_EXECUTION_INFO.get();
        log.debug("Command running:" + currentCmdContext.getCommandName() );
        log.info("coming from:" + currentCmdContext.getCommandOriginator());
        this.getSubsystem().interruptActionThread();
    }
    

    
}
