/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import java.util.Observable;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.FcsAlarm;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftCarouselModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.SingleFilterTestConfig;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class SftMainModule
extends MainModule {
    private Filter dummyFilter;
    private SftCarouselModule carousel;
    private SftAutoChangerModule autochanger;
    private boolean filterLocated;

    public SftMainModule(String aName, int aTickMillis, BridgeToHardware bridge, Filter dummyFilter) {
        super(aName, aTickMillis, bridge);
        this.dummyFilter = dummyFilter;
    }

    public Filter getDummyFilter() {
        return this.dummyFilter;
    }

    @Override
    public void initModule() {
        super.initModule();
        this.carousel = (SftCarouselModule)this.getModule("carousel");
        this.autochanger = (SftAutoChangerModule)this.getModule("autochanger");
        this.hardwareReady = false;
        this.filterLocated = false;
    }

    public void tick() {
        if (this.isHardwareReady() && !this.filterLocated) {
            try {
                this.locateFilter();
                this.filterLocated = true;
                log.info((Object)"Filter has been located. Hardware is ready to receive commands.", new String[0]);
            }
            catch (Exception ex) {
                this.filterLocated = false;
                log.error((Object)ex.getMessage(), new String[0]);
                FcsAlarm alarm = new FcsAlarm(ex.toString());
                this.sendToStatus((Status)alarm);
            }
        }
    }

    public void locateFilter() throws HardwareException, ErrorInCommandExecutionException, BadCommandException {
        log.debug((Object)"MODE DEBUG", new String[0]);
        this.carousel.updateClampsStateWithSensors();
        if (this.carousel.getClampXminus().getClampState().equals((Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER) || this.carousel.getClampXminus().getClampState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER)) {
            this.carousel.getSockets()[0].putFilterOnSocket(this.dummyFilter);
        }
        this.autochanger.updateLatchesStateWithSensors();
        if (!this.autochanger.isTrucksEmpty()) {
            this.autochanger.setFilterOnTrucks(this.dummyFilter);
        }
        this.autochanger.updateTrucksLocationWithSensors();
    }

    public void checkPreConditionsForUnlockClamps() throws HardwareException, BadCommandException, ErrorInCommandExecutionException {
        this.updateStateWithSensors();
        if (this.carousel.isHoldingFilterAtStandby() && !this.autochanger.isHoldingFilterAtStandby()) {
            throw new ErrorInCommandExecutionException("Can't unlock clamps if filter is not held by autochanger.");
        }
    }

    public String displayData() {
        StringBuilder sb = new StringBuilder("Data published by ");
        sb.append(this.getContext().getSubsystem().getName()).append("\n  ");
        sb.append("publishedByCarousel");
        log.info((Object)("Carousel status=" + this.carousel.getStatusData().toString()), new String[0]);
        sb.append(this.carousel.getStatusData().toString());
        sb.append("\n  ");
        sb.append("clampXminus status=");
        sb.append(this.carousel.getClampXminus().getStatusData().toString());
        sb.append("\n  ");
        sb.append("clampXplus status=");
        sb.append(this.carousel.getClampXplus().getStatusData().toString());
        sb.append("\n  ");
        sb.append("publishedByAutoChanger");
        log.info((Object)("autochanger status=" + this.autochanger.getStatusData().toString()), new String[0]);
        sb.append(this.autochanger.getStatusData().toString());
        sb.append("\n  ");
        sb.append("latchXminus status=");
        sb.append(this.autochanger.getLatchXminus().getStatusData().toString());
        sb.append("\n  ");
        sb.append("latchXplus status=");
        sb.append(this.autochanger.getLatchXplus().getStatusData().toString());
        sb.append("\n  ");
        return sb.toString();
    }

    public String goToInitialState() throws HardwareException, ErrorInCommandExecutionException, BadCommandException {
        this.updateStateWithSensors();
        String ack = "Hardware is at initial state and ready for a sequence1";
        if (this.carousel.isHoldingFilterAtStandby()) {
            if (this.autochanger.isAtStandback()) {
                return ack;
            }
            if (this.autochanger.isAtStandby()) {
                log.info((Object)"=======> Autochanger moving back empty to online position.", new String[0]);
                this.autochanger.ungrabFilterAtStandby();
                return ack;
            }
            return "Autochanger trucks are in the midle, I don't know what to do.";
        }
        if (this.autochanger.isHoldingFilterAtStandback()) {
            if (!this.carousel.isReadyToGrabAFilterAtStandby()) {
                this.carousel.releaseClamps();
            }
            log.info((Object)"=======> Autochanger trucks moving back the filter to standby position.", new String[0]);
            this.autochanger.moveFilterToStandby(this.dummyFilter);
            log.info((Object)"=======> Carousel is grabbing filter at standby position.", new String[0]);
            this.carousel.grabFilterAtStandby(this.getDummyFilter());
            log.info((Object)"=======> Autochanger moving back empty to online position.", new String[0]);
            this.autochanger.ungrabFilterAtStandby();
            return ack;
        }
        if (this.autochanger.isHoldingFilterAtStandby()) {
            log.info((Object)"=======> Autochanger trucks about to move loaded with the filter to standback position.", new String[0]);
            this.autochanger.moveFilterToStandback(this.dummyFilter);
            log.info((Object)"=======> Carousel about to release Clamps.", new String[0]);
            this.carousel.releaseClamps();
            log.info((Object)"=======> Autochanger trucks moving back the filter to standby position.", new String[0]);
            this.autochanger.moveFilterToStandby(this.dummyFilter);
            log.info((Object)"=======> Carousel is grabbing filter at standby position.", new String[0]);
            this.carousel.grabFilterAtStandby(this.getDummyFilter());
            log.info((Object)"=======> Autochanger moving back empty to online position.", new String[0]);
            this.autochanger.ungrabFilterAtStandby();
            return ack;
        }
        if (!this.autochanger.isAtStandback() && !this.autochanger.isAtStandby()) {
            return "Autochanger trucks are in the midle, I don't know what to do.";
        }
        return "Nobody holds the filter : I don't know how to go to initial state.";
    }

    @Command(level=0, description="The world famous sequence 1", type=Command.CommandType.ACTION, alias="es1")
    public String executeSequence1() throws BadCommandException, ErrorInCommandExecutionException, HardwareException, CanOpenException {
        log.info((Object)"=======> Autochanger trucks about to move empty to standby position.", new String[0]);
        this.autochanger.grabFilterAtStandby(this.dummyFilter);
        log.info((Object)"=======> Carousel is ungrabbing filter at standby position.", new String[0]);
        this.carousel.ungrabFilterAtStandby(this.dummyFilter);
        log.info((Object)"=======> Autochanger trucks about to move loaded with the filter to standback position.", new String[0]);
        this.autochanger.moveFilterToStandback(this.dummyFilter);
        log.info((Object)"=======> Carousel about to release Clamps.", new String[0]);
        this.carousel.releaseClamps();
        log.info((Object)"=======> Autochanger trucks moving back the filter to standby position.", new String[0]);
        this.autochanger.moveFilterToStandby(this.dummyFilter);
        log.info((Object)"=======> Carousel is grabbing filter at standby position.", new String[0]);
        this.carousel.grabFilterAtStandby(this.getDummyFilter());
        log.info((Object)"=======> Autochanger moving back empty to online position.", new String[0]);
        this.autochanger.ungrabFilterAtStandby();
        log.info((Object)"=======> Execution of Sequence1 completed.", new String[0]);
        return String.valueOf(this.getName()) + " Execution of Sequence1 completed";
    }

    @Command(level=0, description="The world famous sequence 1 (with number of repetitions)", type=Command.CommandType.ACTION, alias="es1")
    public String executeSequence1(@Argument(name="nExecutions", description="Number of executions", defaultValue="1") int nb) throws BadCommandException, ErrorInCommandExecutionException, HardwareException, CanOpenException {
        if (nb < 1 || nb > 20000) {
            throw new IllegalArgumentException("nb has to be comprise between 1 and 20000");
        }
        int i = 1;
        while (i < nb + 1) {
            log.info((Object)("===========================BEGIN execution Sequence1 nb=" + i + " ================"), new String[0]);
            this.executeSequence1();
            log.info((Object)("===========================END execution Sequence1 nb=" + i + " ================"), new String[0]);
            ++i;
        }
        return String.valueOf(this.getName()) + ":" + nb + " executions of Sequence1 completed";
    }

    boolean autochangerLatchesAreLocked() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Filter getFilterAtStandby() {
        return this.carousel.getFilterAtStandby();
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
    }

    public String printFilters() {
        StringBuilder sb = new StringBuilder(String.valueOf(this.getName()) + " printFilters \n ");
        sb.append(this.dummyFilter.getName());
        sb.append(" position: ").append(this.carousel.getFilterPosition(this.dummyFilter));
        sb.append(" socket number: ").append(this.carousel.getSocketNumber(this.dummyFilter));
        sb.append(" standby position: ").append(this.carousel.getStandbyPositionForFilter(this.dummyFilter));
        log.info((Object)sb.toString(), new String[0]);
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("\n").append(this.carousel.toString());
        sb.append("\n").append(this.autochanger.toString());
        return sb.toString();
    }

    public void updateStateWithSensors() throws HardwareException, ErrorInCommandExecutionException, BadCommandException {
        this.carousel.updateStateWithSensors();
        this.autochanger.updateStateWithSensors();
    }

    public SftCarouselModule getCarouselModule() {
        return this.carousel;
    }

    public SftAutoChangerModule getAutoChangerModule() {
        return this.autochanger;
    }

    public SingleFilterTestConfig getFullState() {
        return FcsUtils.createSingleFilterTestConfig(this);
    }
}

