/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.subsystems.fcs.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterLatchModule;
import org.lsst.ccs.subsystems.fcs.TruckModule;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftMainModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftTruckMotor;

public class SftAutoChangerModule
extends BasicAutoChangerModule {
    protected SftTruckMotor sftTrucksMotor;
    private long timeToConfortAPosition;
    private long timeToGoToStandby;
    private long timeToGoToStandback;

    public SftAutoChangerModule(String moduleName, int aTickMillis, FilterLatchModule latchXminus, FilterLatchModule latchXplus, TruckModule truckXminus, TruckModule truckXplus, String railsSensorsDIOName, String filterSensorsDIOName, SftTruckMotor sftTrucksMotor, long timeToConfortAPosition, long timeToGoToStandby, long timeToGoToStandback) {
        super(moduleName, aTickMillis, latchXminus, latchXplus, truckXminus, truckXplus, railsSensorsDIOName, filterSensorsDIOName);
        this.sftTrucksMotor = sftTrucksMotor;
        this.timeToConfortAPosition = timeToConfortAPosition;
        this.timeToGoToStandby = timeToGoToStandby;
        this.timeToGoToStandback = timeToGoToStandback;
    }

    public SftTruckMotor getSftTrucksMotor() {
        return this.sftTrucksMotor;
    }

    public void setSftTrucksMotor(SftTruckMotor sftTrucksMotor) {
        this.sftTrucksMotor = sftTrucksMotor;
    }

    public long getTimeToConfortAPosition() {
        return this.timeToConfortAPosition;
    }

    public long getTimeToGoToStandback() {
        return this.timeToGoToStandback;
    }

    public long getTimeToGoToStandby() {
        return this.timeToGoToStandby;
    }

    @ConfigChanger
    public void setTimeToConfortAPosition(long timeToConfortAPosition) {
        this.timeToConfortAPosition = timeToConfortAPosition;
    }

    @ConfigChanger
    public void setTimeToGoToStandby(long timeToGoToStandby) {
        this.timeToGoToStandby = timeToGoToStandby;
    }

    @ConfigChanger
    public void setTimeToGoToStandback(long timeToGoToStandback) {
        this.timeToGoToStandback = timeToGoToStandback;
    }

    @Override
    public boolean isMovingToStandback() {
        return this.sftTrucksMotor.isMovingToStandback();
    }

    @Override
    public boolean isMovingToStandby() {
        return this.sftTrucksMotor.isMovingToStandby();
    }

    @Override
    public boolean isMoving() {
        return this.isMovingToStandback() || this.isMovingToStandby();
    }

    private Filter getFilterAtStandbyOnCarousel() {
        return ((SftMainModule)this.getModule("main")).getFilterAtStandby();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String stop() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void locateTrucks() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String goToStandback() throws BadCommandException, ErrorInCommandExecutionException, HardwareException, CanOpenException {
        this.checkPreConditionsForTrucksMotion();
        this.updateTrucksLocationWithSensors();
        if (this.isAtStandback()) {
            return String.valueOf(this.getName()) + " trucks already at standback location";
        }
        if (this.getTrucksLocation().equals((Object)FcsEnumerations.AutoChangerTrucksLocation.UNKNOWN)) {
            log.error((Object)(String.valueOf(this.getName()) + " Cannot execute goToStandback : Trucks are between standback and standby location."), new String[0]);
            throw new BadCommandException(String.valueOf(this.getName()) + " Cannot execute goToStandback : Trucks are between standback and standby location.");
        }
        if (this.getTrucksLocation().equals((Object)FcsEnumerations.AutoChangerTrucksLocation.ERROR)) {
            log.error((Object)(String.valueOf(this.getName()) + " Cannot execute goToStandback : ERROR in reading rails sensors"), new String[0]);
            throw new BadCommandException(String.valueOf(this.getName()) + " Cannot execute goToStandback : ERROR in reading rails sensors.");
        }
        if (this.isAtStandby()) {
            if (!this.isTrucksEmpty() && this.getLatchesState() == FcsEnumerations.LockStatus.LOCKED) {
                this.carousel.updateClampsStateWithSensors();
                if (this.carousel.isHoldingFilterAtStandby()) {
                    throw new BadCommandException(String.valueOf(this.getName()) + " can't move filter to standback because the carousel is holding the filter at standby.");
                }
            }
            log.debug((Object)(String.valueOf(this.getName()) + ": The position is being conforted"), new String[0]);
            this.sftTrucksMotor.moveToStandby();
            try {
                Thread.sleep(this.timeToConfortAPosition);
            }
            catch (InterruptedException ex) {
                log.debug((Object)ex, new String[0]);
            }
        }
        log.info((Object)(String.valueOf(this.getName()) + " IS GOING TO STANDBACK POSITION"), new String[0]);
        this.sftTrucksMotor.moveToStandback();
        try {
            Thread.sleep(this.timeToGoToStandback);
        }
        catch (InterruptedException ex) {
            log.debug((Object)ex, new String[0]);
        }
        this.sftTrucksMotor.off();
        this.updateTrucksLocationWithSensors();
        if (this.isAtStandback()) {
            log.debug((Object)("====> " + this.getName() + "  IS AT STANDBACK POSITION"), new String[0]);
            return String.valueOf(this.getName()) + " IS AT STANDBACK POSITION";
        }
        throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + "could not go to STANDBACK POSITION");
    }

    @Override
    public String goToStandby() throws BadCommandException, ErrorInCommandExecutionException, HardwareException, CanOpenException {
        this.checkPreConditionsForTrucksMotion();
        this.updateTrucksLocationWithSensors();
        if (this.isAtStandby()) {
            return String.valueOf(this.getName()) + "trucks already at standby position";
        }
        if (this.getTrucksLocation().equals((Object)FcsEnumerations.AutoChangerTrucksLocation.UNKNOWN)) {
            log.error((Object)(String.valueOf(this.getName()) + " Cannot execute goToStandby : Trucks are between standback and standby location."), new String[0]);
            throw new BadCommandException(String.valueOf(this.getName()) + " Cannot execute goToStandby : Trucks are between standback and standby location.");
        }
        if (this.getTrucksLocation().equals((Object)FcsEnumerations.AutoChangerTrucksLocation.ERROR)) {
            log.error((Object)(String.valueOf(this.getName()) + " Cannot execute goToStandby : ERROR in reading rails sensors"), new String[0]);
            throw new BadCommandException(String.valueOf(this.getName()) + " Cannot execute goToStandby : ERROR in reading rails sensors.");
        }
        if (this.isAtStandback()) {
            this.sftTrucksMotor.moveToStandback();
            try {
                log.debug((Object)(String.valueOf(this.getName()) + ": Waiting for the position to be conforted"), new String[0]);
                Thread.sleep(this.timeToConfortAPosition);
            }
            catch (InterruptedException ex) {
                log.error((Object)ex, new String[0]);
            }
        }
        log.info((Object)(String.valueOf(this.getName()) + " IS GOING TO STANDBY POSITION"), new String[0]);
        this.sftTrucksMotor.moveToStandby();
        try {
            log.debug((Object)(String.valueOf(this.getName()) + ": Waiting for the trucks to go to STANDBY"), new String[0]);
            Thread.sleep(this.timeToGoToStandby);
        }
        catch (InterruptedException ex) {
            log.error((Object)ex, new String[0]);
        }
        this.sftTrucksMotor.off();
        this.updateTrucksLocationWithSensors();
        if (this.isAtStandby()) {
            log.debug((Object)("====> " + this.getName() + "  IS AT STANDBY POSITION"), new String[0]);
            return String.valueOf(this.getName()) + " IS AT STANDBY POSITION";
        }
        throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + " could not go to STANDBY POSITION");
    }

    @Override
    public String moveFilterToStandback(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException, HardwareException, CanOpenException {
        if (this.isTrucksEmpty()) {
            throw new BadCommandException(String.valueOf(this.getName()) + " unable to moveFilterToStandback: Autochanger is empty");
        }
        this.goToStandback();
        this.updateLatchesStateWithSensors();
        this.publishDataAndNotifyObservers();
        return String.valueOf(this.getName()) + ": " + aFilter.getName() + " is at standback position.";
    }

    @Override
    public String moveFilterToStandby(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException, HardwareException, CanOpenException {
        if (this.isTrucksEmpty()) {
            throw new BadCommandException(String.valueOf(this.getName()) + "/moveFilterToStandby: Autochanger is empty");
        }
        this.carousel.updateClampsStateWithSensors();
        if (!this.carousel.isReadyToGrabAFilterAtStandby()) {
            throw new BadCommandException(String.valueOf(this.getName()) + "can't move a filter to STANDBY because carousel is not ready to grab a filter.");
        }
        this.goToStandby();
        this.updateLatchesStateWithSensors();
        this.publishDataAndNotifyObservers();
        return String.valueOf(this.getName()) + ": " + aFilter.getName() + " is at standby position.";
    }

    @Override
    public String goToPosition(double trucksPositionOnline) throws BadCommandException {
        throw new UnsupportedOperationException("Not in single-filter-test.");
    }

    @Override
    public double getTrucksPosition() {
        throw new UnsupportedOperationException("Not supported in single-filter-test.");
    }

    @Override
    public String moveFilterToOnline(Filter filter) throws BadCommandException, ErrorInCommandExecutionException, HardwareException, CanOpenException {
        return this.moveFilterToStandback(filter);
    }

    @Override
    public void updateStateWithSensors() throws HardwareException, ErrorInCommandExecutionException {
        this.updateLatchesStateWithSensors();
        this.updateTrucksLocationWithSensors();
        if (this.getLatchXminus().getPresenceStatus().equals((Object)FcsEnumerations.FilterPresenceInLatchStatus.NOFILTER) && this.getLatchXplus().getPresenceStatus().equals((Object)FcsEnumerations.FilterPresenceInLatchStatus.NOFILTER)) {
            this.setTrucksEmpty(true);
            this.setFilterOnTrucks(null);
        }
    }
}

