/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.math.BigDecimal;
import java.util.Random;
import org.lsst.ccs.subsystems.fcs.Sensor14bits;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;

public class SimuSensor14bits
extends Sensor14bits {
    int value1 = 0;
    int value2 = 32768;
    Random randomGenerator = new Random();

    public SimuSensor14bits(String moduleName, int aTickMillis, int aValue) {
        super(moduleName, aTickMillis);
        this.value = aValue;
    }

    SimuSensor14bits(String moduleName, int aTickMillis, int aValue1, int aValue2) {
        super(moduleName, aTickMillis);
        this.value1 = aValue1;
        this.value2 = aValue2;
    }

    void setNewRange(int aValue1, int aValue2) {
        if (aValue2 < aValue1 || aValue2 > 32768) {
            String message = String.format("we must have : value1 < value2 < maxValue / value1= %s, value2=%s, maxValue=%s", this.value1, this.value2, 32768);
            throw new IllegalArgumentException(message);
        }
        this.value1 = aValue1;
        this.value2 = aValue2;
    }

    @Override
    public int readNewValue() {
        if (this.value2 > 0) {
            int n = this.randomGenerator.nextInt(this.value2);
            if (n > this.value1) {
                return n;
            }
            BigDecimal bd = new BigDecimal(this.value1 + n * (this.value2 - this.value1) / this.value2);
            return bd.intValue();
        }
        String msg = String.valueOf(this.getName()) + ": ERROR in readNewValue: value2 should be positive";
        throw new IllegalArgumentException(msg);
    }

    @Override
    public int updateValue(CanOpenProxy.PDOStorage pdoStorage) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

