/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.HashMap;
import java.util.concurrent.TimeoutException;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.state.State;
import org.lsst.ccs.subsystems.fcs.FcsAlarm;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenNode;
import org.lsst.ccs.subsystems.fcs.drivers.FcsTcpProxy;
import org.lsst.ccs.subsystems.fcs.errors.CWrapperNotConnected;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCommunicationException;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenDeviceException;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenException;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenGenericException;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenMotionException;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenTemperatureException;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenVoltageException;
import org.lsst.ccs.subsystems.fcs.errors.ErrorInBootingHardwareProcessException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareConfigurationException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.NodeIDMismatchException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.UnexpectedBootMessageReceivedException;

public class CanOpenProxy
extends FcsTcpProxy {
    private String myClientName;
    private int expectedNodesNB;
    private int bootedNodesNB;
    private CanOpenNode[] nodes = new CanOpenNode[this.getExpectedNodesNB()];
    private boolean hardwareBootProcessEnded = false;
    private boolean hardwareIdentified = false;
    private boolean hardwareInitialized = false;
    private long hardwareBootTimeout;
    private long hardwareBootProcessBeginTime;
    public PieceOfHardware[] hardwareList;
    private boolean canOpenNodeNumbersOK = false;
    private boolean canOpenNodesChecked = false;
    private PDOStorage pdoStorage;

    public CanOpenProxy(String aName, int aTickMillis, int portNumber, String aClientName, int expectedNodesNB, long hardwareBootTimeout) {
        super(aName, aTickMillis, portNumber);
        this.myClientName = aClientName;
        this.expectedNodesNB = expectedNodesNB;
        this.hardwareBootTimeout = hardwareBootTimeout;
    }

    public void disconnectHardware() throws InterruptedException {
        this.stop();
        Thread.sleep(this.tickMillis);
        this.initModule();
    }

    public int getExpectedNodesNB() {
        return this.expectedNodesNB;
    }

    public void setExpectedNodesNB(int nodeNB) {
        this.expectedNodesNB = nodeNB;
    }

    public long getHardwareBootTimeout() {
        return this.hardwareBootTimeout;
    }

    @ConfigChanger
    public void setHardwareBootTimeout(long hardwareBootTimeout) {
        this.hardwareBootTimeout = hardwareBootTimeout;
    }

    @ConfigChanger
    public void setHardwareBootTimeout(int hardwareBootTimeout) {
        this.hardwareBootTimeout = hardwareBootTimeout;
    }

    public int getBootedNodesNB() {
        return this.bootedNodesNB;
    }

    public String getMyClientName() {
        return this.myClientName;
    }

    public PDOStorage getPdoStorage() {
        return this.pdoStorage;
    }

    public boolean isHardwareIdentified() {
        return this.hardwareIdentified;
    }

    public boolean isHardwareInitialized() {
        return this.hardwareInitialized;
    }

    @Override
    public void initModule() {
        super.initModule();
        log.info((Object)("Expected Nodes NB=" + this.expectedNodesNB), new String[0]);
        this.nodes = new CanOpenNode[this.expectedNodesNB];
        this.hardwareBootProcessBeginTime = 0L;
        this.bootedNodesNB = 0;
        this.hardwareBootProcessEnded = false;
        this.hardwareIdentified = false;
        this.hardwareInitialized = false;
        this.canOpenNodeNumbersOK = false;
        this.canOpenNodesChecked = false;
        this.pdoStorage = new PDOStorage();
    }

    public void tick() {
        FcsAlarm alarm;
        if (this.hardwareBootProcessBeginTime == 0L && this.isReady(this.myClientName)) {
            this.hardwareBootProcessBeginTime = System.currentTimeMillis();
        }
        if (this.hardwareBootProcessBeginTime > 0L && !this.hardwareBootProcessEnded) {
            long hardwareBootDuration = System.currentTimeMillis() - this.hardwareBootProcessBeginTime;
            if (this.bootedNodesNB == this.getExpectedNodesNB()) {
                this.hardwareBootProcessEnded = true;
            } else if (hardwareBootDuration > this.hardwareBootTimeout) {
                this.hardwareBootProcessEnded = true;
                log.error((Object)"Timeout expired during hardware booting process ", new String[0]);
                this.getSubsystem().updateState(State.InError, "Timeout expired during hardware booting process : number of booted is not was expected");
            }
        }
        if (this.hardwareBootProcessEnded && !this.hardwareIdentified) {
            try {
                this.identifieHardware();
            }
            catch (TimeoutException ex) {
                log.error((Object)"Timeout expired during hardware identifie process ", new String[0]);
                this.getSubsystem().updateState(State.InError, "Timeout expired during hardware identifie process." + ex.getMessage());
            }
            this.hardwareIdentified = true;
        }
        if (this.hardwareIdentified && !this.canOpenNodesChecked) {
            try {
                this.canOpenNodesChecked = this.checkCanOpenNodes();
                log.info((Object)"Hardware configuration is checked", new String[0]);
            }
            catch (HardwareConfigurationException ex) {
                this.canOpenNodesChecked = false;
                log.error((Object)("ERROR in configuration for a Can Open node: " + ex.getMessage()), new String[0]);
                alarm = new FcsAlarm(ex.toString());
                this.sendToStatus((Status)alarm);
                this.getSubsystem().updateState(State.InError, "ERROR in configuration for a nodeID" + ex.toString());
            }
            catch (HardwareNotDetectedException ex) {
                this.canOpenNodesChecked = false;
                log.error((Object)("HARDWARE NOT DETECTED : POWER FAILURE ?" + ex.getMessage()), new String[0]);
                alarm = new FcsAlarm(ex.toString());
                this.sendToStatus((Status)alarm);
                this.getSubsystem().updateState(State.InError, "HARDWARE NOT DETECTED : POWER FAILURE ?" + ex.getMessage());
            }
            catch (ErrorInBootingHardwareProcessException ex) {
                this.canOpenNodesChecked = false;
                log.error((Object)("HARDWARE NOT DETECTED : POWER FAILURE ?" + ex.getMessage()), new String[0]);
                alarm = new FcsAlarm(ex.toString());
                this.sendToStatus((Status)alarm);
                this.getSubsystem().updateState(State.InError, "HARDWARE NOT DETECTED : POWER FAILURE ?" + ex.getMessage());
            }
            catch (BadCommandException ex) {
                log.error((Object)ex.getMessage(), new String[0]);
                alarm = new FcsAlarm(ex.toString());
                this.sendToStatus((Status)alarm);
            }
        }
        if (this.canOpenNodesChecked && !this.hardwareInitialized) {
            try {
                this.initializeHardware();
                this.hardwareInitialized = true;
                log.info((Object)"Hardware is initialized", new String[0]);
            }
            catch (Exception ex) {
                this.hardwareInitialized = false;
                log.error((Object)("SOME HARDWARE COULDN'T BE INITIALIZED:" + ex.getMessage()), new String[0]);
                alarm = new FcsAlarm(ex.toString());
                this.sendToStatus((Status)alarm);
            }
        }
    }

    public boolean isBooted(String aNodeID) {
        if (this.bootedNodesNB == 0) {
            return false;
        }
        boolean nodeFound = false;
        int i = 0;
        while (i < this.bootedNodesNB) {
            if (this.nodes[i] != null && this.nodes[i].getNodeID().equals(aNodeID)) {
                nodeFound = true;
            }
            ++i;
        }
        return nodeFound;
    }

    public boolean isBooted(PieceOfHardware piece) {
        if (this.bootedNodesNB == 0) {
            return false;
        }
        boolean pieceFound = false;
        int i = 0;
        while (i < this.bootedNodesNB) {
            if (this.nodes[i] != null && this.nodes[i].getNodeID().equals(piece.getNodeID())) {
                pieceFound = true;
            }
            ++i;
        }
        return pieceFound;
    }

    public boolean isNodeIdBootedAndOK(PieceOfHardware piece) {
        if (this.bootedNodesNB == 0) {
            return false;
        }
        boolean pieceFound = false;
        int i = 0;
        while (i < this.bootedNodesNB) {
            if (this.nodes[i] != null && this.nodes[i].getNodeID().equals(piece.getNodeID()) && this.nodes[i].getSerialNB().equals(piece.getSerialNB())) {
                pieceFound = true;
            }
            ++i;
        }
        return pieceFound;
    }

    public String listNodes() {
        StringBuilder sb = new StringBuilder("Nodes LIST = (values are in HEXA)");
        int i = 0;
        while (i < this.bootedNodesNB) {
            sb.append("\n");
            if (this.nodes[i] == null) {
                sb.append("null node");
            } else {
                sb.append(this.nodes[i].toString());
            }
            ++i;
        }
        return sb.toString();
    }

    public String sendCanOpen(String command) throws TimeoutException, BadCommandException {
        try {
            String[] words = command.split(",");
            String keyWord = words[0];
            if (keyWord.equals("rsdo")) {
                if (words.length != 4) {
                    throw new BadCommandException("rsdo command must have 3 parameters: nodeID, index, subindex");
                }
            } else if (keyWord.equals("wsdo")) {
                if (words.length != 6) {
                    throw new BadCommandException("wsdo command must have 5 parameters: nodeID, index, subindex, size, data");
                }
            } else if (keyWord.equals("info")) {
                if (words.length != 2) {
                    throw new BadCommandException("info command must have 1 parameter: nodeID");
                }
            } else if (keyWord.equals("sync")) {
                if (words.length != 1) {
                    throw new BadCommandException("sync command takes no parameter");
                }
            } else if (keyWord.equals("srtr")) {
                if (words.length < 2) {
                    throw new BadCommandException("srtr command takes at least one parameter (cobib)");
                }
            } else if (keyWord.equals("quit")) {
                if (words.length != 1) {
                    throw new BadCommandException("quit command takes no parameter");
                }
            } else {
                throw new IllegalArgumentException(command);
            }
            return (String)this.call(this.getMyClientName(), command);
        }
        catch (CWrapperNotConnected ex) {
            log.error((Object)ex.toString(), new String[0]);
            FcsAlarm alarm = new FcsAlarm(ex.toString());
            this.sendToStatus((Status)alarm);
            this.getSubsystem().updateState(State.InError, "Can't communicate with harwdare because CWrapper is not connected." + ex.getMessage());
            return ex.toString();
        }
    }

    private static String buildWsdoCommand(String nodeID, String index, String subindex, String size, String data) {
        char sep = ',';
        String command = String.format("wsdo%1$s%2$s%1$s%3$s%1$s%4$s%1$s%5$s%1$s%6$s", Character.valueOf(sep), nodeID, index, subindex, size, data);
        return command;
    }

    private static String buildRsdoCommand(String nodeID, String index, String subindex) {
        char sep = ',';
        String command = String.format("rsdo%1$s%2$s%1$s%3$s%1$s%4$s", Character.valueOf(sep), nodeID, index, subindex);
        return command;
    }

    public String writeSDO(String nodeID, String index, String subindex, String size, String value) throws SDORequestException {
        SDORequestException err;
        String errorCode;
        String sdoResponseLine;
        block5: {
            sdoResponseLine = this.sendCanOpen(CanOpenProxy.buildWsdoCommand(nodeID, index, subindex, size, value));
            String[] words = sdoResponseLine.split(",");
            String cfr_ignored_0 = words[0];
            String cfr_ignored_1 = words[1];
            errorCode = words[2];
            if (!errorCode.equals("0")) break block5;
            return "OK";
        }
        try {
            if (errorCode.equals("-1")) {
                log.error((Object)("Wrong SDO command : " + sdoResponseLine), new String[0]);
                throw new SDORequestException("Wrong SDO command : " + sdoResponseLine);
            }
            log.error((Object)"SDO request was going wrong", new String[0]);
            String error = String.format("%08d", Integer.parseInt(errorCode));
            log.info((Object)("ERROR=" + error), new String[0]);
            String errorName = CanOpenErrorsTable.commErrorCodes.getProperty(error);
            throw new SDORequestException("SDO request was going wrong", errorCode, nodeID, index, subindex, errorName);
        }
        catch (BadCommandException ex) {
            err = new SDORequestException("write SDO request bad command : ", nodeID, "bad command", index, subindex, ex.getMessage());
            log.error((Object)String.format("%s %s for %s this should not happen.", "malformed SDO request : ", ex.getMessage(), nodeID), new String[0]);
            throw err;
        }
        catch (TimeoutException ex) {
            err = new SDORequestException("write SDO request timeout expired : ", nodeID, "timeout expired", index, subindex, ex.getMessage());
            log.error((Object)String.format("%s %s is %s stopped ?", "SDO request timeout expired : ", ex.getMessage(), nodeID), new String[0]);
            throw err;
        }
    }

    public String writeSDO(int nodeID, String index, String subindex, int size, int value) throws SDORequestException, BadCommandException {
        if (nodeID < 0 || nodeID > 127) {
            throw new IllegalArgumentException("nodeID must be > 0 and < 128");
        }
        if (size < 0 || size > 4) {
            throw new IllegalArgumentException("size must be > 0 and < 4");
        }
        return this.writeSDO(Integer.toHexString(nodeID), index, subindex, Integer.toHexString(size), Integer.toHexString(value));
    }

    public String readSDO(String nodeID, String index, String subindex) throws SDORequestException {
        try {
            String sdoLine = this.sendCanOpen(CanOpenProxy.buildRsdoCommand(nodeID, index, subindex));
            String[] words = sdoLine.split(",");
            int responseLength = words.length;
            String cfr_ignored_0 = words[0];
            String cfr_ignored_1 = words[1];
            String errorCode = words[2];
            if (errorCode.equals("0") && responseLength > 3) {
                return words[3];
            }
            if (errorCode.equals("-1")) {
                log.error((Object)("Wrong SDO command : " + sdoLine), new String[0]);
                throw new SDORequestException("Wrong SDO command : " + sdoLine);
            }
            log.error((Object)("SDO request was going wrong, received response=" + sdoLine), new String[0]);
            String error = String.format("%08d", Integer.parseInt(errorCode));
            log.info((Object)("ERROR=" + error), new String[0]);
            String errorName = CanOpenErrorsTable.commErrorCodes.getProperty(error);
            throw new SDORequestException("SDO request was going wrong", nodeID, errorCode, index, subindex, errorName);
        }
        catch (BadCommandException ex) {
            SDORequestException err = new SDORequestException("read SDO request: ", nodeID, "bad command", index, subindex, ex.getMessage());
            log.error((Object)String.format("%s %s on node %s should not happen", "bad command : ", ex.getMessage(), nodeID), new String[0]);
            throw err;
        }
        catch (TimeoutException ex) {
            SDORequestException err = new SDORequestException("read SDO request timeout expired : ", nodeID, "timeout expired", index, subindex, ex.getMessage());
            log.error((Object)String.format("%s %s is %s stopped ?", "SDO request timeout expired : ", ex.getMessage(), nodeID), new String[0]);
            throw err;
        }
    }

    public String readSDO(int nodeID, String index, String subindex) throws SDORequestException, BadCommandException {
        if (nodeID < 0 || nodeID > 127) {
            throw new IllegalArgumentException("nodeID must be > 0 and < 128");
        }
        return this.readSDO(Integer.toHexString(nodeID), index, subindex);
    }

    public PDOStorage readPDOs() throws HardwareException, BadCommandException {
        try {
            String replyToSync = this.sendCanOpen("sync");
            this.pdoStorage.updatePDOs(replyToSync);
            return this.pdoStorage;
        }
        catch (TimeoutException ex) {
            HardwareException err = new HardwareException("Timeout expired when waiting for the reply to a sync command in readPDOs : " + ex.toString());
            throw err;
        }
    }

    public void identifieHardware() throws TimeoutException {
        log.info((Object)"Identification of the hardware", new String[0]);
        int i = 0;
        while (i < this.bootedNodesNB) {
            if (this.nodes[i] != null) {
                try {
                    log.debug((Object)("Sending to can open command : info," + this.nodes[i].getNodeID()), new String[0]);
                    String result = this.sendCanOpen("info," + this.nodes[i].getNodeID());
                    log.debug((Object)("Received on socket command = " + result), new String[0]);
                    String infoLine = result;
                    String[] words = infoLine.split(",");
                    String command = words[0];
                    String nodeID = words[1];
                    if (command.equals("info") && nodeID.equals(this.nodes[i].getNodeID())) {
                        log.debug((Object)("updating Node Info for node " + nodeID), new String[0]);
                        String type = words[2];
                        String vendor = words[3];
                        String productCode = words[4];
                        String revision = words[5];
                        String serialNB = words[6];
                        this.nodes[i].setNodeInfo(type, vendor, productCode, revision, serialNB);
                    } else {
                        log.error((Object)("ERROR for command = " + command + "NodeID = " + nodeID), new String[0]);
                    }
                }
                catch (BadCommandException badCommandException) {}
            }
            ++i;
        }
        log.info((Object)"Hardware is identified", new String[0]);
        log.info((Object)this.listNodes(), new String[0]);
    }

    public boolean isHardwareReady() {
        log.info((Object)("hardwareBootProcessEnded=" + this.hardwareBootProcessEnded), new String[0]);
        log.info((Object)("hardwareIdentified=" + this.hardwareIdentified), new String[0]);
        log.info((Object)("canOpenNodeNumbersOK=" + this.canOpenNodeNumbersOK), new String[0]);
        log.info((Object)("canOpenNodesChecked=" + this.canOpenNodesChecked), new String[0]);
        return this.hardwareBootProcessEnded && this.hardwareIdentified && this.canOpenNodeNumbersOK && this.canOpenNodesChecked && this.hardwareInitialized;
    }

    public CanOpenNode getDetectedNodeForSerialNumber(String aSerialNB) {
        CanOpenNode detectedNode = null;
        int i = 0;
        while (i < this.bootedNodesNB) {
            if (this.nodes[i].getSerialNB().equals(aSerialNB)) {
                detectedNode = this.nodes[i];
            }
            ++i;
        }
        return detectedNode;
    }

    @Override
    void processBootMessage(String nodeID) {
        if (this.isBooted(nodeID)) {
            if (this.hardwareBootProcessEnded) {
                String msg = "An asynchronus boot message is arrived for node ID = " + nodeID;
                log.error((Object)msg, new String[0]);
                UnexpectedBootMessageReceivedException ex = new UnexpectedBootMessageReceivedException(msg, nodeID);
                FcsAlarm alarm = new FcsAlarm(ex.toString());
                this.sendToStatus((Status)alarm);
            }
        } else {
            log.info((Object)("bootedNodesNB=" + this.bootedNodesNB), new String[0]);
            log.info((Object)("Expected Nodes NB=" + this.getExpectedNodesNB()), new String[0]);
            this.nodes[this.bootedNodesNB] = new CanOpenNode(nodeID);
            ++this.bootedNodesNB;
            log.info((Object)("Node " + nodeID + " added"), new String[0]);
            log.info((Object)("Hardware booted nb=" + this.bootedNodesNB), new String[0]);
        }
    }

    @Override
    void processEmcyMessage(String message) {
        String[] words = message.split(",");
        String nodeID = words[1];
        String cfr_ignored_0 = words[2];
        String errReg = words[3];
        log.error((Object)("Received EMERGENCY message for nodeID: " + nodeID), new String[0]);
        log.error((Object)("message=" + message), new String[0]);
        String errorName = CanOpenErrorsTable.errorRegisterCodes.getProperty(errReg);
        log.info((Object)("errorName=" + errorName), new String[0]);
        try {
            if (errReg.equals("01")) {
                throw new CanOpenGenericException(errorName, nodeID, errReg);
            }
            if (errReg.equals("04")) {
                throw new CanOpenVoltageException(errorName, nodeID, errReg);
            }
            if (errReg.equals("08")) {
                throw new CanOpenTemperatureException(errorName, nodeID, errReg);
            }
            if (errReg.equals("10")) {
                throw new CanOpenCommunicationException(errorName, nodeID, errReg);
            }
            if (errReg.equals("20")) {
                throw new CanOpenDeviceException(errorName, nodeID, errReg);
            }
            if (errReg.equals("80")) {
                throw new CanOpenMotionException(errorName, nodeID, errReg);
            }
            throw new CanOpenException("Received EMERGENCY message (UNKNOWN Cnn Open Error) for nodeID: " + nodeID);
        }
        catch (CanOpenException ex) {
            log.error((Object)ex.getMessage(), new String[0]);
            FcsAlarm alarm = new FcsAlarm(ex.toString());
            this.sendToStatus((Status)alarm);
            String err = String.format("NodeID %s (%02d in decimal) : %s ", nodeID, Integer.parseInt(nodeID, 16), ex.getMessage());
            this.getSubsystem().updateState(State.InError, err);
            return;
        }
    }

    @Override
    void processUnknownCommand(String message) {
        String[] words = message.split(",");
        String command = words[1];
        String errorMessage = "Unknown command:" + command;
        log.error((Object)errorMessage, new String[0]);
    }

    public boolean checkCanOpenNodes() throws BadCommandException, ErrorInBootingHardwareProcessException, HardwareConfigurationException, HardwareNotDetectedException {
        if (!this.isReady(this.myClientName) || !this.isHardwareIdentified()) {
            throw new BadCommandException("Hardware not booted or not identified");
        }
        log.info((Object)"CHECKING HARDWARE CONFIGURATION ", new String[0]);
        if (this.bootedNodesNB == 0) {
            ErrorInBootingHardwareProcessException ex1 = new ErrorInBootingHardwareProcessException("NO HARDWARE DETECTED : POWER FAILURE ?", this.hardwareBootTimeout, this.bootedNodesNB, this.expectedNodesNB);
            log.error((Object)ex1.toString(), new String[0]);
            throw ex1;
        }
        if (this.bootedNodesNB != this.expectedNodesNB) {
            ErrorInBootingHardwareProcessException ex2 = new ErrorInBootingHardwareProcessException("SOME HARDWARE IS MISSING : POWER FAILURE ?", this.hardwareBootTimeout, this.bootedNodesNB, this.expectedNodesNB);
            log.error((Object)ex2.toString(), new String[0]);
            throw ex2;
        }
        this.canOpenNodeNumbersOK = true;
        boolean configNodesID = true;
        PieceOfHardware[] pieceOfHardwareArray = this.hardwareList;
        int n = this.hardwareList.length;
        int n2 = 0;
        while (n2 < n) {
            PieceOfHardware hardware = pieceOfHardwareArray[n2];
            log.info((Object)("ABOUT TO CHECK: " + hardware.getName() + " NODE_ID=" + hardware.getNodeID()), new String[0]);
            boolean configOK = this.checkCanOpenNodeConfiguration(hardware);
            configNodesID = configNodesID && configOK;
            log.info((Object)(String.valueOf(hardware.getName()) + " CONFIG OK=" + configOK), new String[0]);
            ++n2;
        }
        return configNodesID;
    }

    public boolean checkCanOpenNodeConfiguration(PieceOfHardware pieceOfHardware) throws BadCommandException, HardwareConfigurationException, HardwareNotDetectedException {
        if (!this.hardwareBootProcessEnded || !this.hardwareIdentified) {
            throw new BadCommandException("Hardware not booted or not identified");
        }
        if (this.bootedNodesNB == 0) {
            return false;
        }
        log.info((Object)("Checking configuration for " + pieceOfHardware.getName()), new String[0]);
        boolean serialNBFound = false;
        boolean nodeIDFound = false;
        String bootedNodeForSerial = null;
        String bootedSerialForNode = null;
        int i = 0;
        while (i < this.bootedNodesNB) {
            if (this.nodes[i] != null && this.nodes[i].getNodeID().equalsIgnoreCase(pieceOfHardware.getNodeID())) {
                nodeIDFound = true;
                bootedSerialForNode = this.nodes[i].getSerialNB();
            }
            if (this.nodes[i] != null && this.nodes[i].getSerialNB().equalsIgnoreCase(pieceOfHardware.getSerialNB())) {
                serialNBFound = true;
                bootedNodeForSerial = this.nodes[i].getNodeID();
            }
            ++i;
        }
        if (!nodeIDFound && !serialNBFound) {
            this.getSubsystem().updateState(State.InError, " Possible power failure for node ID: " + pieceOfHardware.getNodeID());
            HardwareNotDetectedException ex = new HardwareNotDetectedException("HARDWARE NOT DETECTED", pieceOfHardware.getName(), pieceOfHardware.getNodeID(), pieceOfHardware.getSerialNB());
            log.error((Object)ex.toString(), new String[0]);
            throw ex;
        }
        if (nodeIDFound && !serialNBFound) {
            log.error((Object)("Serial number found for this can open node id =" + bootedSerialForNode), new String[0]);
            String msg = String.format(" Serial number %s associated to %s was not found on the Can Open Bus, Serial number found for node id %s = %s", pieceOfHardware.getSerialNB(), pieceOfHardware.getName(), pieceOfHardware.getNodeID(), bootedSerialForNode);
            throw new HardwareConfigurationException(msg, pieceOfHardware);
        }
        if (!nodeIDFound && serialNBFound) {
            log.error((Object)(String.valueOf(pieceOfHardware.toString()) + " has a wrong node ID on the Can Open Bus :" + bootedNodeForSerial), new String[0]);
            String msg = String.format(" NodeID %s associated to %s was not found on the Can Open Bus, NodeID found for serialNB %s = %s", pieceOfHardware.getNodeID(), pieceOfHardware.getName(), pieceOfHardware.getSerialNB(), bootedNodeForSerial);
            throw new HardwareConfigurationException(msg, pieceOfHardware);
        }
        if (nodeIDFound && serialNBFound) {
            if (pieceOfHardware.getNodeID().equals(bootedNodeForSerial) && pieceOfHardware.getSerialNB().equals(bootedSerialForNode)) {
                log.info((Object)(String.valueOf(pieceOfHardware.getName()) + " is booted :" + pieceOfHardware.toString()), new String[0]);
                return true;
            }
            log.error((Object)(String.valueOf(pieceOfHardware.toString()) + " does not match hardware on the Can Open Bus"), new String[0]);
            throw new NodeIDMismatchException(" ERROR in HARDWARE CONFIGURATION", pieceOfHardware, bootedNodeForSerial, bootedSerialForNode);
        }
        return false;
    }

    public String listHardware() {
        StringBuilder sb = new StringBuilder();
        PieceOfHardware[] pieceOfHardwareArray = this.hardwareList;
        int n = this.hardwareList.length;
        int n2 = 0;
        while (n2 < n) {
            PieceOfHardware pieceOfHardware = pieceOfHardwareArray[n2];
            sb.append(pieceOfHardware.toString());
            sb.append("**");
            ++n2;
        }
        return sb.toString();
    }

    public String initializeHardware() throws BadCommandException, Exception {
        if (!this.hardwareIdentified || !this.canOpenNodesChecked) {
            throw new BadCommandException("Hardware not identified yet or can open nodes have not beeen checked.");
        }
        boolean noError = true;
        StringBuilder err = new StringBuilder();
        PieceOfHardware[] pieceOfHardwareArray = this.hardwareList;
        int n = this.hardwareList.length;
        int n2 = 0;
        while (n2 < n) {
            PieceOfHardware pieceOfHardware = pieceOfHardwareArray[n2];
            try {
                pieceOfHardware.initializeHardware();
            }
            catch (Exception ex) {
                noError = false;
                err.append(ex.getMessage());
            }
            ++n2;
        }
        if (noError) {
            this.hardwareInitialized = true;
            return "All pieces of hardware are initialized";
        }
        throw new Exception(err.toString());
    }

    public String configAsHeartbeatProducer(String nodeID, String heartbeat_time) throws SDORequestException, TimeoutException, BadCommandException {
        return this.writeSDO(nodeID, "1017", "0", "2", heartbeat_time);
    }

    public String configAsHeartbeatProducer(int nodeID, int heartbeat_time) throws SDORequestException, TimeoutException, BadCommandException {
        if (heartbeat_time < 0 || heartbeat_time > 65025) {
            throw new IllegalArgumentException("heartbeat_time is coded on 2 bytes can't be > 65535");
        }
        return this.configAsHeartbeatProducer(Integer.toHexString(nodeID), Integer.toHexString(heartbeat_time));
    }

    public String configAsHeartbeatConsumer(int nodeID, int producerNodeID, int heartbeat_time) throws SDORequestException, TimeoutException, BadCommandException {
        if (nodeID < 0 || nodeID > 127) {
            throw new IllegalArgumentException("nodeID must be > 0 and < 128");
        }
        if (producerNodeID < 0 || producerNodeID > 127) {
            throw new IllegalArgumentException("producerNodeID must be > 0 and < 128");
        }
        if (heartbeat_time < 0 || heartbeat_time > 65025) {
            throw new IllegalArgumentException("heartbeat_time is coded on 2 bytes can't be > 65535");
        }
        String value = String.valueOf(String.format("%04x", producerNodeID)) + String.format("%04x", heartbeat_time);
        return this.writeSDO(Integer.toHexString(nodeID), "1016", "1", "4", value);
    }

    public static class PDOStorage {
        String sep = "_";
        String varSuffixe = "ADC";
        private HashMap<String, String> mapSensorsValues = new HashMap();

        void updatePDOs(String pdoLine) {
            String[] words = pdoLine.split(",");
            int ix = 1;
            while (ix < words.length) {
                String[] toStore = words[ix].split("=");
                String varName = toStore[0];
                String varValue = toStore[1];
                String[] mots = varName.split(this.sep);
                String nodeID = mots[0].substring(3);
                String cfr_ignored_0 = String.valueOf(nodeID) + this.sep + mots[1];
                this.mapSensorsValues.put(varName, varValue);
                ++ix;
            }
        }

        public String getVarValue(String nodeID, String inputNB) {
            String token = String.valueOf(this.varSuffixe) + nodeID + this.sep + inputNB;
            return this.mapSensorsValues.get(token);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PDO STORAGE:");
            sb.append("(SIZE=").append(this.mapSensorsValues.size()).append(")");
            sb.append(this.mapSensorsValues.toString());
            return sb.toString();
        }
    }
}

