/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.subsystems.fcs.FcsAlarm;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

public class CanOpenPlutoGateway
extends CanOpenDevice {
    String[] hexaValues = new String[2];

    public CanOpenPlutoGateway(String aName, int aTickMillis, String nodeID, String serialNB) {
        super(aName, aTickMillis, nodeID, serialNB);
    }

    @Override
    public String initializeHardware() throws SDORequestException, ErrorInCommandExecutionException {
        return String.valueOf(this.getName()) + "nothing to do";
    }

    public String configure() throws SDORequestException, ErrorInCommandExecutionException {
        String goodAck;
        String ack = this.writeSDO("2002", "01", "01", "04");
        if (!ack.equals(goodAck = "OK")) {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + " :bad returned ack for wsdo, index 2002");
        }
        return String.valueOf(this.getName()) + " is configured.";
    }

    public String writeTransmissionType(String transmissionType) throws SDORequestException, ErrorInCommandExecutionException, BadCommandException {
        String goodAck;
        if (transmissionType == null) {
            throw new BadCommandException(String.valueOf(this.getName()) + ": Can't write transmission type to device because transmaission type is null.");
        }
        String ack = this.tcpProxy.writeSDO(this.nodeID, "2005", "1", "1", transmissionType);
        if (!ack.equals(goodAck = "OK")) {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + " :bad returned ack for wsdo, index 1801");
        }
        return String.format("Transmission type of device %s is now %s", this.name, transmissionType);
    }

    public String[] readNewHexaValues() {
        try {
            this.hexaValues[0] = this.tcpProxy.readSDO(this.nodeID, "6000", "03");
            log.debug((Object)String.format("%s : first byte read in hexaValue= %s", this.getName(), this.hexaValues[0]), new String[0]);
            this.hexaValues[1] = this.tcpProxy.readSDO(this.nodeID, "6000", "04");
            log.debug((Object)String.format("%s : second byte read in hexaValue= %s", this.getName(), this.hexaValues[1]), new String[0]);
            return this.hexaValues;
        }
        catch (SDORequestException ex) {
            String message = String.valueOf(this.getName()) + ": ERROR IN READING SENSOR";
            log.error((Object)message, new String[0]);
            FcsAlarm alarm = new FcsAlarm(ex.toString());
            this.sendToStatus((Status)alarm);
            return null;
        }
    }
}

