/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.subsystems.fcs.NumericSensor;

public class CanOpenNumericSensor
extends NumericSensor {
    String dioName;
    int inputNumero;

    public CanOpenNumericSensor(String aName, String dioName, int inputNumero) {
        super(aName);
        this.dioName = dioName;
        this.inputNumero = inputNumero;
    }

    public int getInputNumero() {
        return this.inputNumero;
    }

    public void setInputNumero(int inputNumero) {
        this.inputNumero = inputNumero;
    }

    @Override
    public synchronized void updateValue(String hex) {
        int myValue;
        String bin = Integer.toBinaryString(Integer.parseInt(hex, 16));
        String s = String.format("%08d", Integer.parseInt(bin));
        this.digitalValue = myValue = Character.digit(s.charAt(8 - this.inputNumero), 16);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("/Digital Input Output module=");
        sb.append(this.dioName);
        sb.append("/Input numero=");
        sb.append(this.inputNumero);
        sb.append("/");
        return sb.toString();
    }

    public static void main(String[] args) {
        CanOpenNumericSensor sensor1 = new CanOpenNumericSensor("sensor1", "GW", 1);
        sensor1.updateValue("79");
        System.out.println("valeur de sensor1=" + sensor1.digitalValue);
        CanOpenNumericSensor sensor2 = new CanOpenNumericSensor("sensor2", "GW", 2);
        sensor2.updateValue("79");
        System.out.println("valeur de sensor2=" + sensor2.digitalValue);
        CanOpenNumericSensor sensor3 = new CanOpenNumericSensor("sensor3", "GW", 3);
        sensor3.updateValue("79");
        System.out.println("valeur de sensor3=" + sensor3.digitalValue);
        CanOpenNumericSensor sensor4 = new CanOpenNumericSensor("sensor4", "GW", 4);
        sensor4.updateValue("79");
        System.out.println("valeur de sensor4=" + sensor4.digitalValue);
        CanOpenNumericSensor sensor5 = new CanOpenNumericSensor("sensor5", "GW", 5);
        sensor5.updateValue("79");
        System.out.println("valeur de sensor5=" + sensor5.digitalValue);
        CanOpenNumericSensor sensor6 = new CanOpenNumericSensor("sensor6", "GW", 6);
        sensor6.updateValue("79");
        System.out.println("valeur de sensor6=" + sensor6.digitalValue);
        CanOpenNumericSensor sensor7 = new CanOpenNumericSensor("sensor7", "GW", 7);
        sensor7.updateValue("79");
        System.out.println("valeur de sensor7=" + sensor7.digitalValue);
        CanOpenNumericSensor sensor8 = new CanOpenNumericSensor("sensor8", "GW", 8);
        sensor8.updateValue("79");
        System.out.println("valeur de sensor8=" + sensor8.digitalValue);
        String hex = "79";
        String bin = Integer.toBinaryString(Integer.parseInt(hex, 16));
        System.out.println(bin);
        String s = String.format("%08d", Integer.parseInt(bin));
        System.out.println("s=" + s);
    }
}

