/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

public class CanOpenDAC
extends CanOpenDevice {
    public static final double bitOverVolts = 3210.27287;

    public CanOpenDAC(String aName, int aTickMillis, String nodeID, String serialNB) {
        super(aName, aTickMillis, nodeID, serialNB);
    }

    public void writeAnalogOutput(int inputNB, int value) throws SDORequestException, HardwareNotDetectedException {
        if (!this.tcpProxy.isBooted(this)) {
            String message = String.format("DAC %s / nodeID=%s is NOT BOOTED", this.getName(), this.nodeID);
            log.error((Object)message, new String[0]);
            throw new HardwareNotDetectedException("CanOpenDAC is MISSING", this.getName(), this.nodeID, this.serialNB);
        }
        if (inputNB < 1 || inputNB > 4) {
            throw new IllegalArgumentException("CAN-CBX-AO412 : input has to be 1..4");
        }
        String valueInHexa = Integer.toHexString(value);
        String inputNBInHexa = Integer.toHexString(inputNB);
        this.tcpProxy.writeSDO(this.nodeID, "6411", inputNBInHexa, "2", valueInHexa);
    }
}

