/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.FcsAlarm;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;

public abstract class MobileItemModule
extends Module {
    protected volatile boolean itemMoving = false;
    protected final Lock lock = new ReentrantLock();
    protected final Condition motionCompleted = this.lock.newCondition();
    ScheduledFuture<?> readSensorsHandle;
    final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);

    public MobileItemModule(String moduleName, int aTickMillis) {
        super(moduleName, aTickMillis);
    }

    private void cancelReadingSensors() {
        this.lock.lock();
        try {
            log.info((Object)" => Stop reading sensors", new String[0]);
            this.motionCompleted.signal();
        }
        finally {
            this.lock.unlock();
        }
        this.readSensorsHandle.cancel(true);
        log.info((Object)"readingSensors canceled", new String[0]);
    }

    public abstract boolean isActionCompleted(FcsEnumerations.MobileItemAction var1);

    public abstract void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception;

    public abstract void startAction(FcsEnumerations.MobileItemAction var1) throws BadCommandException, ErrorInCommandExecutionException, HardwareException;

    public abstract void postAction(FcsEnumerations.MobileItemAction var1) throws BadCommandException, ErrorInCommandExecutionException, HardwareException;

    protected String executeAction(FcsEnumerations.MobileItemAction action, long timeoutForAction) throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        this.lock.lock();
        try {
            this.itemMoving = true;
            this.startAction(action);
            this.readSensorsUntilActionIsCompleted(action, System.currentTimeMillis(), timeoutForAction);
            this.waitForEndOfAction(action);
            if (this.isActionCompleted(action)) {
                this.postAction(action);
                String string = String.valueOf(this.getName()) + " " + action.doneString();
                return string;
            }
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + ": " + action.getFailureMsg());
        }
        finally {
            this.itemMoving = false;
            this.motionCompleted.signal();
            this.lock.unlock();
        }
    }

    public void readSensorsUntilActionIsCompleted(final FcsEnumerations.MobileItemAction action, final long beginTime, final long timeout) {
        Runnable readSensors = new Runnable(){

            @Override
            public void run() {
                try {
                    log.info((Object)"Socket at standby : Reading sensors", new String[0]);
                    long duration = System.currentTimeMillis() - beginTime;
                    MobileItemModule.this.updateStateWithSensorsToCheckIfActionIsCompleted();
                    boolean actionCompleted = MobileItemModule.this.isActionCompleted(action);
                    if (!actionCompleted && duration < timeout) {
                        log.info((Object)(String.valueOf(action.toString()) + " not completed....."), new String[0]);
                        log.info((Object)(String.valueOf(action.name()) + "/duration=" + duration), new String[0]);
                    } else if (actionCompleted) {
                        MobileItemModule.this.itemMoving = false;
                        log.info((Object)(String.valueOf(action.toString()) + " ACTION COMPLETED"), new String[0]);
                        MobileItemModule.this.cancelReadingSensors();
                    } else if (duration >= timeout) {
                        MobileItemModule.this.itemMoving = false;
                        log.info((Object)(String.valueOf(action.toString()) + " ACTION NOT COMPLETED during allocated time"), new String[0]);
                        MobileItemModule.this.cancelReadingSensors();
                        throw new TimeoutException(String.valueOf(action.toString()) + " lasted longer than timeout for this task: duration=" + duration + ",timeout=" + timeout);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)("ERROR during action:" + ex.getMessage()), new String[0]);
                    ex.printStackTrace();
                    FcsAlarm alarm = new FcsAlarm(ex.toString());
                    MobileItemModule.this.sendToStatus((Status)alarm);
                    MobileItemModule.this.cancelReadingSensors();
                }
            }
        };
        this.readSensorsHandle = this.scheduler.scheduleAtFixedRate(readSensors, 500L, 500L, TimeUnit.MILLISECONDS);
    }

    private void waitForEndOfAction(FcsEnumerations.MobileItemAction action) {
        while (this.itemMoving) {
            try {
                log.info((Object)("Waiting for end of " + action.toString()), new String[0]);
                this.motionCompleted.await();
            }
            catch (InterruptedException interruptedException) {}
        }
        log.info((Object)"STOP WAITING", new String[0]);
        log.info((Object)(String.valueOf(action.toString()) + " IS COMPLETED NOW"), new String[0]);
    }

    public void shutdownNow() {
        super.shutdownNow();
        this.scheduler.shutdown();
    }
}

