/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarrierModule;
import org.lsst.ccs.subsystems.fcs.LoaderClampModule;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;

public class LoaderModule
extends Module {
    CarrierModule carrier;
    LoaderClampModule clamp;
    AutoChangerModule autochanger;
    boolean loaderEmpty;
    boolean loaderConnected;
    protected NumericSensor filterPresenceSensor;
    protected NumericSensor loaderOnCameraPresenceSensor;

    public LoaderModule(String moduleName, int aTickMillis, CarrierModule carrier, LoaderClampModule clamp) {
        super(moduleName, aTickMillis);
        this.carrier = carrier;
        this.clamp = clamp;
    }

    public boolean isEmpty() {
        return this.loaderEmpty;
    }

    public LoaderClampModule getClamp() {
        return this.clamp;
    }

    public void initModule() {
        this.autochanger = (AutoChangerModule)this.getModule("autochanger");
    }

    public void initializeHardware() throws HardwareException, ErrorInCommandExecutionException, BadCommandException {
        this.updateStateWithSensors();
        this.clamp.initializeHardware();
        this.carrier.initialiazeHardware();
    }

    public void updateStateWithSensors() throws HardwareException, ErrorInCommandExecutionException {
        this.updateHookStateWithSensors();
        this.updateCarrierStateWithSensors();
    }

    public void lockHooks() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        this.clamp.close();
    }

    public void clampHooks() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        this.clamp.clamp();
    }

    public void unlockHooks() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        this.clamp.open();
    }

    void moveToHandoff() {
        this.carrier.goToHandOff();
    }

    void moveToStorage() {
        this.carrier.goToStorage();
    }

    private void updateHookStateWithSensors() {
        this.clamp.updateStateWithSensors();
    }

    public void updateCarrierStateWithSensors() {
        this.carrier.updateStateWithSensors();
    }

    public String listHooks() {
        return this.clamp.listHooks();
    }

    public String listSensorsValues() {
        return this.clamp.listSensorsValues();
    }
}

