/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.Map;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Hook;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenPlutoGateway;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;

public class LoaderClampModule
extends MobileItemModule {
    public CanOpenEPOS hooksController;
    public Hook hook1;
    public Hook hook2;
    public Hook hook3;
    public Hook hook4;
    CanOpenPlutoGateway plutoGateway;
    FcsEnumerations.LockStatus lockStatus;
    long timeoutForClosingHooks;
    long timeoutForClosingHooksStrongly;
    long timeoutForOpeningHooks;
    long timeoutForGoingToHomePosition;
    private volatile boolean initialized;
    final Condition stateUpdated;
    protected volatile boolean updatingState;
    int targetPositionToOpen;
    int targetPositionToClose;
    int targetPositionToCloseStrongly;
    int currentToClose;
    int currentToGoHome;
    Map<String, Integer> paramsForCurrentToGoHome;
    Map<String, Integer> paramsForCurrentToClose;

    public LoaderClampModule(String moduleName, int aTickMillis, long timeoutForClosingHooks, long timeoutForClosingHooksStrongly, long timeoutForOpeningHooks, long timeoutForGoingToHomePosition, int targetPositionToOpen, int targetPositionToClose, int targetPositionToCloseStrongly, int currentToClose, int currentToGoHome, Map<String, Integer> paramsForCurrentToClose, Map<String, Integer> paramsForCurrentToGoHomePosition, Hook hook1, Hook hook2, Hook hook3, Hook hook4) {
        super(moduleName, aTickMillis);
        this.stateUpdated = this.lock.newCondition();
        this.updatingState = false;
        this.initialized = false;
        this.timeoutForClosingHooks = timeoutForClosingHooks;
        this.timeoutForClosingHooksStrongly = timeoutForClosingHooksStrongly;
        this.timeoutForOpeningHooks = timeoutForOpeningHooks;
        this.timeoutForGoingToHomePosition = timeoutForGoingToHomePosition;
        this.targetPositionToOpen = targetPositionToOpen;
        this.targetPositionToClose = targetPositionToClose;
        this.targetPositionToCloseStrongly = targetPositionToCloseStrongly;
        this.currentToClose = currentToClose;
        this.currentToGoHome = currentToGoHome;
        this.paramsForCurrentToClose = paramsForCurrentToClose;
        this.paramsForCurrentToGoHome = paramsForCurrentToGoHomePosition;
        this.hook1 = hook1;
        this.hook2 = hook2;
        this.hook3 = hook3;
        this.hook4 = hook4;
    }

    /*
     * Exception decompiling
     */
    public FcsEnumerations.LockStatus getLockStatus() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isLocked() {
        return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.LOCKED);
    }

    public boolean isUnlocked() {
        return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.UNLOCKED);
    }

    public boolean isEmpty() {
        return ((LoaderModule)this.getModule("loader")).isEmpty();
    }

    public void initModule() {
        this.hooksController = (CanOpenEPOS)this.getModule("hooksActuator");
        this.plutoGateway = (CanOpenPlutoGateway)this.getModule("plutoGateway");
    }

    public void initializeHardware() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        this.updateStateWithSensors();
        if (this.isEmpty()) {
            this.goToHomePosition();
            this.hooksController.defineAbsolutePosition(0);
            this.initialized = true;
        } else {
            this.goToClosePosition();
            this.hooksController.defineAbsolutePosition(this.targetPositionToCloseStrongly);
            this.initialized = true;
        }
    }

    public String goToClosePosition() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        if (this.isEmpty()) {
            throw new BadCommandException(String.valueOf(this.getName()) + " can't go to close position if it's empty.");
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.GOTOCLOSEPOSITION, this.timeoutForClosingHooksStrongly);
    }

    public String goToHomePosition() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        if (!this.isEmpty()) {
            throw new BadCommandException(String.valueOf(this.getName()) + " can't go to home position if not empty.");
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.GOTOHOMEPOSITION, this.timeoutForGoingToHomePosition);
    }

    public String close() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        if (!this.initialized) {
            throw new BadCommandException(String.valueOf(this.getName()) + " is not intialized. PLease initialize hardware first.");
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.CLOSELOADERHOOKS, this.timeoutForClosingHooks);
    }

    public String clamp() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        if (!this.initialized) {
            throw new BadCommandException(String.valueOf(this.getName()) + " is not intialized. PLease initialize hardware first.");
        }
        if (!this.isLocked()) {
            throw new BadCommandException(String.valueOf(this.getName()) + " has to be LOCKED first. close hooks prior closeStrongly");
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.CLOSELOADERHOOKSTRONGLY, this.timeoutForClosingHooksStrongly);
    }

    public String open() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        if (!this.initialized) {
            throw new BadCommandException(String.valueOf(this.getName()) + " is not intialized. PLease initialize hardware first.");
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.OPENLOADERHOOKS, this.timeoutForOpeningHooks);
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case GOTOCLOSEPOSITION: {
                return this.lockStatus.equals((Object)FcsEnumerations.LockStatus.STRONGLYLOCKED);
            }
            case GOTOHOMEPOSITION: {
                return this.lockStatus.equals((Object)FcsEnumerations.LockStatus.UNLOCKED);
            }
            case CLOSELOADERHOOKS: {
                return this.lockStatus.equals((Object)FcsEnumerations.LockStatus.LOCKED);
            }
            case CLOSELOADERHOOKSTRONGLY: {
                return this.lockStatus.equals((Object)FcsEnumerations.LockStatus.STRONGLYLOCKED);
            }
            case OPENLOADERHOOKS: {
                return this.lockStatus.equals((Object)FcsEnumerations.LockStatus.UNLOCKED);
            }
        }
        return false;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        this.updateStateWithSensors();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        switch (action) {
            case GOTOCLOSEPOSITION: {
                this.hooksController.changeMode(CanOpenEPOS.EposMode.CURRENT);
                this.hooksController.writeParameters(this.paramsForCurrentToClose);
                this.hooksController.writeCurrent(this.currentToClose);
                this.hooksController.on();
                break;
            }
            case GOTOHOMEPOSITION: {
                this.hooksController.changeMode(CanOpenEPOS.EposMode.CURRENT);
                this.hooksController.writeParameters(this.paramsForCurrentToGoHome);
                this.hooksController.writeCurrent(this.currentToGoHome);
                this.hooksController.on();
                break;
            }
            case CLOSELOADERHOOKS: {
                this.hooksController.changeMode(CanOpenEPOS.EposMode.PROFILE_POSITION);
                this.hooksController.writeParameters(CanOpenEPOS.EposMode.PROFILE_POSITION);
                this.hooksController.writeTargetPosition(this.targetPositionToClose);
                this.hooksController.on();
                break;
            }
            case CLOSELOADERHOOKSTRONGLY: {
                if (!this.lockStatus.equals((Object)FcsEnumerations.LockStatus.LOCKED)) {
                    throw new BadCommandException(String.valueOf(this.getName()) + ": Hooks have to be LOCKED before being LOCKED STRONGLY");
                }
                this.hooksController.writeTargetPosition(this.targetPositionToCloseStrongly);
                this.hooksController.on();
                break;
            }
            case OPENLOADERHOOKS: {
                this.hooksController.changeMode(CanOpenEPOS.EposMode.PROFILE_POSITION);
                this.hooksController.writeParameters(CanOpenEPOS.EposMode.PROFILE_POSITION);
                this.hooksController.writeTargetPosition(this.targetPositionToOpen);
                this.hooksController.on();
            }
        }
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        switch (action) {
            case CLOSELOADERHOOKS: {
                break;
            }
            case CLOSELOADERHOOKSTRONGLY: {
                break;
            }
        }
    }

    public void updateStateWithSensors() {
        this.lock.lock();
        this.updatingState = true;
        try {
            boolean unlocked;
            String[] readHexaValues = this.plutoGateway.readNewHexaValues();
            this.hook1.updateStateWithSensors(readHexaValues);
            this.hook2.updateStateWithSensors(readHexaValues);
            this.hook3.updateStateWithSensors(readHexaValues);
            this.hook4.updateStateWithSensors(readHexaValues);
            boolean inError = this.hook1.getLockStatus() == FcsEnumerations.LockStatus.ERROR || this.hook2.getLockStatus() == FcsEnumerations.LockStatus.ERROR || this.hook3.getLockStatus() == FcsEnumerations.LockStatus.ERROR || this.hook4.getLockStatus() == FcsEnumerations.LockStatus.ERROR;
            boolean locked = this.hook1.getLockStatus() == FcsEnumerations.LockStatus.LOCKED && this.hook2.getLockStatus() == FcsEnumerations.LockStatus.LOCKED && this.hook3.getLockStatus() == FcsEnumerations.LockStatus.LOCKED && this.hook4.getLockStatus() == FcsEnumerations.LockStatus.LOCKED;
            boolean bl = unlocked = this.hook1.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED && this.hook2.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED && this.hook3.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED && this.hook4.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED;
            if (locked && unlocked) {
                inError = true;
            }
            this.lockStatus = inError ? FcsEnumerations.LockStatus.ERROR : (locked ? FcsEnumerations.LockStatus.LOCKED : (unlocked ? FcsEnumerations.LockStatus.UNLOCKED : FcsEnumerations.LockStatus.UNKNOWN));
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
        }
    }

    public String listHooks() {
        StringBuilder sb = new StringBuilder("Hooks status:");
        sb.append("\n");
        sb.append(this.hook1.toString());
        sb.append("\n");
        sb.append(this.hook2.toString());
        sb.append("\n");
        sb.append(this.hook3.toString());
        sb.append("\n");
        sb.append(this.hook4.toString());
        sb.append("\n");
        return sb.toString();
    }

    public String listSensorsValues() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.hook1.listSensorsValues());
        sb.append(this.hook2.listSensorsValues());
        sb.append(this.hook3.listSensorsValues());
        sb.append(this.hook4.listSensorsValues());
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("/timeoutForClosingHooks=");
        sb.append(this.timeoutForClosingHooks);
        sb.append("/timeoutForClosingHooksStrongly=");
        sb.append(this.timeoutForClosingHooksStrongly);
        sb.append("/timeoutForOpeningHooks=");
        sb.append(this.timeoutForOpeningHooks);
        return sb.toString();
    }
}

