/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.drivers.BridgeToCanOpenHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS24;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenPlutoGateway;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

public class CPPMTestBenchMainModule
extends Module {
    BridgeToCanOpenHardware bridge;
    CanOpenPlutoGateway plutoGW;
    CanOpenEPOS24 epos;

    public CPPMTestBenchMainModule(String aName, int aTickMillis, BridgeToCanOpenHardware aBridge) {
        super(aName, aTickMillis);
        this.bridge = aBridge;
    }

    public void initModule() {
        super.initModule();
        this.plutoGW = (CanOpenPlutoGateway)this.getModule("plutoGW");
        this.epos = (CanOpenEPOS24)this.getModule("epos");
    }

    public String readSensors() throws HardwareException {
        String hexaValue = this.plutoGW.readSDO("6004", "03");
        String bin = Integer.toBinaryString(Integer.parseInt(hexaValue, 16));
        System.out.println(bin);
        return bin;
    }

    public String enableEPOS() throws SDORequestException {
        this.epos.enable();
        return String.valueOf(this.epos.getName()) + " is enable";
    }
}

