/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.Thermometer;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.ReadingADCException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.testbench.CanOpenLED;

public class APCTestBenchMainModule
extends Module {
    private BridgeToHardware bridge;
    private Thermometer thermometer;
    private CanOpenLED led;
    private CanOpenLED fakeLed;
    private Thermometer fakeSensor;
    public double temperature;

    public BridgeToHardware getBridge() {
        return this.bridge;
    }

    public void setBridge(BridgeToHardware bridge) {
        this.bridge = bridge;
    }

    public Thermometer getThermometer() {
        return this.thermometer;
    }

    public void setThermometer(Thermometer thermometer) {
        this.thermometer = thermometer;
    }

    public CanOpenLED getLed() {
        return this.led;
    }

    public void setLed(CanOpenLED led) {
        this.led = led;
    }

    public CanOpenLED getFakeLed() {
        return this.fakeLed;
    }

    public void setFakeLed(CanOpenLED fakeLed) {
        this.fakeLed = fakeLed;
    }

    public Thermometer getFakeSensor() {
        return this.fakeSensor;
    }

    public void setFakeSensor(Thermometer fakeSensor) {
        this.fakeSensor = fakeSensor;
    }

    public int getReturnValue(String responseLine, int inputNB) throws ReadingADCException {
        if (inputNB < 1 || inputNB > 8) {
            throw new IllegalArgumentException();
        }
        String[] words = responseLine.split(",");
        log.debug((Object)("Value in HEXA:" + words[inputNB]), new String[0]);
        int value = Integer.parseInt(words[inputNB], 16);
        log.debug((Object)("Value in decimal:" + words[inputNB]), new String[0]);
        return value;
    }

    public double readTemperature() throws HardwareException {
        return this.thermometer.readTemperature();
    }

    public double readTemperatureFromPDO() throws HardwareException, BadCommandException {
        CanOpenProxy.PDOStorage pdoStore = this.bridge.readPDOs();
        return this.thermometer.readTemperatureWithPDO(pdoStore);
    }

    public String turnOnLED() throws SDORequestException, HardwareNotDetectedException {
        return this.led.turnON();
    }

    public String turnOffLED() throws SDORequestException, HardwareNotDetectedException {
        return this.led.turnOFF();
    }

    public String turnOnFakeLED() throws SDORequestException, HardwareNotDetectedException {
        return this.fakeLed.turnON();
    }

    public String turnOffFakeLED() throws SDORequestException, HardwareNotDetectedException {
        return this.fakeLed.turnOFF();
    }

    public double readFakeSensor() throws HardwareException, BadCommandException {
        CanOpenProxy.PDOStorage pdoStore = this.bridge.readPDOs();
        return this.fakeSensor.readTemperatureWithPDO(pdoStore);
    }

    public void initModule() {
        String channelName = "temperature";
        String tempLow = String.valueOf(20.0);
        String tempHigh = String.valueOf(25.0);
        this.getSubsystem().publishMetaData(channelName, "tempLow", tempLow);
        this.getSubsystem().publishMetaData(channelName, "tempHigh", tempHigh);
        this.getSubsystem().publishMetaData("fakeTemperature", "fakeTempLow", tempLow);
        this.getSubsystem().publishMetaData("fakeTemperature", "fakeTempHigh", tempHigh);
        this.getSubsystem().publishMetaData("bidon", "ici", "maintenant");
    }

    public void tick() {
    }
}

