/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.lsst.ccs.subsystems.fcs.errors.DeploymentException;
import org.lsst.ccs.utilities.logging.Logger;

public class CanOpenErrorsTable {
    protected static final Logger log = Logger.getLogger((String)"lsst.ccs.framework");
    static Properties deviceErrorCodes = new Properties();
    static final String DEVICE_ERROR_CODES_FILENAME = "/maxonMotorDeviceErrors.properties";
    static InputStream deviceErrorFile = CanOpenErrorsTable.class.getResourceAsStream("/maxonMotorDeviceErrors.properties");
    static Properties errorRegisterCodes = new Properties();
    static final String ERROR_REGISTER_CODES_FILENAME = "/errorRegister.properties";
    static InputStream errorRegisterFile = CanOpenErrorsTable.class.getResourceAsStream("/errorRegister.properties");
    static Properties commErrorCodes = new Properties();
    static final String COMM_ERROR_CODES_FILENAME = "/commErrors.properties";
    static InputStream commErrorFile = CanOpenErrorsTable.class.getResourceAsStream("/commErrors.properties");

    public static void loadDeviceErrorTable() throws DeploymentException {
        try {
            log.debug((Object)("DEVICE ERROR TABLE= " + deviceErrorFile.toString()), new String[0]);
            deviceErrorCodes.load(deviceErrorFile);
            int size = deviceErrorCodes.size();
            log.debug((Object)("Size of the maxon device error codes table = " + size), new String[0]);
        }
        catch (IOException ex) {
            throw new DeploymentException("Error in reading file: /maxonMotorDeviceErrors.properties" + ex.getMessage());
        }
    }

    public static String getDeviceErrorNameByCode(String aCode) {
        log.debug((Object)deviceErrorCodes.getProperty(aCode.toUpperCase()), new String[0]);
        return deviceErrorCodes.getProperty(aCode.toUpperCase());
    }

    public static void loadErrorRegisterTable() throws DeploymentException {
        try {
            log.debug((Object)("ERROR REGISTER TABLE=" + errorRegisterFile.toString()), new String[0]);
            errorRegisterCodes.load(errorRegisterFile);
            int size = errorRegisterCodes.size();
            log.debug((Object)("Size of the error register codes table = " + size), new String[0]);
        }
        catch (IOException ex) {
            throw new DeploymentException("Error in reading file: /errorRegister.properties" + ex.getMessage());
        }
    }

    public static void loadCommunicationErrorTable() throws DeploymentException {
        try {
            log.debug((Object)("COMMUNICATION ERROR TABLE=" + commErrorFile.toString()), new String[0]);
            commErrorCodes.load(commErrorFile);
            int size = commErrorCodes.size();
            log.debug((Object)("Size of the error register codes table = " + size), new String[0]);
        }
        catch (IOException ex) {
            throw new DeploymentException("Error in reading file: /commErrors.properties" + ex.getMessage());
        }
    }
}

