/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.common.Actuator;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.drivers.Motor;
import org.lsst.ccs.subsystems.fcs.errors.ClampMotorConfigurationException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

public class CanOpenEPOS
extends CanOpenDevice
implements Actuator {
    public boolean on;
    public int readValue;
    public int sentValue;
    protected EposMode mode;
    protected final Motor motor;
    final Lock lock = new ReentrantLock();
    final Condition enablingCompleted = this.lock.newCondition();
    protected volatile boolean enabling = false;

    @Override
    public boolean isOn() {
        return this.on;
    }

    @Override
    public boolean isOff() {
        return !this.on;
    }

    @Override
    public int getReadValue() {
        return this.readValue;
    }

    @Override
    public int getSentValue() {
        return this.sentValue;
    }

    @Override
    public int getSentCurrentMinValue() {
        return 0;
    }

    @Override
    public int getSentCurrentMaxValue() {
        return 3000;
    }

    public CanOpenEPOS(String aName, int aTickMillis, String nodeID, String serialNB, Motor aMotor, String aModeInString) {
        super(aName, aTickMillis, nodeID, serialNB);
        this.motor = aMotor;
        this.mode = EposMode.valueOf(aModeInString);
    }

    public int getMotor_continuousCurrentLimit() {
        return this.motor.getContinuousCurrentLimit();
    }

    public int getMotor_maxSpeedInCurrentMode() {
        return this.motor.getMaxSpeedInCurrentMode();
    }

    public int getMotor_outputCurrentLimit() {
        return this.motor.getOutputCurrentLimit();
    }

    public int getMotor_polePairNumber() {
        return this.motor.getPolePairNumber();
    }

    public int getMotor_thermalTimeConstantWinding() {
        return this.motor.getThermalTimeConstantWinding();
    }

    public int getMotor_type() {
        return this.motor.getMotorType();
    }

    public void updateReadValue() throws BadCommandException, SDORequestException {
        if (this.mode.equals((Object)EposMode.VELOCITY)) {
            this.readValue = this.readVelocity();
        } else if (this.mode.equals((Object)EposMode.CURRENT)) {
            this.readValue = this.readCurrent();
        } else {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not in VELOCITY or CURRENT mode");
        }
    }

    @Override
    public void initModule() {
        this.tcpProxy = (CanOpenProxy)this.getModule("tcpProxy");
        this.mode = EposMode.CURRENT;
    }

    @Override
    public String initializeHardware() throws Exception {
        this.initialized = true;
        return String.valueOf(this.getName()) + ": no hardware initialization for this device to be done.";
    }

    /*
     * Exception decompiling
     */
    public boolean isEnable() throws SDORequestException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void faultReset() throws SDORequestException {
        this.writeControlWord("80");
    }

    public String enable() throws SDORequestException {
        this.lock.lock();
        this.enabling = true;
        try {
            this.shutdown();
            this.switchOnEnableOperation();
            String string = String.valueOf(this.getName()) + " ENABLE";
            return string;
        }
        finally {
            this.enabling = false;
            this.enablingCompleted.signal();
            this.lock.unlock();
        }
    }

    public String shutdown() throws SDORequestException {
        this.writeControlWord("6");
        return String.valueOf(this.getName()) + " DISABLE";
    }

    public void switchOnEnableOperation() throws SDORequestException {
        this.writeControlWord("F");
    }

    public Object saveParameters() throws SDORequestException {
        return this.writeSDO("1010", "1", "4", "65766173");
    }

    public Object restoreParameters() throws SDORequestException {
        return this.writeSDO("1011", "1", "4", "64616F6C");
    }

    public void writeControlWord(String value) throws SDORequestException {
        this.writeSDO("6040", "0", "2", value);
    }

    public String readControlWord() throws SDORequestException {
        return this.readSDO("6040", "0");
    }

    public String readStatusWord() throws SDORequestException {
        return this.readSDO("6041", "0");
    }

    public void quickStop() throws SDORequestException {
        if (this.mode.equals((Object)EposMode.VELOCITY)) {
            this.writeControlWord("B");
        } else if (this.mode.equals((Object)EposMode.CURRENT)) {
            this.writeControlWord("2");
        }
    }

    @Override
    public String on() throws BadCommandException, ErrorInCommandExecutionException {
        try {
            this.enable();
            if (!this.isEnable()) {
                throw new BadCommandException("Actuator has to be enable prior ON command.");
            }
            if (this.mode.equals((Object)EposMode.VELOCITY)) {
                this.setVelocity();
            } else if (this.mode.equals((Object)EposMode.CURRENT)) {
                if (this.motor.getCurrentValue() == 0) {
                    throw new BadCommandException("A current value has to be set");
                }
                this.writeCurrent(this.motor.getCurrentValue());
            }
            this.on = true;
            this.sentValue = this.motor.getCurrentValue();
            this.updateReadValue();
            return String.valueOf(this.getName()) + " ON";
        }
        catch (SDORequestException ex) {
            log.error((Object)(String.valueOf(this.getName()) + " Can Open ERROR in sending the command ON."), new String[0]);
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + ": Error in command ON" + ex.toString());
        }
    }

    @Override
    public String off() throws BadCommandException, ErrorInCommandExecutionException {
        try {
            if (this.mode.equals((Object)EposMode.VELOCITY)) {
                this.stopVelocity();
                this.shutdown();
            } else if (this.mode.equals((Object)EposMode.CURRENT)) {
                this.stopCurrent();
                this.shutdown();
            }
            this.on = false;
            this.sentValue = 0;
            this.updateReadValue();
            return String.valueOf(this.getName()) + " OFF";
        }
        catch (SDORequestException ex) {
            log.error((Object)ex.getMessage(), new String[0]);
            throw new ErrorInCommandExecutionException(ex + "Error in reading SDO request");
        }
    }

    public void writeMotorParameters() throws SDORequestException {
        this.shutdown();
        this.writeMotorType(this.motor.getMotorType());
        this.writeMotorData("01", "2", this.motor.getContinuousCurrentLimit());
        this.writeMotorData("04", "4", this.motor.getMaxSpeedInCurrentMode());
        this.writeMotorData("05", "2", this.motor.getThermalTimeConstantWinding());
        this.writeMotorData("02", "2", this.motor.getOutputCurrentLimit());
        this.writeMotorData("03", "1", this.motor.getPolePairNumber());
        this.writePositionSensorType(this.motor.getPositionSensorType());
    }

    public void writeMotorType(int value) throws SDORequestException {
        String typeInHexa = Integer.toHexString(value);
        this.writeSDO("6402", "0", "2", typeInHexa);
    }

    public int readMotorType() throws SDORequestException {
        String motorTypeInHexa = this.readSDO("6402", "0");
        return Integer.parseInt(motorTypeInHexa, 16);
    }

    public int readPositionSensorType() throws SDORequestException {
        String positionSensorTypeInHexa = this.readSDO("2210", "02");
        return Integer.parseInt(positionSensorTypeInHexa, 16);
    }

    public void writePositionSensorType(int value) throws SDORequestException {
        this.motor.setPositionSensorType(value);
        String valueInHexa = Integer.toHexString(value);
        this.writeSDO("2210", "2", "2", valueInHexa);
    }

    public void writeMaxSpeed(int value) throws SDORequestException {
        this.motor.setMaxSpeedInCurrentMode(value);
        this.writeMotorData("4", "4", value);
    }

    protected void writeMotorData(String subindex, String sizeInHexa, int value) throws SDORequestException {
        String valueInHexa = Integer.toHexString(value);
        this.writeSDO("6410", subindex, sizeInHexa, valueInHexa);
    }

    public int readMotorData(String subindex) throws SDORequestException {
        String valueInHexa = this.readSDO("6410", subindex);
        return Integer.parseInt(valueInHexa, 16);
    }

    public boolean checkMotorParameters() throws ClampMotorConfigurationException, SDORequestException {
        int readPolePairNumber;
        int readOutputCurrentLimit;
        int readThermalTimeConstantWinding;
        int readMaxSpeedInCurrentMode;
        int readContinuousCurrentLimit;
        int readPositionSensorType;
        boolean ok = true;
        int readMotorType = this.readMotorType();
        if (readMotorType != this.motor.getMotorType()) {
            ok = false;
        }
        if ((readPositionSensorType = this.readPositionSensorType()) != this.motor.getPositionSensorType()) {
            ok = false;
        }
        if ((readContinuousCurrentLimit = this.readMotorData("01")) != this.motor.getContinuousCurrentLimit()) {
            ok = false;
        }
        if ((readMaxSpeedInCurrentMode = this.readMotorData("04")) != this.motor.getMaxSpeedInCurrentMode()) {
            ok = false;
        }
        if ((readThermalTimeConstantWinding = this.readMotorData("05")) != this.motor.getThermalTimeConstantWinding()) {
            ok = false;
        }
        if ((readOutputCurrentLimit = this.readMotorData("02")) != this.motor.getOutputCurrentLimit()) {
            ok = false;
        }
        if ((readPolePairNumber = this.readMotorData("03")) != this.motor.getPolePairNumber()) {
            ok = false;
        }
        if (!ok) {
            throw new ClampMotorConfigurationException("ERROR in hardware configuration of the motor", this.name, readMotorType, readContinuousCurrentLimit, readMaxSpeedInCurrentMode, readThermalTimeConstantWinding, readOutputCurrentLimit, readPolePairNumber);
        }
        return ok;
    }

    public String displayMotorParameters() throws SDORequestException {
        StringBuilder sb = new StringBuilder("Read decimal values for motor parameters are :");
        int readMotorType = this.readMotorType();
        int readPositionSensorType = this.readPositionSensorType();
        int readContinuousCurrentLimit = this.readMotorData("01");
        int readMaxSpeedInCurrentMode = this.readMotorData("04");
        int readThermalTimeConstantWinding = this.readMotorData("05");
        int readOutputCurrentLimit = this.readMotorData("02");
        int readPolePairNumber = this.readMotorData("03");
        sb.append(" motor type =");
        sb.append(readMotorType);
        sb.append(" position sensor type =");
        sb.append(readPositionSensorType);
        sb.append(" continuousCurrentLimit =");
        sb.append(readContinuousCurrentLimit);
        sb.append(" maxSpeedInCurrentMode =");
        sb.append(readMaxSpeedInCurrentMode);
        sb.append(" thermalTimeConstantWinding =");
        sb.append(readThermalTimeConstantWinding);
        sb.append(" outputCurrentLimit =");
        sb.append(readOutputCurrentLimit);
        sb.append(" polePairNumber =");
        sb.append(readPolePairNumber);
        return sb.toString();
    }

    public void writeCurrent(int aValue) throws BadCommandException, SDORequestException {
        if (!this.isEnable()) {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not ENABLE");
        }
        if (!this.mode.equals((Object)EposMode.CURRENT)) {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not in CURRENT mode");
        }
        if (aValue > this.motor.getContinuousCurrentLimit()) {
            throw new IllegalArgumentException(String.valueOf(aValue) + " is greater than Continuous Current Limit");
        }
        this.motor.setCurrentValue(aValue);
        String currentValueInHexa = Integer.toHexString(aValue);
        this.writeSDO("2030", "0", "2", currentValueInHexa);
    }

    public int readCurrent() throws BadCommandException, SDORequestException {
        if (this.mode.equals((Object)EposMode.CURRENT)) {
            String currentInHexa = this.readSDO("6078", "0");
            return Integer.parseInt(currentInHexa, 16);
        }
        throw new BadCommandException(String.valueOf(this.getName()) + "is not in CURRENT mode");
    }

    public void stopCurrent() throws BadCommandException, SDORequestException {
        if (!this.mode.equals((Object)EposMode.CURRENT)) {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not in CURRENT mode");
        }
        this.writeSDO("2030", "00", "2", "0");
    }

    public void setMaxiVelocity(int velocity) {
        if (velocity > this.motor.maxProfileVelocity) {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + ": can't set parameters greater than maxi value");
        }
        this.motor.maxProfileVelocity = velocity;
    }

    public void setMaxiAcceleration(int acceleration) {
        if (acceleration > this.motor.maxAcceleration) {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + ": can't set parameters greater than maxi value");
        }
        this.motor.maxAcceleration = acceleration;
    }

    public void setVelocity() throws BadCommandException {
        if (!this.mode.equals((Object)EposMode.VELOCITY)) {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not in VELOCITY mode");
        }
    }

    public int readVelocity() throws BadCommandException {
        if (this.mode.equals((Object)EposMode.VELOCITY)) {
            return 0;
        }
        throw new BadCommandException(String.valueOf(this.getName()) + "is not in VELOCITY mode");
    }

    public void stopVelocity() throws BadCommandException {
        if (!this.mode.equals((Object)EposMode.VELOCITY)) {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not in VELOCITY mode");
        }
    }

    public static enum EposMode {
        VELOCITY,
        CURRENT,
        PROFILE_POSITION_MODE,
        POSITION_MODE;

    }
}

