/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.utilities.logging.Logger;

public class CanOpenCommand {
    String commandWord;
    String nodeID;
    String index;
    String subindex;
    String size;
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.fcs");

    public CanOpenCommand(String command, String nodeID, String index, String subindex, String size) {
        this.commandWord = command;
        this.nodeID = nodeID;
        this.index = index;
        this.subindex = subindex;
        this.size = size;
    }

    public CanOpenCommand(String command, String nodeID, String index) {
        this.commandWord = command;
        this.nodeID = nodeID;
        this.index = index;
        this.subindex = null;
        this.size = null;
    }

    public CanOpenCommand(String commandLine) {
        log.debug((Object)("can open command =" + commandLine), new String[0]);
        String[] words = commandLine.split(",");
        this.commandWord = words[0];
        log.debug((Object)("command word:" + this.commandWord), new String[0]);
        this.nodeID = words.length > 0 ? words[1] : "0";
        if (words.length > 1) {
            this.index = words[2];
        }
        if (words.length > 2) {
            this.subindex = words[3];
        }
        if (words.length > 3) {
            this.size = words[4];
        }
    }

    private String buildWsdoCommand() {
        StringBuilder sb = new StringBuilder("wsdo");
        String sep = ",";
        sb.append(sep);
        sb.append(this.nodeID);
        sb.append(sep);
        sb.append(this.index);
        sb.append(sep);
        sb.append(this.subindex);
        sb.append(sep);
        sb.append(this.size);
        log.debug((Object)("Command built = " + sb.toString()), new String[0]);
        return sb.toString();
    }
}

